------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--        I N T E R F A C E S . O S 2 L I B . E X C E P T I O N S           --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.2 $                             --
--                                                                          --
--             Copyright (C) 1997 Free Software Foundation, Inc.            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

--  Thin binding to OS/2 exception mechanism

package Interfaces.OS2Lib.Exceptions is
pragma Preelaborate (Exceptions);

   ---------------
   -- Constants --
   ---------------

   EXCEPTION_MAXIMUM_PARAMETERS         : constant      :=        1;
   --  Signal support

   --  DosSetSigExceptionFocus codes

   SIG_UNSETFOCUS                       : constant      :=        0;
   SIG_SETFOCUS                         : constant      :=        1;


   XCPT_CONTINUE_SEARCH                 : constant      := 16#00000000#;
   XCPT_CONTINUE_EXECUTION              : constant      := 16#FFFFFFFF#;
   XCPT_CONTINUE_STOP                   : constant      := 16#00716668#;


   EH_NONCONTINUABLE                    : constant      :=    16#1#;
   EH_UNWINDING                         : constant      :=    16#2#;
   EH_EXIT_UNWIND                       : constant      :=    16#4#;
   EH_STACK_INVALID                     : constant      :=    16#8#;
   EH_NESTED_CALL                       : constant      :=   16#10#;

   UNWIND_ALL                           : constant      :=        0;


   XCPT_FATAL_EXCEPTION                 : constant      := 16#C0000000#;
   XCPT_SEVERITY_CODE                   : constant      := 16#C0000000#;
   XCPT_CUSTOMER_CODE                   : constant      := 16#20000000#;
   XCPT_FACILITY_CODE                   : constant      := 16#1FFF0000#;
   XCPT_EXCEPTION_CODE                  : constant      := 16#0000FFFF#;


   --  Violation flags in ExceptionInfo

   XCPT_UNKNOWN_ACCESS                  : constant      := 16#00000000#;
   XCPT_READ_ACCESS                     : constant      := 16#00000001#;
   XCPT_WRITE_ACCESS                    : constant      := 16#00000002#;
   XCPT_EXECUTE_ACCESS                  : constant      := 16#00000004#;
   XCPT_SPACE_ACCESS                    : constant      := 16#00000008#;
   XCPT_LIMIT_ACCESS                    : constant      := 16#00000010#;
   XCPT_DATA_UNKNOWN                    : constant      := 16#FFFFFFFF#;


   --  Signal numbers for XCPT_SIGNAL

   XCPT_SIGNAL_INTR                     : constant      :=        1;
   XCPT_SIGNAL_KILLPROC                 : constant      :=        3;
   XCPT_SIGNAL_BREAK                    : constant      :=        4;


   --  Portable non-fatal software generated exceptions

   XCPT_GUARD_PAGE_VIOLATION            : constant      := 16#80000001#;

   --  ExceptionInfo[ 0 ] - Access Code: XCPT_READ_ACCESS
   --  XCPT_WRITE_ACCESS
   --  ExceptionInfo[ 1 ] - FaultAddr

   XCPT_UNABLE_TO_GROW_STACK            : constant      := 16#80010001#;


   --  Portable fatal hardware generated exceptions

   XCPT_DATATYPE_MISALIGNMENT           : constant      := 16#C000009E#;

   --  ExceptionInfo[ 0 ] - Access Code: XCPT_READ_ACCESS
   --  XCPT_WRITE_ACCESS
   --  ExceptionInfo[ 1 ] - Alignment
   --  ExceptionInfo[ 2 ] - FaultAddr

   XCPT_BREAKPOINT                      : constant      := 16#C000009F#;
   XCPT_SINGLE_STEP                     : constant      := 16#C00000A0#;
   XCPT_ACCESS_VIOLATION                : constant      := 16#C0000005#;

   --  ExceptionInfo[ 0 ] - Access Code: XCPT_READ_ACCESS
   --  XCPT_WRITE_ACCESS
   --  XCPT_SPACE_ACCESS
   --  XCPT_LIMIT_ACCESS
   --  XCPT_UNKNOWN_ACCESS
   --  ExceptionInfo[ 1 ] - FaultAddr (XCPT_READ_ACCESS/XCPT_WRITE_ACCESS)
   --  Selector  (XCPT_SPACE_ACCESS)
   --  -1        (XCPT_LIMIT_ACCESS)

   XCPT_ILLEGAL_INSTRUCTION             : constant      := 16#C000001C#;
   XCPT_FLOAT_DENORMAL_OPERAND          : constant      := 16#C0000094#;
   XCPT_FLOAT_DIVIDE_BY_ZERO            : constant      := 16#C0000095#;
   XCPT_FLOAT_INEXACT_RESULT            : constant      := 16#C0000096#;
   XCPT_FLOAT_INVALID_OPERATION         : constant      := 16#C0000097#;
   XCPT_FLOAT_OVERFLOW                  : constant      := 16#C0000098#;
   XCPT_FLOAT_STACK_CHECK               : constant      := 16#C0000099#;
   XCPT_FLOAT_UNDERFLOW                 : constant      := 16#C000009A#;
   XCPT_INTEGER_DIVIDE_BY_ZERO          : constant      := 16#C000009B#;
   XCPT_INTEGER_OVERFLOW                : constant      := 16#C000009C#;
   XCPT_PRIVILEGED_INSTRUCTION          : constant      := 16#C000009D#;


   --  Portable fatal software generated exceptions

   XCPT_IN_PAGE_ERROR                   : constant      := 16#C0000006#;

   --  ExceptionInfo[ 0 ] - FaultAddr

   XCPT_PROCESS_TERMINATE               : constant      := 16#C0010001#;
   XCPT_ASYNC_PROCESS_TERMINATE         : constant      := 16#C0010002#;

   --  ExceptionInfo[ 0 ] - TID of 'terminator' thread

   XCPT_NONCONTINUABLE_EXCEPTION        : constant      := 16#C0000024#;
   XCPT_INVALID_DISPOSITION             : constant      := 16#C0000025#;


   --  Non-portable fatal exceptions

   XCPT_INVALID_LOCK_SEQUENCE           : constant      := 16#C000001D#;
   XCPT_ARRAY_BOUNDS_EXCEEDED           : constant      := 16#C0000093#;
   XCPT_B1NPX_ERRATA_02                 : constant      := 16#C0010004#;


   --  Misc exceptions

   XCPT_UNWIND                          : constant      := 16#C0000026#;
   XCPT_BAD_STACK                       : constant      := 16#C0000027#;
   XCPT_INVALID_UNWIND_TARGET           : constant      := 16#C0000028#;


   --  Signal Exceptions

   XCPT_SIGNAL                          : constant      := 16#C0010003#;


   --  The following flags control the contents of the CONTEXT structure

   CONTEXT_CONTROL                      : constant      := 16#00000001#;

   --  EBP
   CONTEXT_INTEGER                      : constant      := 16#00000002#;

   --  EDI
   CONTEXT_SEGMENTS                     : constant      := 16#00000004#;
   CONTEXT_FLOATING_POINT               : constant      := 16#00000008#;


   --------------------
   -- Context Record --
   --------------------

   --  This is the machine specific register contents for the thread at the
   --  time of the exception.

   --  Note that only the register sets specified by ContextFlags
   --  contain valid data. Conversely, only registers specified in
   --  ContextFlags will be restored if an exception is handled.

   type CONTEXTRECORD is record
      --  Flags which control the contents of the context record
      ContextFlags      : ULONG;
      ctx_env           : AULONG (1 .. 7);
      ctx_stack         : AFPREG (1 .. 8);
      ctx_SegGs         : ULONG;        --  GS register
      ctx_SegFs         : ULONG;        --  FS register
      ctx_SegEs         : ULONG;        --  ES register
      ctx_SegDs         : ULONG;        --  DS register
      ctx_RegEdi        : ULONG;        --  EDI register
      ctx_RegEsi        : ULONG;        --  ESI register
      ctx_RegEax        : ULONG;        --  EAX register
      ctx_RegEbx        : ULONG;        --  EBX register
      ctx_RegEcx        : ULONG;        --  ECX register
      ctx_RegEdx        : ULONG;        --  EDX register
      ctx_RegEbp        : ULONG;        --  EBP register
      ctx_RegEip        : ULONG;        --  EIP register
      ctx_SegCs         : ULONG;        --  CS register
      ctx_EFlags        : ULONG;        --  EFLAGS register
      ctx_RegEsp        : ULONG;        --  ESP register
      ctx_SegSs         : ULONG;        --  SS register
   end record;
   pragma Convention (C, CONTEXTRECORD);

   type PCONTEXTRECORD is access all CONTEXTRECORD;

   --------------------
   -- Exception Info --
   --------------------

   subtype EXCEPTIONINFO is ULONG;

   type EXCEPTIONINFOARRAY is array
     (Natural range 0 .. EXCEPTION_MAXIMUM_PARAMETERS - 1) of EXCEPTIONINFO;

   ----------------------
   -- Exception Report --
   ----------------------

   --  This record contains machine-independent information about
   --  an exception or unwind. No system exception will ever have more
   --  parameters than the value of EXCEPTION_MAXIMUM_PARAMETERS.
   --  User exceptions are not bound to this limit.

   type EXCEPTIONREPORTRECORD;
   type PEXCEPTIONREPORTRECORD is access all EXCEPTIONREPORTRECORD;
   type EXCEPTIONREPORTRECORD is
      record
         ExceptionNum                   : ULONG;
         fHandlerFlags                  : ULONG;
         NestedExceptionReportRecord    : PEXCEPTIONREPORTRECORD;
         ExceptionAddress               : PVOID;
         cParameters                    : ULONG;
         ExceptionInfo                  : EXCEPTIONINFOARRAY;
      end record;

   -----------------------
   -- Exception Handler --
   -----------------------

   type EXCEPTIONREGISTRATIONRECORD;
   type PEXCEPTIONREGISTRATIONRECORD is
     access all EXCEPTIONREGISTRATIONRECORD;

   type ERR is access function
     (Report       : PEXCEPTIONREPORTRECORD;
      Prev_Handler : PEXCEPTIONREGISTRATIONRECORD;
      Context      : PCONTEXTRECORD;
      Data         : System.Address) return ULONG;

   ----------------------------
   -- Exception Registration --
   ----------------------------

   type EXCEPTIONREGISTRATIONRECORD is
      record
         prev_structure   : PEXCEPTIONREGISTRATIONRECORD;
         ExceptionHandler : ERR;
      end record;

   ---------------
   -- Functions --
   ---------------

   function DosSetExceptionHandler (pERegRec : PEXCEPTIONREGISTRATIONRECORD)
      return APIRET;
   pragma Import (C, DosSetExceptionHandler, "DosSetExceptionHandler");

   function DosUnsetExceptionHandler (pERegRec : PEXCEPTIONREGISTRATIONRECORD)
      return APIRET;
   pragma Import (C, DosUnsetExceptionHandler, "DosUnsetExceptionHandler");

   function DosUnwindException
     (phandler          : PEXCEPTIONREGISTRATIONRECORD;
      pTargetIP         : System.Address;
      pERepRec          : PEXCEPTIONREPORTRECORD) return APIRET;
   pragma Import (C, DosUnwindException, "DosUnwindException");

end Interfaces.OS2Lib.Exceptions;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: 1997/08/24 23:20:48;  author: dewar;  state: Exp;
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: 1997/08/24 23:36:23;  author: dewar;  state: Exp;  lines: +2 -2
--  Minor fix to preelaborate pragma
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
