/* OS2savedir.c -- save the list of files in a directory in a string
   Copyright (C) 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by David MacKenzie <djm@gnu.ai.mit.edu>.
   Adapted for OS/2 by Robert O'Brien */

#include <sys/types.h>
#include "OS2dir.h"

#ifdef STDC_HEADERS
#include <stdlib.h>
#include <string.h>
#else
char *malloc ();
char *realloc ();
#ifndef NULL
#define NULL 0
#endif
#endif

char *stpcpy ();

/* Return a freshly allocated string containing the filenames
   in directory DIR, separated by '\0' characters;
   the end is marked by two '\0' characters in a row.
   NAME_SIZE is the number of bytes to initially allocate
   for the string; it will be enlarged as needed.
   Return NULL if DIR cannot be opened or if out of memory.  For OS/2
   the file name string will be followed by a structure  */

char *
savedir (dir, name_size)
     char *dir;
     unsigned name_size;
{
  struct OS2DIR *dirp;
  FILEFINDBUF3	*dp;
  char *name_space;
  char *namep;

  dirp = openOS2Dir (dir);
  if (dirp == NULL)
    return NULL;

  name_space = (char *) malloc (name_size);
  if (name_space == NULL)
    {
      closeOS2Dir (dirp);
      return NULL;
    }
  namep = name_space;

  while ((dp = readOS2Dir (dirp)) != NULL)
    {
      /* Skip "." and ".." (some NFS filesystems' directories lack them). */
      if (dp->achName[0] != '.'
	  || (dp->achName[1] != '\0'
	      && (dp->achName[1] != '.' || dp->achName[2] != '\0')))
	{
	  unsigned size_needed = sizeof(FILEFINDBUF3) + (namep - name_space) + dp->cchName + 2;

	  if (size_needed > name_size)
	    {
	      char *new_name_space;

	      while (size_needed > name_size)
		name_size += 1024;

	      new_name_space = realloc (name_space, name_size);
	      if (new_name_space == NULL)
		{
		closeOS2Dir (dirp);
		  return NULL;
		}
	      namep += new_name_space - name_space;
	      name_space = new_name_space;
	    }
			{char		*pch;
			
			for(pch=dp->achName;	*pch;	++pch)
				*pch = tolower(*pch);
			}
	  namep = stpcpy (namep, dp->achName) + 1;
	memcpy(namep, (char *)dp+4, sizeof(struct findStat));
	namep += sizeof(struct findStat);
	}
    }
  *namep = '\0';
  closeOS2Dir (dirp);
  return name_space;
}
