/* Package of routines to access OS/2 directories.  Used for the following
   reasons:
	1. OS/2 DosFindNext() allows reading directory information for several
	   files at once.  Using this feature should improve performance.
	2. OS/2 DosFindNext() returns the same information as stat().  By 
	   making this information available to the caller an OS/2-aware
	   program can save subsequent calls to stat().
*/

#include "OS2dir.h"

#define MAXDIRECTORIES 20


/* ****************************** closeOS2Dir **************************** */

void		closeOS2Dir(struct OS2DIR *dir)

{
DosFindClose(dir->handle);
}

/* ****************************** openOS2Dir ************************** */
struct OS2DIR			*openOS2Dir(char *path)

{
int			directoryAllocSize;
char				*p_f_name,
					*workPath;
struct OS2DIR			*retVal;
ULONG		attribute;

if(!(retVal=malloc(sizeof(struct OS2DIR))))
	return NULL;
directoryAllocSize = sizeof(FILEFINDBUF3) * MAXDIRECTORIES;
if(!(retVal->findBuffer=(FILEFINDBUF3 *)malloc(directoryAllocSize)))
	{free (retVal);
	return NULL;
	}
workPath = alloca(strlen(path) + 4);
strcpy(workPath, path);
strcat(workPath, "/*");
retVal->handle = 0xffffffff;
retVal->fileCount = MAXDIRECTORIES;
attribute = FILE_ARCHIVED | FILE_DIRECTORY | FILE_READONLY;
if( DosFindFirst(workPath, &(retVal->handle), attribute, retVal->findBuffer, 
	directoryAllocSize, &(retVal->fileCount), 1L))
	{free(retVal->findBuffer);
	free(retVal);
	return NULL;
	}
retVal->buffPtr = retVal->findBuffer;
return retVal;
}

/* ****************************** readOS2Dir ************************** */
FILEFINDBUF3		*readOS2Dir(struct OS2DIR *dir)

{
char				*p_ch,
					*p_f_name;
int					dot_found,
					result;
FILEFINDBUF3		*retVal;

if(!dir->fileCount )
	{dir->fileCount = MAXDIRECTORIES;
	dir->buffPtr = dir->findBuffer;
	if( (result=DosFindNext(dir->handle, (dir->findBuffer), 
	  sizeof(FILEFINDBUF3)*MAXDIRECTORIES, &(dir->fileCount))))
		{DosFindClose(dir->handle);
		return NULL;
		}
	}
--dir->fileCount;
retVal = dir->buffPtr;
dir->buffPtr = (FILEFINDBUF3 *)(dir->buffPtr->oNextEntryOffset 
  + (char *)(dir->buffPtr));
return retVal;
}

