;;; emx-meta.el --- use ALT key for META in text mode

;; Copyright (C) 1992-1996 Eberhard Mattes

;; Author: Eberhard Mattes <mattes@azu.informatik.uni-stuttgart.de>
;; Keywords: emx

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(provide 'emx-meta)

(defun emx-alt-meta (code name)
  "Put the M-NAME (a string) binding on extended scan code CODE."
  (let ((definition (lookup-key esc-map name))
        (event (lookup-key emx-function-keys (vector code))))
    (if (eq definition 'digit-argument)
        (setq definition 'emx-alt-digit-argument))
    (and definition event
        (define-key global-map event definition))))

(defun emx-alt-digit-argument (arg)
  "A version of digit-argument which works with A-digit keys."
  (interactive "P")
  (setq last-command-char
        (if (or (= last-command-char 129) (= last-command-char -127))
            ?0
          (- last-command-char 71)))
  (digit-argument arg))

(emx-alt-meta  14 "\^?")
(emx-alt-meta  16 "q")
(emx-alt-meta  17 "w")
(emx-alt-meta  18 "e")
(emx-alt-meta  19 "r")
(emx-alt-meta  20 "t")
(emx-alt-meta  21 "y")
(emx-alt-meta  22 "u")
(emx-alt-meta  23 "i")
(emx-alt-meta  24 "o")
(emx-alt-meta  25 "p")
(emx-alt-meta  26 "[")
(emx-alt-meta  27 "]")
(emx-alt-meta  28 "\r")
(emx-alt-meta  30 "a")
(emx-alt-meta  31 "s")
(emx-alt-meta  32 "d")
(emx-alt-meta  33 "f")
(emx-alt-meta  34 "g")
(emx-alt-meta  35 "h")
(emx-alt-meta  36 "j")
(emx-alt-meta  37 "k")
(emx-alt-meta  38 "l")
(emx-alt-meta  39 ";")
(emx-alt-meta  40 "`")
(emx-alt-meta  43 "\\")
(emx-alt-meta  44 "z")
(emx-alt-meta  45 "x")
(emx-alt-meta  46 "c")
(emx-alt-meta  47 "v")
(emx-alt-meta  48 "b")
(emx-alt-meta  49 "n")
(emx-alt-meta  50 "m")
(emx-alt-meta  51 ",")
(emx-alt-meta  52 ".")
(emx-alt-meta  53 "/")
(emx-alt-meta 120 "1")
(emx-alt-meta 121 "2")
(emx-alt-meta 122 "3")
(emx-alt-meta 123 "4")
(emx-alt-meta 124 "5")
(emx-alt-meta 125 "6")
(emx-alt-meta 126 "7")
(emx-alt-meta 127 "8")
(emx-alt-meta 128 "9")
(emx-alt-meta 129 "0")
(emx-alt-meta 130 "-")
(emx-alt-meta 131 "=")

;;; emx-meta.el ends here
