/* Copyright (c) 1992 Colin Jensen.  All Rights Reserved. */


/*
 * This file was generated by the SOM Compiler.
 * FileName: ..\..\ibmh\wpscheme.h.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emith: 1.11
 */

/*
 * 
 *  Module Header
 * 
 *  Module Name: WPSCHEME
 * 
 *  OS/2 Presentation Manager Workplace class definitions
 * 
 *  Copyright (c) International Business Machines Corporation 1991, 1992
 * 
 */


#ifndef wpscheme_h
#define wpscheme_h


#include <som.h>

/*
 * Define the class name as an object type
 */
#ifndef WPSchemePalette
#define WPSchemePalette SOMAny
#endif
#include "wppalet.h"

/*
 * Passthru lines: File: "C.h", "after"
 */

      /*
       * Scheme palette entry
       */

      #define CCHSCHEMENAME 30
      #define CCHFONTNAME   60

      typedef struct _SCHEME
      {
	 CELL  cell;	       /* Size of the data that follows */
	 ULONG RGBSysColor[SYSCLR_CSYSCOLORS];
	 ULONG cxBorder;
	 ULONG cyBorder;
	 CHAR  szName[CCHSCHEMENAME+1];  /* Name of this scheme */
	 CHAR  szWindowFont[CCHFONTNAME+1];    /* System font */
	 CHAR  szTitleFont[CCHFONTNAME+1];     /* System font */
	 CHAR  szMenuFont[CCHFONTNAME+1];      /* System font */
	 CHAR  szIconFont[CCHFONTNAME+1];      /* System font */
      } SCHEME;
      typedef SCHEME *PSCHEME;

      /*
       *  Macros to extract RGB colors from a given scheme
       */

      #define SYSCLR_TO_INDEX(s) (s - SYSCLR_HELPHILITE + SYSCLR_CSYSCOLORS - 1)

      #define INDEX_TO_SYSCLR(s) (s + SYSCLR_HELPHILITE - SYSCLR_CSYSCOLORS + 1)

      #define RGB_FROM_SYSCLR(psch,sysclr)			 \
		( psch ? ( psch->RGBSysColor[ SYSCLR_TO_INDEX(sysclr) ] ) \
		       : WinQuerySysColor( HWND_DESKTOP, sysclr, NULL ) )


#define WPSchemePalette_MajorVersion 1
#define WPSchemePalette_MinorVersion 2

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define WPSchemePaletteNewClass wpschc
#pragma linkage(wpschc, system)
#define WPSchemePaletteClassData wpschd
#define WPSchemePaletteCClassData wpschx
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */
/*--------------Migration------------*/
#define WPSchemePalette_classObj WPSchemePaletteClassData.classObject
#define _WPSchemePalette WPSchemePalette_classObj

/*
 * New and Renew macros for WPSchemePalette
 */
#define _WPSchemePaletteNew() (_somNew(WPSchemePaletteClassData.classObject))
#define WPSchemePaletteNew() \
	( WPSchemePaletteClassData.classObject \
		? _WPSchemePaletteNew() \
		: ( WPSchemePaletteNewClass(WPSchemePalette_MajorVersion, WPSchemePalette_MinorVersion), _WPSchemePaletteNew() ) )
#define WPSchemePaletteRenew(buf) \
	( _somRenew(WPSchemePaletteClassData.classObject, buf) )

/*
 * Override method: wpPaintCell
 */
#define WPSchemePalette_wpPaintCell(somSelf,pCell,hps,prcl,fHilite) \
	WPPalette_wpPaintCell(somSelf,pCell,hps,prcl,fHilite)

/*
 * Override method: wpEditCell
 */
#define WPSchemePalette_wpEditCell(somSelf,pCell,hwndPal) \
	WPPalette_wpEditCell(somSelf,pCell,hwndPal)

/*
 * Override method: wpSetupCell
 */
#define WPSchemePalette_wpSetupCell(somSelf,pCellData,cb,x,y) \
	WPPalette_wpSetupCell(somSelf,pCellData,cb,x,y)

/*
 * Override method: wpDragCell
 */
#define WPSchemePalette_wpDragCell(somSelf,pCell,hwndPal,ptlDrag) \
	WPPalette_wpDragCell(somSelf,pCell,hwndPal,ptlDrag)

/*
 * Override method: wpQueryPaletteHelp
 */
#define WPSchemePalette_wpQueryPaletteHelp(somSelf) \
	WPPalette_wpQueryPaletteHelp(somSelf)

/*
 * Override method: wpSetup
 */
#define WPSchemePalette_wpSetup(somSelf,pszSetupString) \
	WPObject_wpSetup(somSelf,pszSetupString)

/*
 * Override method: wpMenuItemHelpSelected
 */
#define WPSchemePalette_wpMenuItemHelpSelected(somSelf,MenuId) \
	WPObject_wpMenuItemHelpSelected(somSelf,MenuId)

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMAny * SOMLINK WPSchemePaletteNewClass(integer4 scemajorVersion,
		integer4 sceminorVersion);
#pragma linkage(WPSchemePaletteNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct WPSchemePaletteClassDataStructure {
	SOMAny *classObject;
} WPSchemePaletteClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct WPSchemePaletteCClassDataStructure {
	somMethodTab *parentMtab;
	somDToken instanceDataToken;
} WPSchemePaletteCClassData;

#endif       /* wpscheme_h */

/*
 * This file was generated by the SOM Compiler.
 * FileName: ..\..\ibmh\wpscheme.h.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emith: 1.11
 */

#ifndef wpscheme_mh
#define wpscheme_mh


/*
 * Define the class name as an object type
 */
#ifndef M_WPSchemePalette
#define M_WPSchemePalette SOMAny
#endif

#define M_WPSchemePalette_MajorVersion 1
#define M_WPSchemePalette_MinorVersion 2

/*
 * External name shortening if required
 */
#ifdef SOM_USE_SHORT_EXTERNAL_NAMES
#define M_WPSchemePaletteNewClass wpschc
#pragma linkage(wpschc, system)
#define M_WPSchemePaletteClassData wpschd
#define M_WPSchemePaletteCClassData wpschx
#endif /* SOM_USE_SHORT_EXTERNAL_NAMES */
/*--------------Migration------------*/
#define M_WPSchemePalette_classObj M_WPSchemePaletteClassData.classObject
#define _M_WPSchemePalette M_WPSchemePalette_classObj

/*
 * New and Renew macros for M_WPSchemePalette
 */
#define _M_WPSchemePaletteNew() (_somNew(M_WPSchemePaletteClassData.classObject))
#define M_WPSchemePaletteNew() \
	( M_WPSchemePaletteClassData.classObject \
		? _M_WPSchemePaletteNew() \
		: ( M_WPSchemePaletteNewClass(M_WPSchemePalette_MajorVersion, M_WPSchemePalette_MinorVersion), _M_WPSchemePaletteNew() ) )
#define M_WPSchemePaletteRenew(buf) \
	( _somRenew(M_WPSchemePaletteClassData.classObject, buf) )

/*
 * Override method: wpclsQueryEditString
 */
#define M_WPSchemePalette_wpclsQueryEditString(somSelf) \
	M_WPPalette_wpclsQueryEditString(somSelf)

/*
 * Override method: wpclsQueryTitle
 */
#define M_WPSchemePalette_wpclsQueryTitle(somSelf) \
	M_WPObject_wpclsQueryTitle(somSelf)

/*
 * Override method: wpclsQueryStyle
 */
#define M_WPSchemePalette_wpclsQueryStyle(somSelf) \
	M_WPObject_wpclsQueryStyle(somSelf)

/*
 * Override method: wpclsQueryDefaultHelp
 */
#define M_WPSchemePalette_wpclsQueryDefaultHelp(somSelf,pHelpPanelId,pszHelpLibrary) \
	M_WPObject_wpclsQueryDefaultHelp(somSelf,pHelpPanelId,pszHelpLibrary)

/*
 * Override method: wpclsQueryIconData
 */
#define M_WPSchemePalette_wpclsQueryIconData(somSelf,pIconInfo) \
	M_WPObject_wpclsQueryIconData(somSelf,pIconInfo)

/*
 * Declare the class creation procedure
 */
SOMEXTERN SOMAny * SOMLINK M_WPSchemePaletteNewClass(integer4 scemajorVersion,
		integer4 sceminorVersion);
#pragma linkage(M_WPSchemePaletteNewClass, system)

/*
 * Declare the class data structure
 */
SOMEXTERN struct M_WPSchemePaletteClassDataStructure {
	SOMAny *classObject;
} M_WPSchemePaletteClassData;

/*
 * Declare the C specific class data structure
 */
SOMEXTERN struct M_WPSchemePaletteCClassDataStructure {
	somMethodTab *parentMtab;
	somDToken instanceDataToken;
} M_WPSchemePaletteCClassData;

#endif       /* wpscheme_h */
