module TinyDraw;

/*	This is the version of the TinyDraw program that is used in chapter
	5 of the Concurrent Clean version 0.8.3 language manual to explain the
	I/O system of Concurrent Clean. It has been changed a bit: lines are
	drawn between the points in Draw Points mode and the update function is
	slightly more efficient.

	Run the program using the "No Console" option (Application options).

	To generate an application for this program the memory of the Clean
	0.8 application should be set to at least 1800K.
	The linker needs an additional 500K of free memory inside or outside
	the Clean 0.8 application.
	To launch the generated application 600K of free memory is needed
	outside the Clean 0.8 application.
*/

import StdInt, StdBool;
import deltaEventIO, deltaIOSystem, deltaPicture, deltaWindow, deltaDialog;

    
::	* IO		:==  IOState State;
::	* State	:== (Point, Colour, Figure, [Figure]);
::	Figure		=  RectF	Colour Rectangle
					|  PointsF	Colour [Point];

    
Start	:: * World	->	* World;
Start world			= 	CloseEvents events` world`;
		where {
		(s, events`)    =:	StartIO [menu, window, dialog] InitState [] events;
		(events, world`)=:	OpenEvents world;
		
		menu  =: MenuSystem [file, color];
		file	=: PullDownMenu FileId "File" Able [
					MenuItem  ToolsId	"Tools..."	(Key 'T')	Able	ShowTools,
					MenuSeparator,
					MenuItem  QuitId	"Quit" 	(Key 'Q')	Able	Quit];
		color	=: PullDownMenu ColorId "Colour" Able [
					MenuRadioItems BlackId [
						MenuRadioItem BlackId "Black" NoKey Able (SetColour BlackColour),
						MenuRadioItem WhiteId "White" NoKey Able (SetColour WhiteColour),
						MenuRadioItem RedId   "Red"   NoKey Able (SetColour RedColour),
						MenuRadioItem GreenId "Green" NoKey Able (SetColour GreenColour),
						MenuRadioItem BlueId  "Blue"  NoKey Able (SetColour BlueColour)]];
		
		window=: WindowSystem [ ScrollWindow 1 (0,0) "Picture"  
						(ScrollBar (Thumb 0) (Scroll 10)) (ScrollBar (Thumb 0) (Scroll 10))
						((0,0), (1000,1000)) (50,50) (500,300) Update_new
						[Mouse Able StartMouse,GoAway Quit,Cursor CrossCursor,StandByWindow]];
		
		dialog=: DialogSystem [ToolsDialog];
		};

InitState	::    State;
InitState = ((0,0), BlackColour, PointsF BlackColour [], []);

ShowTools	:: State IO -> (State, IO);
ShowTools state io =  (state, OpenDialog ToolsDialog io);
						
Quit	:: State IO -> (State, IO);
Quit state io =  (state, QuitIO io);

SetColour	:: Colour State IO -> (State, IO);
SetColour color (pos,oldc,fig,figs) io
	=  ((pos,color,fig,figs), DrawInActiveWindow [SetPenColour color] io);

ToolsDialog	::    DialogDef State IO;
ToolsDialog = CommandDialog ToolsDialogId "Tools"
						[StandByDialog, DialogMargin (Pixel 6) (Pixel 6)] 0 [
							RadioButtons FiguresId Left (Rows 2) RectItemId [
								RadioItem RectItemId  "Draw Rectangles" Able SelectMode,
			 					RadioItem PointsItemId "Draw Points"    Able SelectMode ]];

SelectMode	:: DialogInfo (DialogState State IO) -> DialogState State IO;
SelectMode dinfo dstate =  dstate;

StartMouse	:: MouseState State IO -> (State, IO);
StartMouse (pos, ButtonDown, modifiers) state io
	| open = 	(state1, DrawInActiveWindow draw1 io`);
	= 	(state2, DrawInActiveWindow draw2 io`);
		where {
		(draw1,state1)   =: NewCurrentFigure pos state (
		                                   GetSelectedRadioItemId FiguresId dialog);
		(draw2,state2)   =: OldCurrentFigure pos state;
		(open,dialog,io`)=: GetActiveDialogInfo (ChangeActiveMouseFunction Track io);
		};
StartMouse mouse state io =  (state, io);

NewCurrentFigure	:: Point State DialogItemId -> ([DrawFunction], State);
NewCurrentFigure pos (oldpos,color,fig,figs) figureid
	| figureid == RectItemId = 	([SetPenMode XorMode], (pos, color, RectF color (pos, pos), figs));
	= 	([SetPenMode CopyMode, MovePenTo pos, DrawPoint pos],
	                                  (pos, color, PointsF color [pos], figs));

OldCurrentFigure	:: Point State -> ([DrawFunction], State);
OldCurrentFigure pos (oldpos,color,RectF col ps,figs)
	= 	([SetPenMode XorMode], (pos, color, RectF color (pos, pos), figs));
OldCurrentFigure pos (oldpos,color,PointsF col ps,figs)
	= 	([SetPenMode CopyMode, MovePenTo pos, DrawPoint pos],
	                                  (pos, color, PointsF color [pos], figs));

Track	:: MouseState State IO -> (State, IO);
Track (pos, ButtonUp, mods) (oldpos, color, fig, figs) io
	= 	((pos, color, fig, [fig : figs]), ChangeIOState [mouse, draw] io);
		where {
		mouse=: ChangeActiveMouseFunction StartMouse;
		draw =: DrawInActiveWindow (FinishFigure fig);
		};
Track (pos, buttondown, mods) state=:(oldpos, color, fig, figs) io
	| EqPoint pos oldpos = 	(state, io);
	= 	((pos, color, fig`, figs), DrawInActiveWindow drawfs io);
		where {
		(fig`, drawfs)=: ChangeFigure pos fig;
		};

ChangeFigure	:: Point Figure -> (Figure, [DrawFunction]);
ChangeFigure newpos (RectF color oldrect=:(startpos, oldpos))
	= 	(RectF color newrect, [DrawRectangle oldrect, DrawRectangle newrect]);
		where {
		newrect=: (startpos, newpos);
		};
ChangeFigure newpos (PointsF color points)
	= 	(PointsF color [newpos : points], [LinePenTo newpos]);

FinishFigure	:: Figure -> [DrawFunction];
FinishFigure (RectF color rect) =  [SetPenMode CopyMode, DrawRectangle rect];
FinishFigure points =  [];

Update_new	:: UpdateArea State -> (State, [DrawFunction]);
Update_new area state=:(pos, color, fig, figs)
	=  (state, [DrawFigures figs, SetPenColour color]);
	
DrawFigures	:: [Figure] Picture -> Picture;
DrawFigures [RectF color rect : figs] pic
	=  DrawRectangle rect (SetPenColour color (DrawFigures figs pic));
DrawFigures [PointsF color [point] : figs] pic
	=  DrawPoint point (SetPenColour color (DrawFigures figs pic));
DrawFigures [PointsF color [point:points] : figs] pic
	=  DrawPoints points (MovePenTo point (SetPenColour color (DrawFigures figs pic)));
DrawFigures [figure : figs] pic =  DrawFigures figs pic;
DrawFigures [] pic =  pic;

DrawPoints	:: [Point] Picture -> Picture;
DrawPoints [p : ps] pic =  DrawPoints ps (LinePenTo p pic);
DrawPoints [] pic =  pic;

EqPoint	:: Point Point -> Bool;
EqPoint (x,y) (p,q) =   x == p  &&  y == q ;
	
     
	FileId			:== 1;
		ToolsId			:== 11;
		QuitId			:== 12;
	ColorId			:== 2;
		BlackId			:== 21;
		WhiteId			:== 22;
		RedId				:== 23;
		GreenId			:== 24;
		BlueId			:== 25;
	ToolsDialogId	:== 1;
		FiguresId		:== 11;
			RectItemId		:== 111;
			PointsItemId	:== 112;
