#include <stdlib.h>
#include <stdio.h>
#include <sys/utsname.h>

void help()
{
 printf("Usage: uname [-s|-m|-r|-v]\n");
 printf("-s  Print system name\n");
 printf("-m  Print machine name\n");
 printf("-r  Print system release\n");
 printf("-v  Print system version\n");
}

int main(int argc, char *argv[])
{
 struct utsname si;

 if (argc <= 1)
 {
  help();
  return (1);
 }

 if (uname(&si) == 0)
 {
  int i;

  for (i = 1; i < argc; i++)
   if (argv[i][0] == '-')
    switch (argv[i][1])
    {
     case 'm':
      printf("%s\n", (char *)&si.machine);
      break;
     case 'r':
      printf("%s\n", (char *)&si.release);
      break;
     case 's':
      printf("%s\n", (char *)&si.sysname);
      break;
     case 'v':
      if ((_osmajor == 20) && (_osminor >= 30))
      {
       _osmajor = _osminor / 10;
       _osminor = _osminor % 10;
      }
      printf("%d.%d\n", _osmajor, _osminor);
      break;
     default:
      printf("uname: invalid switch %s", argv[i]);
      help();
      return (1);
    }
 }

 return (0);
}
