#if 0
#!/bin/sh
#
# This file creates a file called "sysdefs.h" which contains CPP defines
# helping to describe the operating system features.  We just take guesses
# by looking at random files.

if [ "$1" ]; then
  sysdefs=$1
else
  sysdefs=./sysdefs.h
fi

rm -f $sysdefs
#endif

/* sysdefs.h -- #defines for your system created by $0.
   Do NOT EDIT this file, since any changes will disappear.
   Instead, edit $0, or config.h, or machines.h. */

#if !defined (_SYSDEFS_H_)
#  define _SYSDEFS_H_

#if 0
# Removes any inherited definitions.
SHLIB=
SYSDEF=

# Test for shared libraries (this is pretty Sunish).
if test -f /lib/ld.so; then
  SHLIB=-DHAVE_SHARED_LIBS
  echo ""					>>$sysdefs
  echo "#define HAVE_SHARED_LIBS"		>>$sysdefs
fi

# Test for shared libraries (this is pretty sVr4ish).
if test -f /usr/ccs/lib/libc.so; then
  if [ "$SHLIB" = "" ]; then
    SHLIB=-DHAVE_SHARED_LIBS
    echo ""					>>$sysdefs
    echo "#if !defined (HAVE_SHARED_LIBS)"	>>$sysdefs
    echo "#  define HAVE_SHARED_LIBS"		>>$sysdefs
    echo "#endif /* HAVE_SHARED_LIBS */"	>>$sysdefs
  fi
  SYSDEF=USGr4
fi

# Get name of maintainer.
if (whoami) >/dev/null 2>&1 && (hostname) >/dev/null 2>&1; then
  WHOAMI=`whoami`@`hostname`;
else
  WHOAMI=`who am i | awk '{ print $1; }'`
fi

if [ "$WHOAMI" = "" ]; then 
  WHOAMI=`id | sed 's/uid=[01-9]*(//' | sed 's/) [) A-Za-z01-9(=,]*//'`
  if (hostname) >/dev/null 2>&1; then
    WHOAMI=$WHOAMI@`hostname`
  elif test -f /usr/bin/uuname -o -f /bin/uuname; then
    WHOAMI=`uuname -l`!$WHOAMI
  fi
fi

if [ "$WHOAMI" = "" ]; then
  WHOAMI=root
fi

echo ""						>>$sysdefs
echo "#if !defined (MAINTAINER)"		>>$sysdefs
echo "#  define MAINTAINER $WHOAMI"		>>$sysdefs
echo "#endif /* MAINTAINER */"			>>$sysdefs

# Try to locate ranlib.  I think this is a bad idea.
if [ -r /usr/bin/ranlib ]; then RANLIB_LOCATION=/usr/bin/ranlib;
elif [ -r /bin/ranlib ]; then RANLIB_LOCATION=/bin/ranlib;
elif [ -r /usr/local/bin/ranlib ]; then RANLIB_LOCATION=/usr/local/bin/ranlib;
elif [ -r /usr/local/gnubin/ranlib ]; then RANLIB_LOCATION=/usr/local/gnubin/ranlib;
fi

# Does this system have /bin/csh?  We don't care about other csh's.
if [ -f /bin/csh ]; then
#endif

#if !defined (HAVE_CSH)
#  define HAVE_CSH
#endif /* HAVE_CSH */

#if 0
if [ "${RANLIB_LOCATION}" ]; then
  echo ""						>>$sysdefs
  echo "#if !defined (RANLIB_LOCATION)" 		>>$sysdefs
  echo "#  define RANLIB_LOCATION ${RANLIB_LOCATION}"	>>$sysdefs
  echo "#endif /* RANLIB_LOCATION */"		 	>>$sysdefs
fi

#
# Is this a Xenix system?
#
if [ -f /xenix ]; then
  SYSDEF="Xenix"
 case "`/bin/uname -p`" in
  *286) SYSDEF="Xenix286" ;;
  *386) SYSDEF="Xenix386" ;;
 esac
fi

#
# Is this a cadmus system?
#
if [ -f /unix ]; then
  if [ -d /generic ]; then   # This is an AIX system.
    SYSDEF="aixpc"
    cat cpp-Makefile | grep -v '/\*\*/' >aix-Makefile
  elif [ -d /etc/conf/kconfig.d ] && [ -f /usr/include/sys/limits.h ]; then
    SYSDEF="isc386"			# This is a 386 running ISC?
  elif [ -f /etc/xlc.cfg ]; then
    if fgrep _IBMR2 /etc/xlc.cfg >/dev/null 2>&1; then
      SYSDEF=RISC6000
      cat cpp-Makefile | grep -v '/\*\*/' >aix-Makefile
    fi
  elif [ -f /bin/4d -a -f /bin/uname ]; then
    case "`uname -r`" in
      3.*) SYSDEF="Irix3" ;;
      4.*) SYSDEF="Irix4" ;;
      *)   SYSDEF="Irix3" ;;
    esac
  elif [ -d /usr/amiga ]; then
    SYSDEF="amiga"		# An Amiga running V.4.
  else
    if [ "$SYSDEF" = "" ]; then
      SYSDEF="cadmus"
    fi

    if [ -f /shlib/libc_s ]; then
      SHLIB=-DHAVE_SHARED_LIBS
      echo ""					>>$sysdefs
      echo "#if !defined (HAVE_SHARED_LIBS)"	>>$sysdefs
      echo "#  define HAVE_SHARED_LIBS"		>>$sysdefs
      echo "#endif /* HAVE_SHARED_LIBS */"	>>$sysdefs
    fi
  fi
fi

if [ "$SYSDEF" != "" ]; then
  echo ""					>>$sysdefs
  echo "#if !defined ($SYSDEF)"			>>$sysdefs
  echo "#  define $SYSDEF"			>>$sysdefs
  echo "#endif /* $SYSDEF */"			>>$sysdefs
fi

if [ -f /usr/include/unistd.h ]; then
  echo ""					>>$sysdefs
  echo "#if !defined (HAVE_UNISTD_H)"		>>$sysdefs
  echo "#  define HAVE_UNISTD_H"		>>$sysdefs
  echo "#endif /* HAVE_UNISTD_H */"		>>$sysdefs
fi
#endif

#if !defined (HAVE_WAIT_H)
#  define HAVE_WAIT_H	
#endif /* HAVE_WAIT_H */

#if !defined (HAVE_ALLOCA_H)
#  define HAVE_ALLOCA_H
#endif /* HAVE_ALLOCA_H */

#if !defined (HAVE_RESOURCE)
#  define HAVE_RESOURCE
#endif /* HAVE_RESOURCE */

#endif /* _SYSDEFS_H_ */
