/* trap.c, created from trap.def. */
#line 23 "(null)trap.def"

#line 38 "(null)trap.def"

#include <sys/types.h>
#include <signal.h>
#include "../shell.h"
#include "../trap.h"

/* The trap command:

   trap <arg> <signal ...>
   trap <signal ...>
   trap -l
   trap [--]

   Set things up so that ARG is executed when SIGNAL(s) N is recieved.
   If ARG is the empty string, then ignore the SIGNAL(s).  If there is
   no ARG, then set the trap for SIGNAL(s) to its original value.  Just
   plain "trap" means to print out the list of commands associated with
   each signal number.  Single arg of "-l" means list the signal names. */

/* Possible operations to perform on the list of signals.*/
#define SET 0			/* Set this signal to first_arg. */
#define REVERT 1		/* Revert to this signals original value. */
#define IGNORE 2		/* Ignore this signal. */

trap_builtin (list)
     WORD_LIST *list;
{
  register int i;
  int list_signal_names = 0;

  while (list)
    {
      if (strcmp (list->word->word, "-l") == 0)
	{
	  list_signal_names++;
	  list = list->next;
	}
      else if (strcmp (list->word->word, "--") == 0)
	{
	  list = list->next;
	  break;
	}
      else if ((*list->word->word == '-') && (list->word->word[1] != '\0'))
	{
	  bad_option (list->word->word);
	  return (EXECUTION_FAILURE);
	}
      else
	break;
    }

  if (!list && !list_signal_names)
    {
      for (i = 0; i < NSIG; i++)
	if (trap_list[i] != (char *)DEFAULT_SIG)
	  printf ("trap -- '%s' %s\n",
		  (trap_list[i] == (char *)IGNORE_SIG) ? "" : trap_list[i],
		  signal_name (i));
      return (EXECUTION_SUCCESS);
    }

  if (list_signal_names)
    {
      int column = 0;

      for (i = 0; i < NSIG; i++)
	{
	  printf ("%2d) %s", i, signal_name (i));
	  if (++column < 4)
	    printf ("\t");
	  else
	    {
	      printf ("\n");
	      column = 0;
	    }
	}
      if (column != 0)
	printf ("\n");
      return (EXECUTION_SUCCESS);
    }

  if (list)
    {
      char *first_arg = list->word->word;
      int operation = SET, any_failed = 0;

      if (signal_object_p (first_arg))
	operation = REVERT;
      else
	{
	  list = list->next;
	  if (*first_arg == '\0')
	    operation = IGNORE;
	  else if (strcmp (first_arg, "-") == 0)
	    operation = REVERT;
	}

      while (list)
	{
	  extern int interactive;
	  int sig;

	  sig = decode_signal (list->word->word);

	  if (sig == NO_SIG)
	    {
	      builtin_error ("%s: not a signal specification",
			     list->word->word);
	      any_failed++;
	    }
	  else
	    {
	      switch (operation)
		{
		  case SET:
		    set_signal (sig, first_arg);
		    break;

		  case REVERT:
		    restore_default_signal (sig);

		    /* Always ignore SIGQUIT. */
		    if (sig == SIGQUIT)
		      signal (SIGQUIT, SIG_IGN);

		    /* Ignore some other signals if we are interactive. */
		    if (interactive)
		      {
			if (sig  == SIGTERM)
			  signal (SIGTERM, SIG_IGN);
#if !defined (__EMX__)						/* 2/93 ROB */
#if defined (JOB_CONTROL)
			if (sig == SIGTTIN ||
			    sig == SIGTTOU ||
			    sig == SIGTSTP)
			  signal (sig, SIG_IGN);
#endif /* JOB_CONTROL */
#endif
		      }
		    break;

		  case IGNORE:
		    ignore_signal (sig);
		    break;
		}
	    }
	  list = list->next;
	}
      return ((!any_failed) ? EXECUTION_SUCCESS : EXECUTION_FAILURE);
    }
}
