/* math.h (emx+gcc) */

#if !defined (_MATH_H)
#define _MATH_H

#if defined (__cplusplus)
extern "C" {
#endif

extern double HUGE;
extern long double _LHUGE;

#define HUGE_VAL        HUGE
#define _LHUGE_VAL      _LHUGE

double acos (double x);
double asin (double x);
double atan (double x);
double atan2 (double y, double x);
double atof (__const__ char *string);
double cbrt (double x);
double ceil (double x);
double cos (double x);
double cosh (double x);
double hypot (double x, double y);
double exp (double x);
double fabs (double x);
double floor (double x);
double fmod (double x, double y);
double frexp (double x, int *exp_ptr);
double ldexp (double x, int exp);
double log (double x);
double log10 (double x);
double modf (double x, double *int_ptr);
double pow (double x, double y);
double rint (double x);
double sin (double x);
double sinh (double x);
double sqrt (double x);
double tan (double x);
double tanh (double x);
double trunc (double x);

long double _acosl (long double x);
long double _asinl (long double x);
long double _atanl (long double x);
long double _atan2l (long double y, long double x);
long double _atofl (__const__ char *string);
long double _cbrtl (long double x);
long double _ceill (long double x);
long double _cosl (long double x);
long double _coshl (long double x);
long double _hypotl (long double x, long double y);
long double _expl (long double x);
long double _fabsl (long double x);
long double _floorl (long double x);
long double _fmodl (long double x, long double y);
long double _frexpl (long double x, int *exp_ptr);
long double _ldexpl (long double x, int exp);
long double _logl (long double x);
long double _log10l (long double x);
long double _modfl (long double x, long double *int_ptr);
long double _powl (long double x, long double y);
long double _rintl (long double x);
long double _sinl (long double x);
long double _sinhl (long double x);
long double _sqrtl (long double x);
long double _tanl (long double x);
long double _tanhl (long double x);
long double _truncl (long double x);

#if !defined (_ABS)                                    /* see also stdlib.h */
#define _ABS
#if !defined (__GNUC__) || __GNUC__ >= 2
extern int abs (int n);
extern long labs (long n);
#else
static __inline__ int abs (int n) { return (n < 0 ? -n : n); }
static __inline__ long labs (long n) { return (n < 0 ? -n : n); }
#endif
#endif

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_MATH_H) */
