/* sys/stat.h (emx+gcc) */

#if !defined (_SYS_STAT_H)
#define _SYS_STAT_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_STAT)
#define _STAT
struct stat
{
  dev_t   st_dev;
  ino_t   st_ino;
  mode_t  st_mode;
  nlink_t st_nlink;
  uid_t   st_uid;
  gid_t   st_gid;
  dev_t   st_rdev;
  off_t   st_size;
  time_t  st_atime;
  time_t  st_mtime;
  time_t  st_ctime;
  long    st_attr;
  long    st_reserved;
};
#endif

#if !defined (_POSIX_SOURCE) && !defined (S_IREAD)
#define S_IREAD  0400     /* Owner: read */
#define S_IWRITE 0200     /* Owner: write */
#define S_IEXEC  0100     /* Owner: exec */
#endif

#if !defined (S_IFMT)
#define S_IFMT   0160000  /* Mask for file type */
#define S_IFIFO  0010000  /* Pipe */
#define S_IFCHR  0020000  /* Character device */
#define S_IFDIR  0040000  /* Directory */
#define S_IFREG  0100000  /* Regular file */
#define S_IFSOCK 0140000  /* Socket */

#define S_ISCHR(mode)  (((mode) & S_IFMT) == S_IFCHR)
#define S_ISDIR(mode)  (((mode) & S_IFMT) == S_IFDIR)
#define S_ISREG(mode)  (((mode) & S_IFMT) == S_IFREG)
#define S_ISFIFO(mode) (((mode) & S_IFMT) == S_IFIFO)
#define S_ISSOCK(mode) (((mode) & S_IFMT) == S_IFSOCK)
#endif

int chmod (__const__ char *name, int pmode);
int fstat (int handle, struct stat *buffer);
int mkdir (__const__ char *name, long mode);
/* mkfifo() */
int stat (__const__ char *name, struct stat *buffer);
int umask (int pmode);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (SYS_STAT_H) */
