#define INCL_NOPM
#define INCL_DOS
#include <os2.h>

#include <sys/emx.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>

time_t unixtime(FDATE fdate, FTIME ftime)
{
  struct tm tm;

  tm.tm_sec  = ftime.twosecs * 2;
  tm.tm_min  = ftime.minutes;
  tm.tm_hour = ftime.hours;
  tm.tm_mday = fdate.day;
  tm.tm_mon  = fdate.month - 1;
  tm.tm_year = fdate.year + 1980 - 1900;
  tm.tm_isdst = 0;

  return mktime(&tm);
}

int stat(const char *name, struct stat *buffer)
{
  FILESTATUS3 fs;
  ULONG nDrive, lMap;
  static USHORT nInode = 1;
  const char *ext = strrchr(name, '.');

  if ( DosQueryPathInfo(name, FIL_STANDARD, &fs, sizeof(fs)) )
  {
    errno = ENOENT;
    return -1;
  }

  if ( isalpha(name[0]) && (name[1] == ':') )
    nDrive = toupper(name[0]) - '@';
  else
    DosQueryCurrentDisk(&nDrive, &lMap);

  buffer -> st_dev = buffer -> st_rdev = nDrive;
  buffer -> st_ino = nInode++;
  buffer -> st_nlink = 1;
  buffer -> st_uid = buffer -> st_gid = 1;

  buffer -> st_size = fs.cbFile;
  buffer -> st_mode = ((fs.attrFile & FILE_DIRECTORY) ? S_IFDIR|0111 : S_IFREG)
                    | ((fs.attrFile & FILE_READONLY) ? 0444 : 0666);

  if ( ext && (stricmp(ext, ".exe") == 0 ||
	       stricmp(ext, ".com") == 0 ||
	       stricmp(ext, ".cmd") == 0 ||
	       stricmp(ext, ".bat") == 0) )
    buffer -> st_mode |= 0111;

  buffer -> st_atime = unixtime(fs.fdateLastAccess, fs.ftimeLastAccess);
  buffer -> st_mtime = unixtime(fs.fdateLastWrite, fs.ftimeLastWrite);
  buffer -> st_ctime = unixtime(fs.fdateCreation, fs.ftimeCreation);

  return 0;
}
