@echo off

rem updatedb -- build locate pathname database
rem csh original by James Woods; sh conversion by David MacKenzie.
rem OS/2 conversion Kai Uwe Rommel
rem Public domain.

rem Entries that match this regular expression are omitted.
set regex="\(^c:/temp$\)\|\(^d:/temp$\)\|\(^e:/temp$\)"

rem Directories to put in the database.
set search=c:/ d:/ e:/

rem The directory containing the subprograms.
set libdir=c:\bin\locate

rem The database file.
set fcodes=%libdir%\locate.db

rem Temporary files.
set bigrams=%tmp%\bigram.tmp
set filelist=%tmp%\filelist.tmp

rem Make a file list. Alphabetize '/' before any other char with 'tr'.
find %search% ^( -type d -regex %regex% ^) -prune -o -print | tr "/" "\001" | sort -f | tr "\001" "/" >%filelist%

rem Compute common bigrams.
%libdir%\bigram <%filelist% | sort -S1024 | uniq -c | sort -nr | gawk "{ if (NR <= 128) print $2 }" | tr -d "\012" >%bigrams%

rem Code the file list.
%libdir%\code %bigrams% <%filelist% >%fcodes%

del %bigrams% %filelist%
