NAME
     diff3 - 3-way differential file comparison

SYNTAX
     diff3 [-ex3] file1 file2 file3

DESCRIPTION
     The diff3 command compares three versions of a file, and
     publishes the ranges of text that disagree, flagged with the
     following codes:

     ====                all three files differ

     ====1               file1 is different

     ====2               file2 is different

     ====3               file3 is different

     The type of change needed to convert a given range of a
     given file to some other is indicated in one of these ways:

     f : n1 a            Text is to be appended after line number
                         n1 in file f, where f = 1, 2, or 3.

     f : n1 , n2 c       Text is to be changed in the range line
                         n1 to line n2.  If n1 = n2, the range
                         may be abbreviated to n1.

     The original contents of the range follows immediately after
     a c indication.  When the contents of two files are identi-
     cal, the contents of the lower-numbered file is suppressed.

OPTIONS
     -3                  Produces an ed editor script containing
                         the changes between file1 and file2 that
                         are to be incorporated into file3.

     -e                  Produces an ed editor script containing
                         the changes between file2 and file3 that
                         are to be incorporated into file1.

     -x                  Produces an ed editor script containing
                         the changes among all three files.

EXAMPLES
     Under the -e option, diff3 publishes a script for the editor
     ed that incorporates into file1 all changes between file2
     and file3 -- that is, the changes that would normally be
     flagged ==== and ====3.  Option -x (-3) produces a script to
     incorporate only changes flagged ==== (====3).  The follow-
     ing command applies the resulting script to `file1':

          (cat script; echo '1,$p') | ed - file1

RESTRICTIONS
     Text lines that consist of a single `.' defeat -e.

FILES
     /tmp/d3?????
     /usr/lib/diff3

SEE ALSO
     diff(1)

------------------------

NAME
     diff3 - GNU diff3, display line-by-line differences between
     3 files, including binary files

SYNOPSIS
     diff [ options ] filename1 filename2 filename3

WARNING
     This manual page is updated only occasionally, because the
     GNU project does not use nroff.

DESCRIPTION
     This version of diff3 has all of BSD diff3's features, with
     the following additional features.

     An input file may end in a non-newline character.  With the
     -m option, an incomplete last line stays incomplete.  Other
     output styles treat incomplete lines like diff.

     The file name '-' denotes the standard input.  It can appear
     at most once.

OPTIONS
     GNU diff3 has the following additional options:

     -a             Always treat files as text and compare them
                    line-by-line, even if they do not appear to
                    be text.

     -i             Include 'w' and 'q' commands at the end of
                    the output, to write out the changed file,
                    thus emulating System V behavior.  One of the
                    edit script options -e, -E, -x, -X, -3 must
                    also be specified.

     -m             Apply the edit script to the first file and
                    send the result to standard output.  Unlike
                    piping diff3's output to ed(1), this works
                    even for binary files and incomplete lines.
                    -E is assumed if no edit script option is
                    specified.  This option is incompatible with
                    -i.

     -L label       Use the specified label for lines output by
                    the -E and -X options, one of which must also
                    be specified.  This option may be given zero,
                    one, or two times; the first label marks
                    <<<<<<< lines and the second marks >>>>>>>
                    lines.  The default labels are the names of
                    the first and third files on the command
                    line.  Thus `diff3 -L X -L Z -E A B C' acts
                    like `diff3 -E A B C', except that the output
                    looks like it came from files named X and Z
                    rather than from files named A and C.

DIAGNOSTICS
     Exit status 0 means success, 1 means overlaps were found and
     -E or -X was specified, and 2 means trouble.

SEE ALSO
     diff(1), ed(1)
