NAME
     diff - differential file and directory comparator (Berkeley
     Version)

SYNOPSIS
     gdiff [[ -lNrs ] [ -aBcefHhnpT ] [ -C cnt ] [ -FI regexp ] [
     -biwt ]] ...  dir1 dir2
     gdiff [[ -cefhn ] [ -biwt ]] ...  file1 file2

DESCRIPTION
     If both arguments are directories, gdiff sorts the contents
     of the directories by name, and then runs the regular file
     gdiff algorithm (described below) on text files which are
     different.  Binary files which differ, common subdirec-
     tories, and files which appear in only one directory are
     listed.  Options when comparing directories are:

     -l   long output format; each text file diff is piped
          through pr(1) to paginate it, other differences are
          remembered and summarized after all text file differ-
          ences are reported.

     -r   causes application of gdiff recursively to common sub-
          directories encountered.

     -s   causes gdiff to report files which are the same, which
          are otherwise not mentioned.

     -Sname
          starts a directory gdiff in the middle beginning with
          file name.

     When run on regular files, and when comparing text files
     which differ during directory comparison, gdiff tells what
     lines must be changed in the files to bring them into agree-
     ment.  Except in rare circumstances, gdiff finds a smallest
     sufficient set of file differences.  If neither file1 nor
     file2 is a directory, then either may be given as `-', in
     which case the standard input is used.  If file1 is a direc-
     tory, then a file in that directory whose file-name is the
     same as the file-name of file2 is used (and vice versa).

     There are several options for output format; the default
     output format contains lines of these forms:

          n1 a n3,n4
          n1,n2 d n3
          n1,n2 c n3,n4

     These lines resemble ed commands to convert file1 into
     file2.  The numbers after the letters pertain to file2.  In
     fact, by exchanging `a' for `d' and reading backward one may
     ascertain equally how to convert file2 into file1.  As in
     ed, identical pairs where n1 = n2 or n3 = n4 are abbreviated
     as a single number.

     Following each of these lines come all the lines that are
     affected in the first file flagged by `<', then all the
     lines that are affected in the second file flagged by `>'.

     Except for -b, -w, -i or -t which may be given with any of
     the others, the following options are mutually exclusive:

     -e       produces a script of a, c and d commands for the
              editor ed, which will recreate file2 from file1.
              In connection with -e, the following shell program
              may help maintain multiple versions of a file.
              Only an ancestral file ($1) and a chain of
              version-to-version ed scripts ($2,$3,...) made by
              gdiff need be on hand.  A `latest version' appears
              on the standard output.

                      (shift; cat $*; echo '1,$p') | ed - $1

              Extra commands are added to the output when compar-
              ing directories with -e, so that the result is a
              sh(1) script for converting text files which are
              common to the two directories from their state in
              dir1 to their state in dir2.

     -f       produces a script similar to that of -e, not useful
              with ed, and in the opposite order.

     -n       produces a script similar to that of -e, but in the
              opposite order and with a count of changed lines on
              each insert or delete command.  This is the form
              used by rcsdiff(1d).

     -c       produces a diff with lines of context.  The default
              is to present 3 lines of context and may be
              changed, e.g to 10, by -c10.  With -c the output
              format is modified slightly: the output beginning
              with identification of the files involved and their
              creation dates and then each change is separated by
              a line with a dozen *'s.  The lines removed from
              file1 are marked with `- '; those added to file2
              are marked `+ '.  Lines which are changed from one
              file to the other are marked in both files with
              with `! '.

              Changes which lie within <context> lines of each
              other are grouped together on output.  (This is a
              change from the previous ``diff -c'' but the
              resulting output is usually much easier to inter-
              pret.)

     -h       does a fast, half-hearted job.  It works only when
              changed stretches are short and well separated, but
              does work on files of unlimited length.

     -b       causes trailing blanks (spaces and tabs) to be
              ignored, and other strings of blanks to compare
              equal.

     -w       is similar to -b but causes whitespace (blanks and
              tabs) to be totally ignored.  E.g.,
              ``if ( a == b )'' will compare equal to
              ``if(a==b)''.

     -i       ignores the case of letters.  E.g., ``A'' will com-
              pare equal to ``a''.

     -t       will expand tabs in output lines.  Normal or -c
              output adds character(s) to the front of each line
              which may screw up the indentation of the original
              source lines and make the output listing difficult
              to interpret.  This option will preserve the origi-
              nal source's indentation.

FILES
     /tmp/d?????
     /usr/local/dist/gdiff for directory diffs
     /bin/pr

SEE ALSO
     cmp(1), cc(1), comm(1), ed(1), gdiff3(1d)

DIAGNOSTICS
     Exit status is 0 for no differences, 1 for some, 2 for trou-
     ble.

BUGS
     Editing scripts produced under the -e or -f option are naive
     about creating lines consisting of a single `.'.

     When comparing directories with the -b, -w or -i options
     specified, diff first compares the files ala cmp, and then
     decides to run the diff algorithm if they are not equal.
     This may cause a small amount of spurious output if the
     files then turn out to be identical because the only differ-
     ences are insignificant blank string or case differences.

--------------------

NAME
     diff - GNU diff, display line-by-line differences between
     files, including binary files

SYNOPSIS
     diff [ options ] filename1 filename2
     diff [ options ] directory1 directory2

WARNING
     This manual page is updated only occasionally, because the
     GNU project does not use nroff.

DESCRIPTION
     This version of diff provides all the features of BSD's
     diff.  It has the following additional features.

     An input file may end in a non-newline character.  If so,
     its last line is called an incomplete line and is dis-
     tinguished on output from a full line.  In the default, -c,
     and -u output styles, an incomplete output line is followed
     by a diagnostic line that starts with \.  With -n, an incom-
     plete line is output without a trailing newline.  Other out-
     put styles (-D, -e, -f) cannot represent an incomplete line,
     so they pretend that there was a newline, and -e and -f also
     print an error message.

     For example, suppose F and G are one-byte files that contain
     just `f' and `g', respectively.  Then `diff F G' outputs

          1c1
          < f
          \ No newline at end of file
          ---
          > g
          \ No newline at end of file

     (The exact diagnostic message may differ, e.g. for non-
     English locales.) `diff -n F G' outputs the following
     without a trailing newline:

          d1 1
          a1 1
          g

     `diff -e F G' sends two diagnostics to standard error and
     the following to standard output:

          1c
          g
          .

     A file is considered to be text if its first characters are
     all in the ISO 8859 character set; BSD's diff uses ASCII.

OPTIONS
     GNU diff has the following additional options:

     -a             Always treat files as text and compare them
                    line-by-line, even if they do not appear to
                    be text.

     -B             Ignore changes that just insert or delete
                    blank lines.

     -C #           Request -c format and specify number of con-
                    text lines.

     -F regexp      In context format, for each unit of differ-
                    ences, show some of the last preceding line
                    that matches the specified regexp.

     -H             Use heuristics to speed handling of large
                    files that have numerous scattered small
                    changes.  The algorithm becomes asymptoti-
                    cally linear for such files!

     -I regexp      Ignore changes that just insert or delete
                    lines that match the specified regexp.

     -L label       Use the specified label in file header lines
                    output by the -c option.  This option may be
                    given zero, one, or two times, to affect nei-
                    ther label, just the first file's label, or
                    both labels.  A file's default label is its
                    name, a tab, and its modification date.

     -N             In directory comparison, if a file is found
                    in only one directory, treat it as present
                    but empty in the other directory.

     -p             equivalent to -c -F'^[_a-zA-Z]'.  This is
                    useful for C code because it shows which
                    function each change is in.

     -T             Print a tab rather than a space before the
                    text of a line in normal or context format.
                    This causes the alignment of tabs in the line
                    to look normal.

     -u [#]         Produce unified style output with # context
                    lines (default 3).  This style is like -c,
                    but it is more compact because context lines
                    are printed only once.  Lines from just the
                    first file are marked '-'; lines from just
                    the second file are marked '+'.

SEE ALSO
     diff3(1)
