/*************************************************************************/
/*  XENED installation file - Creates a wps-object for Xened             */
/*  To run this file, just type "install" on the OS/2 command line.      */
/*************************************************************************/

PARSE SOURCE operSystem . sourceFile

IF \(operSystem = "OS/2") THEN DO
    SAY "Please use only with IBM-OS/2 Operating system!"
    EXIT
    END

/*************************************************************************/

'@ECHO OFF'

CALL rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
CALL sysloadfuncs

/*************************************************************************/

XenedDir = FILESPEC("drive", sourceFile)FILESPEC("path", sourceFile)

CALL SysFileTree XenedDir"XENED.EXE",'file','F'
IF file.0 = 0 THEN DO
    SAY "XENED.EXE was not found in the same directory as ",
    FILESPEC("name",sourceFile)

    DO UNTIL \(file.0 = 0)
        SAY ""
        SAY "Please give the full path to the file XENED.EXE."
        SAY "(Press ENTER/RETURN alone to exit)"
        PULL XenedDir
        IF XenedDir = "" THEN EXIT
        IF (FILESPEC("drive",XenedDir) = "") | (FILESPEC("path",XenedDir) = "")
        THEN SAY 'You must give a full path in format "d:\path\"'
        ELSE DO
            IF \(SUBSTR(XenedDir,length(XenedDir),1) = "\" )
            THEN XenedDir = XenedDir"\"
            CALL SysFileTree XenedDir"XENED.EXE",'file','F'
            IF file.0 = 0
            THEN SAY "Can not find" XenedDir"XENED.EXE there - please give the right directory"
            END
        END
    SAY ""
    END

/*************************************************************************/

setup = 'PROGTYPE=OS2;EXENAME='XenedDir'XENED.EXE;STARTUPDIR='XenedDir';'
setup = setup'ICONFILE 'XenedDir'XENED.ICO;'

SAY "* Creating XENED wps-object ..."
check = SysCreateObject('WPProgram', 'Xened 0.97.1', '<WP_DESKTOP>', setup)

IF check = 0 THEN DO
    SAY "* Could not create wps-object!"
    SAY "  (Does perhaps an object for Xened already exist?)"
    CALL CHAROUT , "* Do you want to update the existing object [Y/N] ? "
    PULL answer
    IF \(SUBSTR(answer,1,1) = "Y") THEN EXIT

    SAY "* Updating Xened wps-object ..."
    check = SysCreateObject('WPProgram','Xened 0.97.1','<WP_DESKTOP>',setup,"update")

    IF check = 0 THEN DO
        SAY ""
        SAY "* Sorry, object-creation failed again. Aborting ..."
        EXIT
        END
    ELSE DO
        SAY ""
        SAY "* Xened wps-object updated successfully!"
        END
    END
ELSE DO
    SAY ""
    SAY "* Xened wps-object created successfully!"
    END

CALL SysFileTree XenedDir"XENED.ICO",'file','F'
IF file.0 = 0 THEN DO
    SAY "* XENED.ICO not found!"
    SAY "  Please set the XENED icon manually."
    SAY ""
    END

/*************************************************************************/

setup = 'PROGTYPE=OS2;EXENAME='VIEW.EXE';PARAMETERS='XenedDir'XENED.INF;'
setup = setup'ICONFILE 'XenedDir'XENDOC.ICO;'

SAY ""
SAY "* Creating XENED documentation wps-object ..."
check = SysCreateObject('WPProgram', 'Xened 0.97.1 Documentation', '<WP_DESKTOP>', setup)

IF check = 0 THEN DO
    SAY "* Could not create wps-object!"
    SAY "  (Does perhaps an object for Xened documentation already exist?)"
    CALL CHAROUT , "* Do you want to update the existing object [Y/N] ? "
    PULL answer
    IF \(SUBSTR(answer,1,1) = "Y") THEN EXIT

    SAY "* Updating Xened documentation wps-object ..."
    check = SysCreateObject('WPProgram','Xened 0.97.1 Documentation','<WP_DESKTOP>',setup,"update")

    IF check = 0 THEN DO
        SAY ""
        SAY "* Sorry, object-creation failed again. Aborting ..."
        EXIT
        END
    ELSE DO
        SAY ""
        SAY "* Xened documentation wps-object updated successfully!"
        END
    END
ELSE DO
    SAY ""
    SAY "* Xened documentation wps-object created successfully!"
    END

SAY ""
SAY "* Read "XenedDir"XENED.INF for details."

CALL SysFileTree XenedDir"XENDOC.ICO",'file','F'
IF file.0 = 0 THEN DO
    SAY "* XENDOC.ICO not found!"
    SAY "  Please set the XENED documentation icon manually."
    SAY ""
    END

EXIT
