/*****************************/
/* REXX command-line install */
/*****************************/
/*         10000             */
/*****************************/

'@echo off'
'cls'

SIGNAL ON FAILURE
SIGNAL ON ERROR

CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
CALL SysLoadFuncs

CurDir=DIRECTORY()

say ''
say '*********************************************'
say '*       Welcome to the 10000 Install        *'
say '*********************************************'
say ''
say 'The install will create objects on your desktop using the'
say 'current directory.  If this is not what you want, move the'
say 'program file(s) to their destination directory and re-run'
say 'the install program.'
say ''
call charout,'Press any key to start Install or Q to quit...'
parse upper value SysGetKey('NOECHO') with key
if key='Q' then
  EXIT

say ''

classname='WPFolder'
title='10000'
location='<WP_DESKTOP>'
setup='CCVIEW=NO;ICONFILE='||CurDir||'\TEN_FOLD.ICO;OBJECTID=<TEN_FOLDER>;'
option='R'
call BldObj

classname='WPProgram'
title='10000'
location='<TEN_FOLDER>'
setup='EXENAME='||CurDir||'\10000.EXE;OBJECTID=<TEN_PROG>;'
option='R'
call BldObj

classname='WPProgram'
title='10000'||'0A'x||'Information'
location='<TEN_FOLDER>'
setup='EXENAME=VIEW.EXE;ICONFILE='||CurDir||'\TEN_INF.ICO;PARAMETERS='||CurDir||'\10000.INF;OBJECTID=<TEN_INFO>;'
option='R'
call BldObj

classname='WPProgram'
title='Order Form'
location='<TEN_FOLDER>'
setup='EXENAME=EPM.EXE;PARAMETERS='||CurDir||'\ORDER.FRM;OBJECTID=<TEN_ORDERFRM>;'
option='R'
call BldObj

if STREAM('VROBJ.DLL','C','QUERY EXISTS') \= '' then
do
  StartupDrive=SysSearchPath('PATH','CONFIG.SYS')
  StartupDrive=FILESPEC("drive",StartupDrive)
  say ''
  say 'VROBJ.DLL must be present in a directory contained in the LIBPATH'
  say 'variable in config.sys.  I recommend '||StartupDrive||'\OS2\DLL'
  call charout,'Would you like to copy VROBJ.DLL to '||StartupDrive||'\OS2\DLL (Y/N)?'
  parse upper value SysGetKey('NOECHO') with key
  say ''
  if key ='Y' then
       'COPY VROBJ.DLL '||StartupDrive||'\OS2\DLL > nul'
  else
       say 'Okay, then remember to place VROBJ.DLL in a directory contained in your LIBPATH!'
end

say ''
call charout,'Press any key to exit...'
key=SysGetKey('NOECHO')
EXIT

/* Build Object Procedure */
BldObj:
call charout ,'Building: 'title substr(classname,3,)

result = SysCreateObject(classname, title, location, setup, option)

If result=1 Then call charout ,' ...Created!'
else
  call charout ,' ...Not created! Return code='result
say ' '
Return

/*****************************************************************************/
 * Standard REXX program error handler
 *****************************************************************************/
ERROR:
    say ''
    SAY 'An install error has occurred...'
    EXIT

FAILURE:
    say ''
    SAY 'An install error has occurred...'
    EXIT

/* End */
