/*
   Title  : Racer, Racing car game version 1.0
   Author : Antonino Iannella, August 1995
   Description:
          A simple command-line car being driven down a
          fast, winding track.   The white lines are the
          boundaries in which to keep the '' car.

          It is compilable under GCC (with no 
          optimisations) using

          gcc -Zomf -Zsys -o racer.exe racer.c

          If using a different compiler, the only command
          which may need changing is the _read_kbd() in
          function main().  It just gets any character
          without waiting for user input, and puts it in
          'let'.  This is not the best way to read keyboard
          input, so if anyone knows a better method, I'd
          like to know...
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/kbdscan.h>

#define  SCR_WIDTH   80   /* Defines the screen width (SCR_WIDTH characters) */
#define  TRACK_WIDTH 20     /* Track width; the space between the boundaries */

int cpos,                       /* Car position from left side of the screen */
    lpost,
    rpost;                             /* Set left and right road boundaries */

unsigned long rnd;                                /* Random number generator */

/* ------------------------ GRUNDIG - Made for you! ------------------------ */

void Oneline(void)
/* Draws the next line, representing the track
   and car, at the bottom of the screen.
*/
{
  int pt1,
      pt2,
      pt3;                                                       /* Counters */

  rpost=lpost+TRACK_WIDTH;

  for(pt1=0; pt1 < lpost; pt1++)                           /* Draw left edge */
   printf(" ");

  printf("");

  for(pt2=lpost+1; pt2 < cpos; pt2++)                        /* Draw the car */
   printf(" ");

  printf("");

  for(pt3=cpos+1; pt3 < rpost; pt3++)                     /* Draw right edge */
   printf(" ");

  printf("\n");
}

/* ------------------------ GRUNDIG - Made for you! ------------------------ */

void Crash()
/* Exits the game if 'q' was pressed, or when
   the car 'crashes' into a boundary.
*/
{
  printf("\nThank you for trying Racer!\n");
  printf("Remember to tell me what you think! (9308390r@lux.levels.unisa.edu.au)\n");
  exit(0);
}

/* ------------------------ GRUNDIG - Made for you! ------------------------ */

void track(int kkey)
/* Moves the car left or right, and uses random
   numbers to decide which way to move the track.
*/
{
  switch (kkey)
  {
    case 75 : cpos--;                                          /* Move left  */
              Oneline();
              break;

    case 77 : cpos++;                                          /* Move right */
              Oneline();
              break;

    default : Oneline();

  }

/* RAND_MAX defined in <stdlib.h>, is the maximum random number.
   This part says that if the random number is less than 1 3rd of RAND_MAX,
   move left.  If between 1 and 2 3rds, don't move.  Else, move right. */

  if ((cpos==lpost) || (cpos==lpost+TRACK_WIDTH))
    Crash();

  rnd=rand();

  if ((rnd< (RAND_MAX/3)) && (lpost>0))
     lpost--;
  else
    if ((rnd> (2*(RAND_MAX/3))) && (rpost < SCR_WIDTH))
     lpost++;
}

/* ------------------------ GRUNDIG - Made for you! ------------------------ */

main()
{
  char let;

  lpost=25;                                        /* Set left road boundary */
  cpos=lpost+TRACK_WIDTH/2;                       /* Initialise car position */

  printf("\nRacer version 1.0 by Antonino Iannella, July 1995.\n");

  while(1)
  {
    let=_read_kbd(0, 0, 0);        /* No echoing, no waiting, disable CTRL-C */

    if ((let=='Q') || (let=='q'))
      Crash();
    else
      track(let);                                        /* Print next track */
  }
}