/* PROGRAM:  setup.cmd                           AUTHOR:  C.Cortez  */
/* CREATED:  07/10/96                                               */
/* DESCRIPTION:  Setup program GUESS                                */
/*                                                                  */
/* ================================================================ */
/*REVISION:                                                         */
/*   Date     Description                                           */
/* ---------------------------------------------------------------- */
/*                                                                  */
/* **************************************************************** */
/* M A I N L I N E                                                  */
/* **************************************************************** */
if LOADREXXUTIL()  then
   signal PAU

/*
 * make sure needed files are in directory
 */
   if \INIT() then
   do
      errlvl = 1
      signal err
   end

/*
 * Create desktop object
 */
   call CRTOBJ
 
signal PAU
/* **************************************************************** */
/* S U B R O U T I N E S                                            */
/* **************************************************************** */
/* INIT: Initialzation routine                                      */
/* ---------------------------------------------------------------- */
INIT: 
   rc = 1
   knt = 0
   ok = SysFileTree("*.*","files.","FO")
   do lp = 1 to files.0
      fname = reverse(files.lp)
      c=pos("\",fname) - 1
      file = reverse(left(fname,c))
      if (file = "GUESS.EXE") | (file = "VROBJ.DLL") | (file = "COLOURS.ICO") then
         knt = knt + 1
   end /* do */
   if knt < 3 then
      rc = 0

RETURN rc

/* **************************************************************** */
/* CRTOBJ:  Create object on desktop                                */
/* ---------------------------------------------------------------- */
CRTOBJ:

   rc = SysFileTree("..\guess.","dirs.","DO")

   setupstr = "ICONFILE="dirs.1"\colours.ico"
   setupstr = setupstr || ";EXENAME="dirs.1"\GUESS.EXE"
   setupstr = setupstr || ";STARTUPDIR="dirs.1
 
   rc= SysCreateObject("WPProgram","Guess","<WP_DESKTOP>",setupstr,"ReplaceIfExists")

RETURN

/* **************************************************************** */
/* LOADRESSUTIL:  Loads additional Rexx functions                   */
/* ---------------------------------------------------------------- */
LOADREXXUTIL:  PROCEDURE
   if rxfuncquery('sysloadfuncs') then
   do
      if rxfuncadd('sysloadfuncs', 'rexxutil', 'sysloadfuncs') then
      do
         say 'Error:  Couldn''''t load RexxUtil Library.'
         return 1
      end /* do */
      call sysloadfuncs
   end /* do */
return 0

/* **************************************************************** */
/* ERROR HANDLING ROUTINE                                           */
/* **************************************************************** */
ERR:
   if errlvl = 1 then
   do
      say "One or more files are missing.  Please make sure the following files"
      say "are in this directory."
      say ""
      say "     VROBJ.DLL"
      say "     GUESS.EXE"
      say "     COLOURS.ICO"
   end
/* **************************************************************** */
/* E N D   O F   P R O G R A M                                      */
/* **************************************************************** */

PAU:
exit
