#ifndef _GC_H_
#define _GC_H_



#define INCL_DOSSEMAPHORES
#define INCL_GPI
#define INCL_WIN
#define INCL_DOSMODULEMGR
#include <os2.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include<time.h>


#define BIGONES 50
#define SMALLONES 10
#define DESTROYED 1234

#define const_activeplayers 7

#define const_ShipTypes 50
#define const_maxstars 500
#define const_maxplanets 1000


#define const_NamesAvailable 800
#define const_Ships 3000
#define const_imps 50
#define const_wonds 25
#define const_quads 25


#define const_maxplayers 8
#define const_techs 150
#define const_starsinquad 8
#define const_shipsinquad 100
#define const_shipsonworld 8
#define const_quad_width 15
#define const_quad_height 15
#define const_planetsinstar 5
#define const_traderoutes 10
#define CONST_QUAD_MIN_X 1
#define CONST_QUAD_MAX_X (const_quad_width-CONST_QUAD_MIN_X)
#define CONST_QUAD_MIN_Y 1
#define CONST_QUAD_MAX_Y (const_quad_height-CONST_QUAD_MIN_Y)
#define const_NEWS 500
#define NOTACTIVE 7
#define const_leases 1000

#define INDEPENDENT 7
#define REBELLION 10
#define UNREST 9

#define WONDERMADE 20

#define ATTACK 99
#define ENEMYALLY 100

#define ALIENWANTSPEACE 97
#define ALIENWANTSHELP 27
#define ALIENWANTSTRIBUTE 3
#define ALIENWANTSALLIANCE 61
#define HUMANINITIATED 5
#define ALIENWANTSWAR 60
#define ALLYHELP 62

#define PLANET_TYPE_THRESHOLD PLANET12

#define PLANET1 300

#define MOVE_NONE        0
#define MOVE_NORTH       1
#define MOVE_NORTHEAST   2
#define MOVE_EAST        3
#define MOVE_SOUTHEAST   4
#define MOVE_SOUTH       5
#define MOVE_SOUTHWEST   6
#define MOVE_WEST        7
#define MOVE_NORTHWEST   8
#define MOVE_LEAVEPLANET 9
#define MOVE_DECOMMISSION 10

#define HUMANDEAD 80
#define COMPUTERDEAD 81
#define HUMANGOD 82
#define COMPUTERGOD 83


#define WM_NEWQUADRANT WM_USER+900
#define WM_MOVEMENT WM_USER+901
#define WM_ENDVIEW WM_USER+902
#define WM_NEWVIEW WM_USER+903
#define WM_NEWDISCOVERY WM_USER+905
#define LOAD_PLANET WM_USER+904
#define WM_PROJECTCOMPLETED WM_USER+906
#define WM_SHIPCOMPLETED WM_USER+907
#define WM_STARDISCOVERY WM_USER+908
#define WM_COLONYSHIPINSYSTEM WM_USER+909
#define WM_SHOWSTAR WM_USER+910
#define WM_ENTERSTARNAME WM_USER+911
#define WM_ENTERSTARNAME2 WM_USER+912
#define WM_STARTSHOW WM_USER+913
#define WM_WONDERCOMPLETED WM_USER+914
#define WM_SHOWSHIPS WM_USER+915
#define WM_SHOWDISC WM_USER+916
#define WM_KILLPOINTER WM_USER+917
#define WM_KILLSHIELD WM_USER+918
#define WM_MONEYLOW WM_USER+919
#define WM_MONEYOUT WM_USER+920
#define WM_COMPUTERMOVE WM_USER+921
#define WM_CREATION WM_USER+922
#define WM_SHIPMOVEMENT WM_USER+923
#define WM_SHOWSTARS WM_USER+924
#define WM_KILLSTAR WM_USER+925
#define WM_CREATENEWSTAR WM_USER+926
#define WM_ANIMATESHIP WM_USER+927
#define WM_SHOWMOVES WM_USER+928
#define WM_SWITCH WM_USER+929
#define WM_INVADE WM_USER+930
#define WM_TRADE WM_USER+931
#define WM_BOOM WM_USER+932
#define WM_GCERROR WM_USER+933
#define WM_GAMEOVER WM_USER+934
#define WM_DIPLOMACY WM_USER+935
#define WM_AICOMPLETE WM_USER+936
#define WM_AUTOPILOT WM_USER+937
#define WM_ENDTURN WM_USER+938
#define WM_NEWTURN WM_USER+939
#define WM_WAR WM_USER+940
#define WM_SHOWASHIP WM_USER+941
#define WM_DESTROYSHIP WM_USER+942
#define WM_NEWGAME WM_USER+943
#define WM_TRADEWAR WM_USER+944
#define WM_REBELLION WM_USER+945
#define WM_NEWRELATIONS WM_USER+946
#define WM_DESTROYSTAR WM_USER+947
#define WM_EXPLODE WM_USER+948
#define WM_MESSAGE WM_USER+949
#define WM_MAKESHIELD WM_USER+950
#define WM_FULLREPAINTQUADRANT WM_USER+951
#define WM_CREDITS WM_USER+952
#define WM_SETUP WM_USER+953
#define WM_SHOWIT WM_USER+954
#define WM_HIDE WM_USER+955
#define WM_LOADPLANETDLG WM_USER + 956
#define WM_LOADDETAIL WM_USER + 957
#define WM_UPDATETECH WM_USER + 958
#define WM_SOCIALPROGRESS     WM_USER + 7500
#define WM_MILITARYPROGRESS   WM_USER + 7501
#define WM_SHOWSOCIAL         WM_USER + 7502
#define WM_SHOWMILITARY       WM_USER + 7503
#define WM_SETUPSHIELDS       WM_USER + 7504
#define WM_CLEANUP 				WM_USER + 7505
#define WM_ENDLIGHTS          WM_USER + 7506
#define WM_SHOWLIGHTS         WM_USER + 7507
#define SUCCESS 1

/*Status Bar Stuff*/
#define ST_Quadrant  70
#define ST_Moves     71

#define INITIAL 0
#define ASKPEACE 1
#define TRADETECH 8
#define ASKALLIANCE 3
#define DEMANDTRIBUTE 4
#define THREATENWAR 5
#define ALIENSURRENDER 500
#define OTHERNEWS 501
#define ENEMYWONDER 502



/* Type Definitions */


typedef struct{
  SHORT Amount;
  SHORT Years;
  }LEASETYPE;


typedef struct{
	SHORT Amount;
   SHORT WhichStar;
	}TradeRouteType;

typedef struct{
   CHAR size;
   CHAR xcoord;
   CHAR ycoord;
   CHAR which;
   }BACKGROUNDTYPE;

typedef struct{
	CHAR stars;                      /*Number of stars in the Quadrant*/
	SHORT whichstars[const_starsinquad];            /*Which stars are in it?*/
	SHORT whichships[const_shipsinquad];
   CHAR backgrounds;
   CHAR starowner[const_maxplayers];
   CHAR temp;
	}QuadrantType;

typedef struct{
	CHAR owner;                     /*Who owns this ship?*/
	UCHAR moves;                     /*How many turns does it get?*/
	UCHAR att;
	UCHAR def;                       /*What is its defense value?*/
	CHAR xQuad;                     /*Which quadrant is it in?*/
	CHAR yQuad;
	CHAR xcoord;                    /*Where in the quadrant is it?*/
	CHAR ycoord;
	SHORT strength;                  /*How much strength does it have?*/
	CHAR  type;
	CHAR discovered[const_maxplayers];                 /*Has the human player discovered it?*/
	SHORT home;
	CHAR name[32];
	SHORT orbitting;                /*Which Planet they are orbitting*/
	CHAR xqGoto;
	CHAR yqGoto;
	CHAR xcGoto;
	CHAR ycGoto;
	CHAR sentry;
	SHORT destination;
   CHAR slowest;
   char xa; //future AI stuff
   char ya;
	}ShipType;

typedef struct{
	CHAR name[32];                 /*What is the name of the discovery?*/
	INT TotalNeeded;            /*How many resources does it require*/
	UCHAR TechRequirement1;
	UCHAR TechRequirement2;
	INT  Invested;
   CHAR EvilRequired;
   CHAR GoodRequired;
	}DiscType;

typedef struct{
	CHAR WhichOne;                  /*Which thing are they building?*/
	USHORT Invested;                  /*How much do they have invested in it?*/
	}GoalType;

typedef struct{
  CHAR Active;    /*Are we currently spying on them?*/
  INT Invested;   /*How much have we invested?*/
  }SpyType;

typedef struct{
	CHAR ImprovementName[32];
	UCHAR TechRequirement;
	SHORT Resources;
	UCHAR maint;
	UCHAR ResearchBonus;
	UCHAR MilitaryBonus;
	UCHAR DefenseBonus;
	UCHAR TradeBonus;
	UCHAR PollutionFix;
	UCHAR HappyBonus;
	UCHAR PlanetDefenseBonus;
	}ImprovementType;

 typedef struct{
	INT Treasury;
	ULONG Pop;
	ULONG Production;
	USHORT Might;
   INT Income;
	}HistoryType;



typedef struct{
	CHAR empirename[32];            /*What is the name of the Empire?*/
	CHAR govlev;                    /*What kind of government is it?*/
	CHAR  status;                    /*Are they alive?*/
	DiscType discoveringA[const_techs];      /*Which discovery are they working on?*/
	CHAR TechGoal[1];              /*Which Technologies are they pursuing*/
	CHAR Percent[1];
	CHAR technologies[const_techs];         /*Which technologies do they currently have?*/
	CHAR wonders[const_wonds];
	INT  money;
	CHAR TaxRate;                       /*These are ratios*/
	CHAR Society;
	CHAR Military;
	CHAR Research;
	CHAR SpendRate;				/*How much they are going to be spending*/
	SpyType Spying[const_maxplayers];      /*How much you have invested in espionage on a particular player*/
	CHAR   SpyRate;                       /*What percentage of income to spend on spying*/
	CHAR Relations[const_maxplayers];     /*How much do you like a particular player*/
	SHORT ExtraRent;              /*These are your permanent leases*/
	CHAR Difficulty;   			/*What difficulty level are we playing at*/
	CHAR Personality;             /*Which personality module are we using*/
	CHAR Aggression;              /*How aggressive are they?*/
	CHAR Greed;                   /*How greedy are they*/
	CHAR Ethics;                  /*How ethical are they*/
	CHAR Cooperation;             /*How cooperative are they? Do they like alliances?*/
	CHAR Evil;				/*How Evil are they?  Will they just do something spiteful?*/
	CHAR Revenge[const_maxplayers]; /*Keeps track of outstanding debts of hatred*/
	TradeRouteType Routes[const_traderoutes];              /*Your Trade Routes*/
	CHAR DestabilizeRate;                   /*What percentage of your income do you want to use*/
	CHAR DestabilizeFlags[const_maxplayers];	/*Which Players are being destabilized*/
	HistoryType HISTORY[500];
   LEASETYPE Leases[const_leases];
  INT  DATA1;   //For SDS/AI to use.
  INT  DATA2;   //For SDS/AI to use.
  INT  DATA3;   //FOR SDS/AI
  INT  DATA4;   //FOR SDS/AI
  INT  DATA5;   //FOR SDS/AI
   INT _data[20];
  char  IPaddress[255]; //For Internet play -- future!
	}EmpireType ;


typedef struct{
	CHAR attributes[const_imps];           /*Which things does this planet have? How many of them?*/
	GoalType SocProj;        			      /*Which thing are they working on right now?*/
	GoalType MiltProj;
	GoalType WondProj;
	SHORT population;                 		/*What is its population?*/
	SHORT type;                       		/*Is the planet like Earth or like my armpit?*/
	CHAR name[32];                  		   /*What is the name of the planet*/
	CHAR owner;
	SHORT whichships[const_shipsonworld];
	SHORT StarOwnedBy;
	USHORT YearFounded;
	char wonders[const_wonds];
	UCHAR YearsUnhappy;			            /*This will eventually keep track of how many years
							                        a planet has been unhappy.  Depending on government
							                        level, they will rebel and become independent.*/
	UCHAR Approval;                        /*This is used so much it would be faster to just refer to it in a variable*/
	CHAR colony_wagon_sent[const_maxplayers];
   CHAR Efficiency;                       /*How much of the planet's resources are they getting?*/
   CHAR Government[10];                   /*Local Government*/
	}PlanetData;

typedef struct {
	CHAR name[32];                   /*What is the name of the star system*/
	CHAR planets;                    /*How many star systems does it have?*/
	SHORT status;                    /*What kind of star is it?*/
	CHAR owner;                      /*Who Owns it*/
	UCHAR xcoord;                     /*Where in the quadrant is it?*/
	UCHAR ycoord;
	SHORT whichworld[const_planetsinstar];            /*Which planets are in it.  If it has more than 20, the program will crash*/
	CHAR xQuad;
	CHAR yQuad;
	USHORT strength;
   char govern;
	}StarData;

typedef struct {                        /*This is the star ship template */
	CHAR name[32];
	UCHAR movement;
	UCHAR offense;
	UCHAR defense;
	UCHAR strength;
	USHORT cost;
	UCHAR techlevel;
	UCHAR maint;
	SHORT Reference;		/*Icon number for this ship to use*/
   ULONG data;          /* For future use */
   ULONG abilities;     /* Future Use */
   ULONG range;         /*How many quadrants away from known territory can it go?*/
	}MilitaryType;


typedef struct {                       /*Resource Data structure*/
	USHORT Military;
	SHORT Social;
	USHORT Research;
	USHORT Entertain;
	}ResourceType;

typedef struct {
	CHAR name[24];
	CHAR Available;
	CHAR Valid;
	CHAR Shareable;
	SHORT resources;
	UCHAR ShipAttackImprovement;
	UCHAR ShipDefenseImprovement;
	UCHAR DefenseImprovement;
	UCHAR ResearchImprovement;
	UCHAR ApprovalImprovement;
	UCHAR TradeImprovement;
	UCHAR WorksUntil;
	UCHAR Requires;
	CHAR  BeingMade[const_maxplayers];
	}WonderType;

typedef struct {                       /*Position Type*/
	short x;
	short y;
	}POSITIONTYPE;

typedef struct {
	CHAR name[16];
	}NameType;


typedef struct {                       /*Position Type*/
	short a;
	short b;
   short c;
	}DATATYPE;

typedef struct {
	QuadrantType    (*Quadrant)[const_quads][const_quads];
	EmpireType      *Player;
	SHORT		 *USER_Planets;
	SHORT		 *USER_Stars;
	ShipType        *StarShip;
	DiscType	*Discovery;
	PlanetData	*WorldNumber;
	StarData	*StarNumber;
	MilitaryType	*StarShipKind;
	WonderType	*Wonder;
	SHORT          *USER_Players;
	ImprovementType *Improvement;
	SHORT		 *USER_xQuads;
	SHORT		 *USER_yQuads;
	USHORT		*YEAR;
   SHORT     *USER_DYNAMIC;
	}GalaxyType;


typedef struct {
	CHAR Reply1[1024];
	CHAR Reply2[1024];
	CHAR Reply3[1024];
	CHAR Reply4[1024];
	CHAR Reply5[1024];
	CHAR Reply6[1024];
	CHAR Reply7[1024];
	SHORT Data1;
	SHORT Data2;
	SHORT Data3;
	SHORT Data4;
	}ResponseType;


typedef struct{
	SHORT Which;
	SHORT Result;
	SHORT Spare;
   CHAR  Name[255];
	}NewsType;

typedef struct _USERRECORD{
	RECORDCORE recordCore;
	PSZ		project;
	PSZ	project2;
	PSZ       starname;
	PSZ		recordData;
	ULONG	population;
	ULONG	xq;
	ULONG	yq;
	ULONG 	appr;
	ULONG	data;

		}USERRECORD, *PUSERRECORD;



typedef struct {
   ULONG ulPageID;
   USHORT usTabAttr;
   PSZ pszTabText;
   HBITMAP hbm;
   ULONG ulPage;
   ULONG ulColor;
   }NOTEBOOKTYPE;

typedef NOTEBOOKTYPE *PNOTEBOOKTYPE;

typedef struct {
	CHAR name[32];                   /*What is the name of the star system*/
	}temptype;



typedef struct{
	CHAR word[255];
	SHORT page;
	SHORT wordnumber;
	}INFOTYPE;

#endif  // _GC_H_



