
/* This code is not quite finished yet... 
   It lacks support for bank-switched cards, requires a math coprocessor,
   and lacks tidyness.. On the other hand, it's just for fun...*/

/*
    FLIP version 0.9. Fun Screen hack for OS/2.
    This version requires a math co-pro (I think) and
    a video card with an aperture the size of the whole screen.
    Copyright (C) 1994 Henrik Harmsen.

    E-mail: harmsen@eritel.se

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#define INCL_DEV
#define INCL_DOS
#define INCL_WIN
#define INCL_32
#include <os2.h>
#include <memory.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include "types.h"

#define DEVESC_ACQUIREFB   33010L
#define DEVESC_DEACQUIREFB 33020L
#define DEVESC_SWITCHBANK  33030L
#define PI 3.14159265358979323846

/* Global information about the current video device driver.                 */
struct {
  ULONG ulPhysicalAddress;	/* Physical address                         */
  ULONG ulApertureSize;		/* 1 Meg, 4 Meg or 64k                      */
  ULONG ulScanLineSize;		/* This is >= the screen width in bytes.    */
  RECTL rctlScreen;		/* Device independant co-ordinates          */
} ai; // Aperture Info
HAB hab;			/* Need a handle to an allocation block.      */
HDC hdc;			/* Need a device context for the DecEsc's     */
PBYTE framebase;		/* Holds the linear address to the video card. */
ULONG ulTotalScreenColors = 0L;	/* Holds the total number of colors.          */
HFILE hDeviceDriver;		/* Handle to the device driver to do mapping. */

ULONG DirectScreenInit(void);
ULONG DirectScreenTerm(void);
void  DirectPrintInfo(void);
void  clr_lines(s32 y, s32 lines);
void  disp_lines(u8* buf, s32 y, s32 lines);
void  e_xit(s32 n);

u8* fb; // this holds a copy of the framebuffer
s32 fbsize;

bool arg_info;
s32 arg_speed;
s32 arg_nrev;
double dtime(void);

int
main(int argc, char *argv[])
{
  s32 frames = 0;
  double t1, t2;
  bool forw;
  ULONG ulNumBytes;
  PBYTE pbImageBottom, pbBMP;
  ULONG rc;
  double phase = 0.0, phase_steps;
  s32 sh, wh, wh2, sh2, i, rev;
  u32 num_bytes;
  struct {
    ULONG fAFBFlags;
    ULONG ulBankNumber;
    RECTL rctlXRegion;
  } acquireFb;

  /* Try to get direct screen access.                                       */
  if (DirectScreenInit ()) {
    printf ("Your display driver doesn't suport direct screen access.\n");
    return (1);
  }

  arg_info = false;
  arg_speed = 100;
  arg_nrev = 1;
  /* Process arguments */ 
  for (i = 1; i < argc; i++) {
    if (!strcmp("-i", argv[i])) {
      arg_info = true;
    } else if (!strcmp("-s", argv[i])) {
      i++;
      arg_speed = atol(argv[i]);
      clamp(1, arg_speed, 100000);
    } else if (!strcmp("-n", argv[i])) {
      i++;
      arg_nrev = atol(argv[i]);
      arg_nrev = clamp(1, arg_nrev, 1000000);
    } else if (!strcmp("-h", argv[i])) {
      fprintf(stderr, "flip -s <speed> -n <revs> -i (for info)\n", argv[i]);
      e_xit(1);
    } else {
      fprintf(stderr, "Unknown command line argument %s\n", argv[i]);
      fprintf(stderr, "flip -s <speed> -n <revs> -i (info)\n", argv[i]);
      fprintf(stderr, "example: flip -s 100 -n 4 -i\n", argv[i]);
      e_xit(1);
    }
  }

  if (arg_info)
    DirectPrintInfo ();

  if ((ai.ulScanLineSize * (ai.rctlScreen.yBottom - ai.rctlScreen.yTop + 1)) > ai.ulApertureSize) {
    fprintf(stderr, "Sorry, FLIP 0.9 does not fully support bank switched video cards yet.\n");
    e_xit(1);
  }

  acquireFb.rctlXRegion.xLeft = 0L;
  acquireFb.rctlXRegion.xRight = 0L;
  acquireFb.rctlXRegion.yTop = 0L;
  acquireFb.rctlXRegion.yBottom = 0L;
  acquireFb.ulBankNumber = 0L;
  acquireFb.fAFBFlags = 1L;	/* Acquire and switch simultaneously. */
  if (DevEscape(hdc, DEVESC_ACQUIREFB, sizeof (acquireFb), (PBYTE) & acquireFb, (PLONG) & num_bytes, (PBYTE) NULL) != DEV_OK) {
    fprintf(stderr, "Error when acquiring the frame buffer\n");
    e_xit (1);
  }

  fbsize = ai.ulScanLineSize * (ai.rctlScreen.yBottom - ai.rctlScreen.yTop + 1);
  fb = (u8*)malloc(fbsize);

  // copy frame buffer to local copy
  memcpy(fb, framebase, fbsize);

  sh = (ai.rctlScreen.yBottom - ai.rctlScreen.yTop + 1);
  sh2 = (ai.rctlScreen.yBottom - ai.rctlScreen.yTop + 1)/2;

  phase_steps = arg_speed/100.0*((2.0*PI)/300.0)*5.0;

  t1 = dtime();  
  frames = 0;
  for (rev = 0; rev < arg_nrev; rev++) {
    for (phase = 0.0; phase < 2.0*PI; phase += phase_steps) {
      frames++;
      wh2 = sh2 * cos(phase);
      if (wh2 < 0) {
        forw = false;
        wh2 = -wh2;
      } else {
        forw = true;
      }
      wh = wh2 << 1;
      if (forw) {
        clr_lines(0, sh2-wh2);
        for (i = 0; i < wh; i++) {
          disp_lines(fb+((i*sh)/wh)*ai.ulScanLineSize, i+sh2-wh2, 1);
        }
        clr_lines(sh2+wh2, sh2-wh2);
      } else {
        clr_lines(0, sh2-wh2);
        for (i = 0; i < wh; i++) {
          disp_lines(fb+(((wh-1-i)*sh)/wh)*ai.ulScanLineSize, i+sh2-wh2, 1);
        }
        clr_lines(sh2+wh2, sh2-wh2);
      }
    }
  }
  t2 = dtime();

  // reset screen
  memcpy(framebase, fb, fbsize);

  if (DevEscape(hdc, DEVESC_DEACQUIREFB, (ULONG) 0L, (PBYTE) NULL, (PLONG) 0L, (PBYTE) NULL) != DEV_OK) {
    fprintf(stderr, "Error when releasing the frame buffer\n");
  }

  DirectScreenTerm();

  if (arg_info) {
    printf("\nFramerate : %.1f fps\n", frames/(t2-t1));
  }

  free(fb);
  return(0);
}

void 
e_xit(s32 n) {
  DirectScreenTerm();
  exit(1);
}  

void
clr_lines(s32 y, s32 lines) {
  s32 n = (lines*ai.ulScanLineSize)/16;
  u32* p = (u32*)(framebase + y*ai.ulScanLineSize);
  s32 i;
  for(i = 0; i < n; i++) {
    *p++ = 0; // speed man...
    *p++ = 0;
    *p++ = 0;
    *p++ = 0;
  }
}

void
disp_lines(u8* buf, s32 y, s32 lines) {
  s32 n = (lines*ai.ulScanLineSize)/16;
  u32* p = (u32*)(framebase + y*ai.ulScanLineSize);
  u32* p2 = (u32*)buf;
  s32 i;
  for(i = 0; i < n; i++) {
    *p++ = *p2++;
    *p++ = *p2++;
    *p++ = *p2++;
    *p++ = *p2++;
  }
}

ULONG
MapPhysicalToLinear (ULONG ulPhysicalAddress)
{
  ULONG ulActionTaken;
  ULONG ulDLength;
  ULONG ulPLength;
  struct {
    ULONG hstream;
    ULONG hid;
    ULONG ulFlag;
    ULONG ulPhysAddr;
    ULONG ulVram_length;
  } parameter;
#pragma pack (1)
  struct {
    USHORT usXga_rng3_selector;
    ULONG ulLinear_address;
  } ddstruct;
#pragma pack ()

  /* Attempt to open up the device driver.                                  */
  if (DosOpen ((PSZ) "\\DEV\\SMVDD01$", (PHFILE) & hDeviceDriver,
	       (PULONG) & ulActionTaken, (ULONG) 0L, (ULONG) FILE_SYSTEM,
	       OPEN_ACTION_OPEN_IF_EXISTS, OPEN_SHARE_DENYNONE |
	       OPEN_FLAGS_NOINHERIT | OPEN_ACCESS_READONLY, (ULONG) 0L))
    return (3L);

  /* Set up the parameters for the IOCtl to map the vram to linear addr.    */
  parameter.hstream = 0L;
  parameter.hid = 0L;
  parameter.ulFlag = 1L;	/* Meaning MapRam. */
  parameter.ulPhysAddr = ulPhysicalAddress;
  parameter.ulVram_length = ai.ulApertureSize;
  ulPLength = sizeof (parameter);
  ulDLength = 0L;

  /* Call the IOCtl to do the map.                                          */
  if (DosDevIOCtl (hDeviceDriver, (ULONG) 0x81,
		   (ULONG) 0x42L, (PVOID) & parameter,
		   (ULONG) ulPLength, (PULONG) & ulPLength,
		   (PVOID) & ddstruct, (ULONG) 6, (PULONG) & ulDLength))
    return (4L);

  /* Set the variable to the linear address, and return.                    */
  framebase = (PBYTE) ddstruct.ulLinear_address;

  return (0L);
}



/* This routine will make a call to the video device driver to see if it     */
/* supports direct video, and if it does, gets information about the card    */
/* and maps the physical address to a linear address (addressabel by ring 3). */

ULONG
DirectScreenInit (VOID)
{
#define DEVESC_GETAPERTURE 33000L
  ULONG rc;
  ULONG ulFunction;
  LONG lOutCount;
  HPS hps;
  DEVOPENSTRUC dop =
  {0L, (PSZ) "DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L};

  /* Check to see that we are not already initialized.                      */
  if (ulTotalScreenColors)
    return (0xffffffff);

  /* Open a presentation space so we can query the number of screen colors. */
  hab = WinInitialize (0L);
  hps = WinGetPS (HWND_DESKTOP);
  hdc = DevOpenDC (hab, OD_MEMORY, (PSZ) "*", 5L,
		   (PDEVOPENDATA) & dop, (HDC) NULL);
  DevQueryCaps (hdc, CAPS_COLORS, 1L, (PLONG) & ulTotalScreenColors);

  /* Determine if the devescape calls are supported DCR96 implemented.      */
  ulFunction = DEVESC_GETAPERTURE;
  if (DevEscape (hdc, DEVESC_QUERYESCSUPPORT, 4L,
		 (PBYTE) & ulFunction, NULL, (PBYTE) NULL) == DEV_OK) {
    /* The devescape calls are okay, so lets find out the aperture info.   */
    lOutCount = sizeof (ai);
    if (DevEscape (hdc, DEVESC_GETAPERTURE, 0L, (PBYTE) NULL,
		   &lOutCount, (PBYTE) & ai) != DEV_OK) {
      ulTotalScreenColors = 0L;
      rc = 2L;
    }
    else {
      /* Let's take the ulScanLineSize value and change it from pixels    */
      /* to number of bytes per scan line.                                */
      if (ulTotalScreenColors == 16L)
	ai.ulScanLineSize = ai.ulScanLineSize >> 1;
      else if (ulTotalScreenColors == 65536L)
	ai.ulScanLineSize = ai.ulScanLineSize << 1;
      else if (ulTotalScreenColors == 16777216L)
	ai.ulScanLineSize = ai.ulScanLineSize +
	  (ai.ulScanLineSize << 1);
      /* else it's 256, and already the correct size.                     */
      rc = 0L;
    }
  }

  else {			/* DCR96 aperture calls not suppoted.                                */
    ulTotalScreenColors = 0L;
    rc = 1L;
  }

  /* Release the presentation space, but keep the device contect and hab.   */
  WinReleasePS (hps);

  /* If no error, then map the address to a ring 3 addressable one.         */
  if (!rc)
    rc = MapPhysicalToLinear (ai.ulPhysicalAddress);

  return (rc);
}




/* This routine will terminate the instance of the device driver.            */

ULONG
DirectScreenTerm (VOID)
{
  /* Check to see if we are actually initialized.                           */
  if (!ulTotalScreenColors)
    return (1L);

  /* Reset our number of screen colors to show deinitialization.            */
  ulTotalScreenColors = 0L;

  /* Close up our device context and allocation block.                      */
  DevCloseDC (hdc);
  WinTerminate (hab);

  /* Close up the device driver that did the mapping to linear address.     */
  return (DosClose (hDeviceDriver));
}


void
DirectPrintInfo (VOID)
{
  printf ("\nAperture information specific to your hardware:\n\n");
  printf ("      ulScanLineSize= %u bytes\n", ai.ulScanLineSize);
  printf ("   rctlScreen.xRight= %u pels\n", ai.rctlScreen.xRight);
  printf ("  rctlScreen.yBottom= %u pels\n", ai.rctlScreen.yBottom);
  printf ("    rctlScreen.xLeft= %u pels\n", ai.rctlScreen.xLeft);
  printf ("     rctlScreen.yTop= %u pels\n", ai.rctlScreen.yTop);
  printf ("          ulPhysAddr= 0x%8.8x\n", ai.ulPhysicalAddress);
  printf ("      ulApertureSize= %u bytes\n", ai.ulApertureSize);
  printf ("         ulNumColors= %u\n", ulTotalScreenColors);
}

double 
dtime(void)
{
	return ((double)clock())/CLOCKS_PER_SEC;
}
