
OPATH=Object
RPATH=Resource
HPATH=Help
CPATH=Code
GPATH=Bitmap

CFLAGS_DBG=/Ti
CFLAGS_EXTRA=/Gh+ /Ti /O+
CFLAGS_VALID=/DINCL_VAL /Ti
CFLAGS_OPT=/O+

CFLAGS=/Wall /W2 /G4 /Gm+ /Ss+ /Gd- $(CFLAGS_OPT)
LFLAGS=/B"/FAR /ALIGN:4 /EXEPACK:2 /PACKC"
#LIBS=VALIDATR.LIB
LIBS=

CC=icc $(CFLAGS) /I$(CPATH)
LC=icc $(LFLAGS)
RC=rc -X2 -nologo
HC=ipfc -W3 -L:DEU -C:850
IL=implib /NOLOGO

OBJS=$(OPATH)\stdmain.obj  \
     $(OPATH)\getopt.obj   \
     $(OPATH)\error.obj    \
     $(OPATH)\wpclient.obj \
     $(OPATH)\wpframe.obj  \
     $(OPATH)\wpmenu.obj   \
     $(OPATH)\wpmle.obj    \
     $(OPATH)\wpbmp.obj    \
     $(OPATH)\wppage.obj   \
     $(OPATH)\dlgabout.obj \
     $(OPATH)\book.obj     \
     $(OPATH)\loader.obj   \
     $(OPATH)\wploader.obj \
     $(OPATH)\settings.obj \
     $(OPATH)\help.obj     \
     $(OPATH)\precond.obj  \
#     D:\PROG\CSET\LIB\dde4xtra.obj \
     $(OPATH)\global.obj

BMPS=$(GPATH)\about.bmp    \
     $(RPATH)\clerical.ptr \
     $(RPATH)\clerical.ico \
     $(GPATH)\error.bmp    \
     $(GPATH)\front.bmp

.SUFFIXES: .c .obj

{$(CPATH)}.c{$(OPATH)}.obj:
  $(CC) /C /Fo$@ $<

all: clerical.exe clerical.hlp 

clean:
  -del $(OBJS)
  -del $(RPATH)\clerical.res
  -del clerical.exe
  -del $(HPATH)\clerical.hlp clerical.hlp
  -del $(RPATH)\clerical.def


clerical.exe: $(RPATH)\clerical.def $(RPATH)\clerical.res $(OBJS) clerical.mak
  $(LC) /Ge+ /B"/BASE:0x10000" /Fe$@ $(RPATH)\clerical.def $(OBJS) $(LIBS)                    
  $(RC) $(RPATH)\clerical.res $@

clerical.hlp: $(HPATH)\clerical.ipf clergy.bmp clerical.mak
  $(HC) $(HPATH)\clerical
  copy $(HPATH)\$@ $@

$(RPATH)\clerical.res: $(RPATH)\clerical.rc $(RPATH)\clerical.dlg $(CPATH)\resource.h $(BMPS) clerical.mak
  $(RC) -r $(RPATH)\clerical


$(OPATH)\stdmain.obj:  $(CPATH)\stdmain.c  $(CPATH)\book.h     $(CPATH)\error.h clerical.mak $(CPATH)\global.h $(CPATH)\getopt.h
$(OPATH)\getopt.obj:   $(CPATH)\getopt.c   $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h $(CPATH)\getopt.h
$(OPATH)\book.obj:     $(CPATH)\book.c     $(CPATH)\book.h     $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\loader.obj:   $(CPATH)\loader.c   $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\wploader.obj: $(CPATH)\wploader.c $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\wpclient.obj: $(CPATH)\wpclient.c $(CPATH)\book.h     $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\wpframe.obj:  $(CPATH)\wpframe.c  $(CPATH)\book.h     $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\wpmenu.obj:   $(CPATH)\wpmenu.c   $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\wpmle.obj:    $(CPATH)\wpmle.c    $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\wpbmp.obj:    $(CPATH)\wpbmp.c    $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\wppage.obj:   $(CPATH)\wppage.c   $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\dlgabout.obj: $(CPATH)\dlgabout.c $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\error.obj:    $(CPATH)\error.c    $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\settings.obj: $(CPATH)\settings.c $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\help.obj:     $(CPATH)\help.c     $(CPATH)\clerical.h $(CPATH)\error.h clerical.mak $(CPATH)\global.h
$(OPATH)\precond.obj:  $(CPATH)\precond.c  $(CPATH)\clerical.h                  clerical.mak
$(OPATH)\global.obj:   $(CPATH)\global.c   $(CPATH)\clerical.h                  clerical.mak

$(CPATH)\clerical.h: $(CPATH)\resource.h 
$(CPATH)\book.h:     $(CPATH)\clerical.h

$(RPATH)\clerical.def: clerical.mak
  @echo Creating .DEF file -- <<$@
;******* clerical C Module Definition File (.DEF) ****************************
;
;  The module definition file supplies extra information about the program
;  module to the LINKER.
;  Copyright 1995
;
NAME        TheClergymans  WINDOWAPI

DESCRIPTION 'The Clergymans from Walter Moers / Code'

EXETYPE     OS2

DATA        MULTIPLE

STACKSIZE   0x10000 ; 64K
HEAPSIZE    0x10000 ; 64K

PROTMODE
<<keep
