
OPATH=Object
RPATH=Resource
HPATH=Help
CPATH=Code
GPATH=Bitmap

CFLAGS_DBG=/Ti
CFLAGS_EXTRA=/Gh+ /Ti
CFLAGS_VALID=/DINCL_VAL
CFLAGS_OPT=/O+

CFLAGS=/Wall /W2 /G4 /Gm+ /Ss+ /Gd- $(CFLAGS_OPT)
LFLAGS=/B"/FAR /ALIGN:4 /EXEPACK:2 /PACKC /PACKD"
LIBS=

CC=icc $(CFLAGS) /I$(CPATH)
LC=icc $(LFLAGS)
RC=rc -X2 -nologo
HC=ipfc
IL=implib /NOLOGO

PIC1=$(GPATH)\c02.bmp \
     $(GPATH)\c03.bmp \
     $(GPATH)\1.bmp   \
     $(GPATH)\2.bmp   \
     $(GPATH)\3.bmp   \
     $(GPATH)\4.bmp   \
     $(GPATH)\5.bmp   \
     $(GPATH)\back.bmp

PIC2=$(GPATH)\c04.bmp \
     $(GPATH)\c05.bmp \
     $(GPATH)\c06.bmp \
     $(GPATH)\c07.bmp \
     $(GPATH)\c08.bmp \
     $(GPATH)\c09.bmp \
     $(GPATH)\c10.bmp \
     $(GPATH)\c11.bmp \
     $(GPATH)\c12.bmp \
     $(GPATH)\c13.bmp \
     $(GPATH)\c14.bmp

PIC3=$(GPATH)\c15.bmp \
     $(GPATH)\c16.bmp \
     $(GPATH)\c17.bmp \
     $(GPATH)\c18.bmp \
     $(GPATH)\c19.bmp \
     $(GPATH)\c20.bmp \
     $(GPATH)\c21.bmp \
     $(GPATH)\c22.bmp \
     $(GPATH)\c23.bmp \
     $(GPATH)\c24.bmp \
     $(GPATH)\c25.bmp

PIC4=$(GPATH)\c26.bmp \
     $(GPATH)\c27.bmp \
     $(GPATH)\c28.bmp \
     $(GPATH)\c29.bmp \
     $(GPATH)\c30.bmp \
     $(GPATH)\c31.bmp \
     $(GPATH)\c32.bmp \
     $(GPATH)\c33.bmp \
     $(GPATH)\c34.bmp \
     $(GPATH)\c35.bmp \
     $(GPATH)\c36.bmp

PIC5=$(GPATH)\c37.bmp \
     $(GPATH)\c38.bmp \
     $(GPATH)\c39.bmp \
     $(GPATH)\c40.bmp \
     $(GPATH)\c41.bmp \
     $(GPATH)\c42.bmp \
     $(GPATH)\c43.bmp \
     $(GPATH)\c44.bmp \
     $(GPATH)\c45.bmp \
     $(GPATH)\c46.bmp \
     $(GPATH)\c47.bmp

.SUFFIXES: .c .obj

{$(CPATH)}.c{$(OPATH)}.obj:
  $(CC) /C /Fo$@ $<

all: clerbmp1.dll clerbmp2.dll clerbmp3.dll clerbmp4.dll clerbmp5.dll 

clean:
  -del $(OPATH)\dummy.obj
  -del $(RPATH)\clerbmp?.res
  -del clerbmp?.dll
  -del $(RPATH)\clerbmp?.def


clerbmp1.dll: $(OPATH)\dummy.obj $(RPATH)\clerbmp1.def $(RPATH)\clerbmp1.res cleribmp.mak
  $(LC) /Ge- /Fe$@ $(OPATH)\dummy.obj $(RPATH)\clerbmp1.def
  $(RC) $(RPATH)\clerbmp1.res $@

clerbmp2.dll: $(OPATH)\dummy.obj $(RPATH)\clerbmp2.def $(RPATH)\clerbmp2.res cleribmp.mak
  $(LC) /Ge- /Fe$@ $(OPATH)\dummy.obj $(RPATH)\clerbmp2.def
  $(RC) $(RPATH)\clerbmp2.res $@

clerbmp3.dll: $(OPATH)\dummy.obj $(RPATH)\clerbmp3.def $(RPATH)\clerbmp3.res cleribmp.mak
  $(LC) /Ge- /Fe$@ $(OPATH)\dummy.obj $(RPATH)\clerbmp3.def
  $(RC) $(RPATH)\clerbmp3.res $@

clerbmp4.dll: $(OPATH)\dummy.obj $(RPATH)\clerbmp4.def $(RPATH)\clerbmp4.res cleribmp.mak
  $(LC) /Ge- /Fe$@ $(OPATH)\dummy.obj $(RPATH)\clerbmp4.def
  $(RC) $(RPATH)\clerbmp4.res $@

clerbmp5.dll: $(OPATH)\dummy.obj $(RPATH)\clerbmp5.def $(RPATH)\clerbmp5.res cleribmp.mak
  $(LC) /Ge- /Fe$@ $(OPATH)\dummy.obj $(RPATH)\clerbmp5.def
  $(RC) $(RPATH)\clerbmp5.res $@


$(RPATH)\clerbmp1.res: $(RPATH)\clerbmp1.rc $(CPATH)\resource.h $(PIC1) cleribmp.mak
  $(RC) -r $(RPATH)\clerbmp1

$(RPATH)\clerbmp2.res: $(RPATH)\clerbmp2.rc $(CPATH)\resource.h $(PIC2) cleribmp.mak
  $(RC) -r $(RPATH)\clerbmp2

$(RPATH)\clerbmp3.res: $(RPATH)\clerbmp3.rc $(CPATH)\resource.h $(PIC3) cleribmp.mak
  $(RC) -r $(RPATH)\clerbmp3

$(RPATH)\clerbmp4.res: $(RPATH)\clerbmp4.rc $(CPATH)\resource.h $(PIC4) cleribmp.mak
  $(RC) -r $(RPATH)\clerbmp4

$(RPATH)\clerbmp5.res: $(RPATH)\clerbmp5.rc $(CPATH)\resource.h $(PIC5) cleribmp.mak
  $(RC) -r $(RPATH)\clerbmp5


$(OPATH)\dummy.obj: $(CPATH)\dummy.c $(CPATH)\clerical.h cleribmp.mak
$(CPATH)\clerical.h: $(CPATH)\resource.h 


$(RPATH)\clerbmp1.def: cleribmp.mak
  @echo Creating .DEF file -- <<$@
LIBRARY     clerbmp1
DESCRIPTION 'The Clergymans from Walter Moers / Resource Pictures Part 1'
DATA        SINGLE SHARED
<<keep

$(RPATH)\clerbmp2.def: cleribmp.mak
  @echo Creating .DEF file -- <<$@
LIBRARY     clerbmp2
DESCRIPTION 'The Clergymans from Walter Moers / Resource Pictures Part 2'
DATA        SINGLE SHARED
<<keep

$(RPATH)\clerbmp3.def: cleribmp.mak
  @echo Creating .DEF file -- <<$@
LIBRARY     clerbmp3
DESCRIPTION 'The Clergymans from Walter Moers / Resource Pictures Part 3'
DATA        SINGLE SHARED
<<keep

$(RPATH)\clerbmp4.def: cleribmp.mak
  @echo Creating .DEF file -- <<$@
LIBRARY     clerbmp4
DESCRIPTION 'The Clergymans from Walter Moers / Resource Pictures Part 4'
DATA        SINGLE SHARED
<<keep

$(RPATH)\clerbmp5.def: cleribmp.mak
  @echo Creating .DEF file -- <<$@
LIBRARY     clerbmp5
DESCRIPTION 'The Clergymans from Walter Moers / Resource Pictures Part 5'
DATA        SINGLE SHARED
<<keep
