/* Rexx CLERICAL V0.01 installation program */

    call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    call SysLoadFuncs

    signal On Halt Name ErrorHandler      /* Error handler */

    call SysCls
    say
    say
    say " Clergymen V0.01 installation "
    say " ----------------------------- "

    /* --- do some tests ---------------------------------------------------------------------- */

    Version = sysos2ver();

    if ( Version < 2.30 ) then do
        say
        say "This program requiers OS2 Version 3.0 or higher"
        say 
        exit
    end /* Do */

    /* --- get a pathname from the user ------------------------------------------------------- */

    say
    say " Please specify the name of the subdirectory to which you would like to install"
    say " Clergymen, hit <Enter> to use the current directory, or type 'Q'<Enter> to"
    say " quit."
    say
    say " For Example:  C:\OS2\CLERICAL<Enter>"
    say
    say " Please specify:"

    parse Value SysCurPos() with Row Col
    Col=17
    Row=Row-1
    call SysCurPos Row, Col
    pull InstallDir

    if (( InstallDir = "Q" ) | ( InstallDir = "q" )) then do
        exit
    end

    /* --- get a language from the user ------------------------------------------------------- */

    say
    say " More than one language is availible. If you select '*', you will be asked for"
    say " active language. For changing a language read the README."
    say
    say " Select   'D'<Enter>  for German (Original) only"
    say "          'E'<Enter>  for English and German"
    say
    say "          '*'<Enter>  for all languages"
    say "          'Q'<Enter>  for quit (this is not a language)"
    say

    do until (( Language = "D" ) | ( Language = "E" ) | ( Language = "*" ) | ( Language = "Q" ))

        say " Please select:"
        parse Value SysCurPos() with Row Col
        Col=16
        Row=Row-1
        call SysCurPos Row, Col
        pull Language

        Language = translate( Language )

    end /* do */

    if ( Language = "Q" ) then do
        exit
    end  /* Do */

    say
    say

    CurrentDir = directory()              /* Find the current directory */
  
    if ( InstallDir = " " ) then do
        InstallDir = CurrentDir
    end

    if ( CurrentDir \= directory( InstallDir )) then do   /* If installing to different dir, do copying bit */
        Command = '@CD 'directory( CurrentDir )           /* Switch back to installation dir */
        Command

        Call SysFileTree InstallDir, FileDirectory, 'D' /* Search for new directory */

        if ( FileDirectory.0 = '0' ) then do                  /* If not found, create it */
            say " creating directory "InstallDir
            rc = SysMkDir( InstallDir )
            if ( rc \= 0 ) then do
                say
                say "The desired directory couldn't be created."
                say
                say "  RC = "rc
                say
                say "  Probably because you specified an invalid directory name"
                say "  or the destination disk is write-protected."
                say
                exit
            end
        end

        FileCountMax     = 9
        FileCountCurrent = 0

        if (( Language = 'D' ) | ( Language = '*' )) then do
            nop
        end  /* Do */
        if (( Language = 'E' ) | ( Language = '*' )) then do
            FileCountMax = FileCountMax + 2
        end  /* Do */

        say " copying files"
        call FileCopy 'install.cmd',  InstallDir, 1, FileCountMax
        call FileCopy 'clerical.exe', InstallDir, 2, FileCountMax
        call FileCopy 'clerbmp1.dll', InstallDir, 3, FileCountMax
        call FileCopy 'clerbmp2.dll', InstallDir, 4, FileCountMax
        call FileCopy 'clerbmp3.dll', InstallDir, 5, FileCountMax
        call FileCopy 'clerbmp4.dll', InstallDir, 6, FileCountMax
        call FileCopy 'clerbmp5.dll', InstallDir, 7, FileCountMax
        call FileCopy 'clerical.hlp', InstallDir, 8, FileCountMax
        call FileCopy 'readme.txt',   InstallDir, 9, FileCountMax

        FileCountCurrent = 9;

        if (( Language = 'D' ) | ( Language = '*' )) then do
            nop
        end  /* Do */

        if (( Language = 'E' ) | ( Language = '*' )) then do
            call FileCopy 'lang_eng.hlp', InstallDir, FileCountCurrent + 1, FileCountMax
            call FileCopy 'lang_eng.dll', InstallDir, FileCountCurrent + 2, FileCountMax
            FileCountCurrent = FileCountCurrent + 2;
        end  /* Do */
    end

    /* --- See if directory terminates in a \ ------------------------------------------------- */

    if substr( InstallDir, length( InstallDir ), 1 ) = "\" then do
        SetupString="EXENAME="InstallDir"CLERICAL.EXE;STARTUPDIR="InstallDir
    end
    else do
        SetupString="EXENAME="InstallDir"\CLERICAL.EXE;STARTUPDIR="InstallDir
    end

    if ( Language = '*' ) then do
        say
        say " Activate <Enter>     for German"
        say "          'E'<Enter>  for English"
        say

        say " Please select:"
        parse Value SysCurPos() with Row Col
        Col=16
        Row=Row-1
        call SysCurPos Row, Col
        pull Language

        Language = translate( Language )

    end /* Do */

    /* --- Create the programobject on the desktop -------------------------------------------- */

    if ( Language = 'E' ) then do
        SetupString = SetupString";PARAMETERS=-l lang_eng.dll"
        ObjectName = "The Clergymen"
    end /* Do */
    else do
        ObjectName = "Die Klerikalen"
    end /* Do */

    say " creating object"
    rc = SysCreateObject( "WPProgram", ObjectName, "<WP_DESKTOP>", SetupString, UPDATE )
    if rc = 0 then do
        say
        say "Couldn't create the program object."
        say
        exit
    end

    /* --- bye bye ---------------------------------------------------------------------------- */

    say
    say " The Clargymen has been installed successfully!"
    say

    exit

/* -------------------------------------------------------------------------------------------- */
FileCopy: Arg FileName, Destination, Count, MaxCount
/* -------------------------------------------------------------------------------------------- */
    
    Command='@Copy 'FileName' 'Destination' >NUL'
    Command

    if rc \= 0 then do
        say
        say "Error copying file " FileName
        say
        say "  RC = "rc
        say
        say "  This is probably because the destination disk is write protected"
        say "  or a file is missing.  Please make sure that this program can find"
        say "  all the files listed in the FILE.LST file and ensure that the"
        say "  destination disk isn't write protected"
        say
        exit
    end
    else do
        say "    "Count"/"MaxCount" : "FileName
    end

    return

/* -------------------------------------------------------------------------------------------- */
Error:
/* -------------------------------------------------------------------------------------------- */

    say
    say "Unknown error - aborting installation"
    say
    exit

