#pragma strings( readonly )

#include <stdlib.h>
#include <string.h>
#include "clerical.h"
#include "error.h"
#include "global.h"

LONG lColorIndex = SYSCLR_FIELDBACKGROUND;

// ===============================================================================================
MRESULT EXPENTRY wpPage( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
// ===============================================================================================

    MRESULT mReturn;
    BOOL    fCallOldWindowProcedure = TRUE;

    switch ( msg ) {

        //----------------------------------------------------------------------------------------
        case WM_MOUSEMOVE : {
        //----------------------------------------------------------------------------------------

            WinSetPointer( HWND_DESKTOP, hPointer );

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_COMMAND : {
        //----------------------------------------------------------------------------------------

            USHORT usCmdId = SHORT1FROMMP( mp1 );

            switch ( usCmdId ) {

                case ID_POPUP_COLOR : {

                    HOBJECT hObject;

                    if (( hObject = WinQueryObject( "<WP_LORESCLRPAL>" )) == NULLHANDLE ) {
                        Error( "Can't find Object <WP_LORESCLRPAL> (Font Palette)" );
                    } else if ( ! WinOpenObject( hObject
                                               , OPEN_DEFAULT
                                               , TRUE )) {
                        Error( "Can't open Object <WP_LORESCLRPAL> (Font Palette)" );
                    } /* endif */

                    break;
                }

                case ID_POPUP_FONT : {

                    HOBJECT hObject;

                    if (( hObject = WinQueryObject( "<WP_FNTPAL>" )) == NULLHANDLE ) {
                        Error( "Can't find Object <WP_FNTPAL> (Font Palette)" );
                    } else if ( ! WinOpenObject( hObject
                                               , OPEN_DEFAULT
                                               , TRUE )) {
                        Error( "Can't open Object <WP_FNTPAL> (Font Palette)" );
                    } /* endif */

                    break;
                }

                default : {

                    break;
                }

            } /* endswitch */

            fCallOldWindowProcedure = FALSE;
            mReturn = MRFROMLONG( 0L );

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_CHANGE_COLOR : {
        //----------------------------------------------------------------------------------------


            if ( ! SHORT1FROMMP( mp1 )) {
                lColorIndex = GpiQueryColorIndex( WinGetPS( hwnd )           // Presentation-space handle
                                                , 0L                         // Options
                                                , (LONG)LONGFROMMP( mp2 ));  // Specifies a color in RGB terms
                WinInvalidateRect( hwnd, NULL, FALSE );
            } /* endif */

            fCallOldWindowProcedure = FALSE;
            mReturn = MRFROMLONG( 0L );

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_PAINT : {
        //----------------------------------------------------------------------------------------

            RECTL rectl = { 0L, 0L, 0L, 0L };
            HPS hps = WinBeginPaint( hwnd, NULLHANDLE, &rectl );
            WinFillRect( hps, &rectl, lColorIndex );
            WinEndPaint( hps );

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_SIZE_TUNE : {
        //----------------------------------------------------------------------------------------

            RECTL rectlPage;

            POINTL pointl_MLE_Pos, pointl_MLE_Size;
            POINTL pointl_BMP_Pos, pointl_BMP_Size;
            LONG   lLimitX, lLimitY, lExcess;

            BOOL  f_MLE_ToBeVisible, f_BMP_ToBeVisible;

            f_MLE_ToBeVisible = SHORT1FROMMP( mp1 );
            f_BMP_ToBeVisible = SHORT1FROMMP( mp2 );

            // --- hide both clientwindows -------------------------------------------------------

            if ( f_MLE_IsVisible ) {
                WinSetWindowPos( hwndMLE, 0L, 0L, 0L, 0L, 0L, SWP_HIDE );
            } /* endif */
            if ( f_BMP_IsVisible ) {
                WinSetWindowPos( hwndBMP, 0L, 0L, 0L, 0L, 0L, SWP_HIDE );
            } /* endif */

            // --- get page area -----------------------------------------------------------------

            if ( ! WinQueryWindowRect( hwnd, &rectlPage )) {

                Error( "WinQueryWindowRect for Notebookpage failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

            } else if ( f_MLE_ToBeVisible ) {

                // --- calculate linespacing for MLE ---------------------------------------------

                HPS hPresSpace = WinGetPS( hwndMLE );
                FONTMETRICS FontMetric;
                LONG lLineSpacing;

                memset( &FontMetric
                      , 0
                      , sizeof( FONTMETRICS ));

                if ( ! hPresSpace ) {

                    Error( "WinGetPS for Window(%lX) failed. RC(%X)"
                         , hwndMLE
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

                } else {

                    if ( ! GpiQueryFontMetrics( hPresSpace
                                              , sizeof( FONTMETRICS )
                                              , &FontMetric )) {

                        Error( "GpiQueryFontMetrics for Window(%lX) failed. RC(%X)"
                             , hwndMLE
                             , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                    }

                    WinReleasePS( hPresSpace );
                }

                lLineSpacing = FontMetric.lMaxBaselineExt + FontMetric.lExternalLeading;

                // --- maximum MLE area ----------------------------------------------------------

                pointl_MLE_Pos.x  = rectlPage.xLeft + PICTURE_TEXT_BORDER;
                pointl_MLE_Pos.y  = rectlPage.yBottom + PICTURE_TEXT_BORDER;
                pointl_MLE_Size.x = ( rectlPage.xRight - rectlPage.xLeft ) - 2 * PICTURE_TEXT_BORDER;
                pointl_MLE_Size.y = ( rectlPage.yTop - rectlPage.yBottom ) - 2 * PICTURE_TEXT_BORDER;

                if ( f_BMP_ToBeVisible ) {

                    // --- minimum MLE hight -----------------------------------------------------

                    pointl_MLE_Size.y = min(   MIN_TEXT_LINES * lLineSpacing
                                             - FontMetric.lExternalLeading
                                             + 10L  // why not 10 ?
                                           ,   pointl_MLE_Size.y
                                             - PICTURE_TEXT_BORDER
                                             - 1L   // minimal Bitmapheight
                                           );

                    pointl_BMP_Pos.x  = pointl_MLE_Pos.x;
                    pointl_BMP_Pos.y  = pointl_MLE_Pos.y + pointl_MLE_Size.y + PICTURE_TEXT_BORDER;
                    pointl_BMP_Size.x = pointl_MLE_Size.x;
                    pointl_BMP_Size.y = ( rectlPage.yTop - PICTURE_TEXT_BORDER ) - pointl_BMP_Pos.y;

                    lLimitY = (LONG)( pointl_BMP_Size.x * BMP_RATIO_PART );
                    lLimitX = (LONG)( pointl_BMP_Size.y / BMP_RATIO_PART );

                    if ( lLimitY < pointl_BMP_Size.y ) {
                        LONG lMovePels = (( pointl_BMP_Size.y - lLimitY ) / lLineSpacing ) * lLineSpacing;
                        pointl_MLE_Size.y += lMovePels;
                        pointl_BMP_Pos.y += (( pointl_BMP_Size.y - lLimitY ) + lMovePels ) / 2;
                        pointl_BMP_Size.y = lLimitY;

                    } else {
                        pointl_BMP_Pos.x += ( pointl_BMP_Size.x - lLimitX ) / 2;
                        pointl_BMP_Size.x = lLimitX;
                    } /* endif */

                    if ( ! WinSetWindowPos( hwndBMP             // Window handle
                                          , HWND_TOP            // Relative window-placement order
                                          , pointl_BMP_Pos.x    // Window position, x-coordinate
                                          , pointl_BMP_Pos.y    // Window position, y-coordinate
                                          , pointl_BMP_Size.x   // Window size cx
                                          , pointl_BMP_Size.y   // Window size cy
                                          ,    SWP_MOVE         // Window-positioning options
                                             | SWP_SHOW
                                             | SWP_ZORDER
                                             | SWP_SIZE )) {

                        Error( "WinSetWindowPos( SWP_MOVE / SWP_SIZE ) for BMP failed. RC(%X)"
                             , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                    }

                } else {

                    lExcess = (   pointl_MLE_Size.y
                                - FontMetric.lExternalLeading
                                - 10L ) % lLineSpacing;
                    pointl_MLE_Size.y -= lExcess;
                    pointl_MLE_Pos.y  += lExcess / 2;

                } /* endif */

                if ( ! WinSetWindowPos( hwndMLE             // Window handle
                                      , HWND_TOP            // Relative window-placement order
                                      , pointl_MLE_Pos.x    // Window position, x-coordinate
                                      , pointl_MLE_Pos.y    // Window position, y-coordinate
                                      , pointl_MLE_Size.x   // Window size cx
                                      , pointl_MLE_Size.y   // Window size cy
                                      ,    SWP_MOVE         // Window-positioning options
                                         | SWP_SHOW
                                         | SWP_ZORDER
                                         | SWP_SIZE )) {

                    Error( "WinSetWindowPos( SWP_MOVE / SWP_SIZE ) for MLE failed. RC(%X)"
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                }

            } else if ( f_BMP_ToBeVisible ) {

                // --- only Picture --------------------------------------------------------------

                pointl_BMP_Pos.x  = rectlPage.xLeft + PICTURE_TEXT_BORDER;
                pointl_BMP_Pos.y  = rectlPage.yBottom + PICTURE_TEXT_BORDER;
                pointl_BMP_Size.x = ( rectlPage.xRight - rectlPage.xLeft ) - 2 * PICTURE_TEXT_BORDER;
                pointl_BMP_Size.y = ( rectlPage.yTop - rectlPage.yBottom ) - 2 * PICTURE_TEXT_BORDER;

                lLimitY = (LONG)( pointl_BMP_Size.x * BMP_RATIO_FULL );
                lLimitX = (LONG)( pointl_BMP_Size.y / BMP_RATIO_FULL );

                if ( lLimitY < pointl_BMP_Size.y ) {
                    pointl_BMP_Pos.y += ( pointl_BMP_Size.y - lLimitY ) / 2;
                    pointl_BMP_Size.y = lLimitY;
                } else {
                    pointl_BMP_Pos.x += ( pointl_BMP_Size.x - lLimitX ) / 2;
                    pointl_BMP_Size.x = lLimitX;
                } /* endif */

                if ( ! WinSetWindowPos( hwndBMP             // Window handle
                                      , HWND_TOP            // Relative window-placement order
                                      , pointl_BMP_Pos.x    // Window position, x-coordinate
                                      , pointl_BMP_Pos.y    // Window position, y-coordinate
                                      , pointl_BMP_Size.x   // Window size cx
                                      , pointl_BMP_Size.y   // Window size cy
                                      ,    SWP_MOVE         // Window-positioning options
                                         | SWP_SHOW
                                         | SWP_ZORDER
                                         | SWP_SIZE )) {

                    Error( "WinSetWindowPos( SWP_MOVE / SWP_SIZE ) for BMP failed. RC(%X)"
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                }

            } else {
                ;
            } /* endif */

            f_MLE_IsVisible = f_MLE_ToBeVisible;
            f_BMP_IsVisible = f_BMP_ToBeVisible;

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        default : {
        //----------------------------------------------------------------------------------------

            break;
        }
    }

    if ( fCallOldWindowProcedure ) {
        mReturn = pfnwpPageOld( hwnd, msg, mp1, mp2 );
    } /* endif */

    return mReturn;
}
