#pragma strings( readonly )

#include <string.h>
#include "clerical.h"
#include "error.h"
#include "global.h"

// ===============================================================================================
MRESULT EXPENTRY wpMLE( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
// ===============================================================================================

    MRESULT mReturn;
    BOOL    fCallOldWindowProcedure = TRUE;

    switch ( msg ) {

        //----------------------------------------------------------------------------------------
        case WM_MOUSEMOVE : {
        //----------------------------------------------------------------------------------------

            WinSetPointer( HWND_DESKTOP, hPointer );

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_PRESPARAMCHANGED : {
        //----------------------------------------------------------------------------------------

            switch ( LONGFROMMP( mp1 )) {

                case PP_BACKGROUNDCOLOR : {

                    ulChangedPP |= BIT_PP_MLE_BACKCOLOR;

                    break;
                }

                case PP_FOREGROUNDCOLOR : {

                    ulChangedPP |= BIT_PP_MLE_FORECOLOR;

                    break;
                }

                case PP_FONTNAMESIZE : {

                    WinPostMsg( hwndPage
                              , WM_USER_SIZE_TUNE
                              , MPFROMSHORT( f_MLE_IsVisible )
                              , MPFROMSHORT( f_BMP_IsVisible ));

                    ulChangedPP |= BIT_PP_MLE_FONT;

                    break;
                }

                default: {
                    break;
                }

            } /* endswitch */

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_BUTTON2DOWN : {
        //----------------------------------------------------------------------------------------

            WinPopupMenu( hwnd                  //  Parent-window handle
                        , hwndPage              //  Owner-window handle
                        , hwndPopup             //  Pop-up menu-window handle
                        , SHORT1FROMMP( mp1 )   //  x-coordinate of the pop-up menu position
                        , SHORT2FROMMP( mp1 )   //  y-coordinate of the pop-up menu position
                        , 0L                    //  Item identity
                        ,   PU_HCONSTRAIN       //  Options
                          | PU_VCONSTRAIN
                          | PU_NONE
                          | PU_MOUSEBUTTON1
                          | PU_MOUSEBUTTON2
                          | PU_MOUSEBUTTON3
                          | PU_KEYBOARD );

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        default : {
        //----------------------------------------------------------------------------------------

            break;
        }
    }

    if ( fCallOldWindowProcedure ) {
        mReturn = pfnwpMLEOld( hwnd, msg, mp1, mp2 );
    } /* endif */

    return mReturn;
}

