#pragma strings( readonly )

#include <string.h>
#include "clerical.h"
#include "error.h"
#include "global.h"


// ===============================================================================================
MRESULT EXPENTRY wpMenu( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
// ===============================================================================================

    MRESULT mReturn;
    BOOL    fCallOldWindowProcedure = TRUE;

    switch ( msg ) {

        //----------------------------------------------------------------------------------------
        case WM_MOUSEMOVE : {
        //----------------------------------------------------------------------------------------

            WinSetPointer( HWND_DESKTOP, hPointer );

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_PRESPARAMCHANGED : {
        //----------------------------------------------------------------------------------------

            ULONG ulParameter1;

            mReturn = pfnwpMenuOld( hwnd, msg, mp1, mp2 );

            ulParameter1 = LONGFROMMP( mp1 );

            switch ( ulParameter1 ) {

                case PP_MENUFOREGROUNDCOLOR   :
                case PP_MENUBACKGROUNDCOLOR   :
                case PP_MENUHILITEFGNDCOLOR   :
                case PP_MENUHILITEBGNDCOLOR   :
                case PP_MENUDISABLEDFGNDCOLOR :
                case PP_MENUDISABLEDBGNDCOLOR :
                case PP_FONTNAMESIZE          : {

                    BYTE pbBuffer[ FACESIZE + 1 ];

                    pbBuffer[ FACESIZE ] = '\0';

                    WinQueryPresParam( hwnd
                                     , ulParameter1
                                     , 0
                                     , NULL
                                     , FACESIZE
                                     , &pbBuffer
                                     , 0L );
                    WinSetPresParam( hwndPopup
                                   , ulParameter1
                                   , FACESIZE
                                   , &pbBuffer );

                    if (        ulParameter1 == PP_MENUFOREGROUNDCOLOR ) {
                        ulChangedPP |= BIT_PP_MENU_FORECOLOR;
                    } else if ( ulParameter1 == PP_MENUBACKGROUNDCOLOR ) {
                        ulChangedPP |= BIT_PP_MENU_BACKCOLOR;
                    } else if ( ulParameter1 == PP_FONTNAMESIZE ) {
                        ulChangedPP |= BIT_PP_MENU_FONT;
                    } /* endif */

                    break;
                }

                default: {
                    break;
                }

            } /* endswitch */

            fCallOldWindowProcedure = FALSE;

            break;
        }

        //----------------------------------------------------------------------------------------
        default : {
        //----------------------------------------------------------------------------------------

            break;
        }
    }

    if ( fCallOldWindowProcedure ) {
        mReturn = pfnwpMenuOld( hwnd, msg, mp1, mp2 );
    } /* endif */

    return mReturn;
}
