#pragma strings( readonly )

#include "clerical.h"
#include "error.h"
#include "global.h"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

HPS     hpsMemory       = NULLHANDLE;
HPS     hpsScreen       = NULLHANDLE;
HDC     hdcMemory       = NULLHANDLE;

HMODULE phModulePictures[ 6 ] = { NULLHANDLE, NULLHANDLE, NULLHANDLE, NULLHANDLE, NULLHANDLE, NULLHANDLE };

HBITMAP hBmp = NULLHANDLE;
PSZ     pszFileName = NULLHANDLE;
PSZ     pszDllFileName = NULLHANDLE;

POINTL ppointlBitBlt[ 4 ] = {{ 0L, 0L },{ 0L, 0L },{ 0L, 0L },{ 0L, 0L }};
AREABUNDLE areabundle = { CLR_BLACK, SYSCLR_FIELDBACKGROUND, 0, 0, 0, 0, { 0L, 0L }};

// ===============================================================================================
MRESULT EXPENTRY wpLoader( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
// ===============================================================================================

    MRESULT mReturn;

    switch ( msg ) {

        //----------------------------------------------------------------------------------------
        case WM_CREATE : {
        //----------------------------------------------------------------------------------------

            ULONG  ulMaxPathLength = 0L;

            mReturn = MRFROMSHORT( TRUE );

            DosQuerySysInfo( QSV_MAX_PATH_LENGTH
                           , QSV_MAX_PATH_LENGTH
                           , &ulMaxPathLength
                           , sizeof( ULONG ));

            if (( pszFileName = (PSZ)malloc( ulMaxPathLength * sizeof( CHAR ))) == NULL ) {
                Error( "No memory !!" );
            } else {
                strcpy( pszFileName, PVOIDFROMMP( mp1 ));

                mReturn = MRFROMSHORT( FALSE );

            } /* endif */

            ppointlBitBlt[ 0 ].x = 0L;
            ppointlBitBlt[ 0 ].y = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_INIT_LOADER : {
        //----------------------------------------------------------------------------------------

            SIZEL        sizel = { 0L, 0L };      // use same page size as device
            DEVOPENSTRUC devopenstruc = { NULL, "DISPLAY", NULL, NULL, NULL, NULL, NULL, NULL, NULL };

            if (( hdcMemory = DevOpenDC( hAnchorBlock2
                                       , OD_MEMORY
                                       , "*"
                                       , 9L
                                       , (PDEVOPENDATA)(PVOID)&devopenstruc
                                       , NULLHANDLE )) == DEV_ERROR ) {
                Error( "DevOpenDC for Loader failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock2 )));
            } else if (( hpsMemory = GpiCreatePS( hAnchorBlock2
                                                , hdcMemory
                                                , &sizel
                                                ,   GPIT_MICRO
                                                  | GPIF_DEFAULT
                                                  | GPIA_ASSOC
                                                  | PU_PELS )) == GPI_ERROR ) {
                Error( "GpiCreatePS (1) for Loader failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock2 )));
            } else if ( hwndPage == NULLHANDLE ) {
                Error( "Loader found : hwndPage = NULLHANDLE !" );
            } else if (( hpsScreen = WinGetPS( hwndBMP )) == NULLHANDLE ) {
                Error( "GpiCreatePS (2) for Loader failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock2 )));
            } else {

                GpiSetAttrs( hpsScreen
                           , PRIM_IMAGE
                           ,   IBB_COLOR
                             | IBB_BACK_COLOR
                           , 0L
                           , &areabundle );

                WinPostMsg( hwndNotebook
                          , WM_USER_INIT_PART_3
                          , MPFROMLONG( 0L )
                          , MPFROMLONG( 0L ));

            } /* endif */

            mReturn = MRFROMLONG( 0L );

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_LOAD_BMP : {
        //----------------------------------------------------------------------------------------

            BITMAPINFOHEADER bmpData;  /*  Bit-map information header. */
            ULONG ulIndex = LONGFROMMP( mp2 );

            memset( &bmpData, 0, sizeof( BITMAPINFOHEADER ));
            bmpData.cbFix = sizeof( BITMAPINFOHEADER );

            if ( hBmp != NULLHANDLE ) {
                GpiDeleteBitmap( hBmp );
            } /* endif */

            if (( hBmp = GpiLoadBitmap( hpsMemory                   //  Presentation-space handle
                                      , phModulePictures[ ulIndex ] //  Resource identity containing the bit map
                                      , LONGFROMMP( mp1 )           //  ID of the bit map within the resource file
                                      , 0L                          //  Width of the bit map in pels   0 = no strech
                                      , 0L )) == GPI_ERROR ) {      //  Height of the bit map in pels  0 = no strech
                if (( hBmp = GpiLoadBitmap( hpsMemory               //  Presentation-space handle
                                          , NULLHANDLE              //  Resource identity containing the bit map
                                          , ID_BMP_PICTURE_ERROR    //  ID of the bit map within the resource file
                                          , 0L                      //  Width of the bit map in pels   0 = no strech
                                          , 0L )) == GPI_ERROR ) {  //  Height of the bit map in pels  0 = no strech
                    Error( "GpiLoadBitmap ID(%ld) from Module %X failed. RC(%X)"
                         , LONGFROMMP( mp1 )
                         , phModulePictures[ ulIndex ]
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock2 )));
                } /* endif */
            } else {

                GpiQueryBitmapParameters( hBmp, &bmpData );

                if (( bmpData.cx <= 0L ) || ( bmpData.cy <= 0L )) {
                    Error( "Bitmap for Loader with size CX or CY <= 0 !!" );
                } /* endif */

                ppointlBitBlt[ 2 ].x = 0L;
                ppointlBitBlt[ 2 ].y = 0L;
                ppointlBitBlt[ 3 ].x = bmpData.cx;
                ppointlBitBlt[ 3 ].y = bmpData.cy;

            } /* endif */

            mReturn = MRFROMLONG( 0L );

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_PAINT_PICTURE : {
        //----------------------------------------------------------------------------------------

            HBITMAP hBmpOld;
            RECTL rectlBMP = { 0L, 0L, 0L, 0L };
            WinQueryWindowRect( hwndBMP, &rectlBMP );

            ppointlBitBlt[ 1 ].x = rectlBMP.xRight + rectlBMP.xLeft;
            ppointlBitBlt[ 1 ].y = rectlBMP.yTop + rectlBMP.yBottom;

            hBmpOld = GpiSetBitmap( hpsMemory, hBmp );

            if (( GpiBitBlt( hpsScreen     //  Target presentation-space handle
                           , hpsMemory     //  Source presentation-space handle
                           , 4L            //  Point count
                           , ppointlBitBlt //  Point array
                           , ROP_SRCCOPY   //  Mixing function required
                           , BBO_OR ))     //  Options
                  == GPI_ERROR ) {

                Error( "GpiBitBlt failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock2 )));
            } /* endif */

            GpiSetBitmap( hpsMemory, hBmpOld );

            mReturn = MRFROMLONG( 0L );

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_CHANGE_COLOR : {
        //----------------------------------------------------------------------------------------

            ULONG ulAttrMask;
            LONG lColorIndex;

            lColorIndex = GpiQueryColorIndex( hpsScreen                  // Presentation-space handle
                                            , 0L                         // Options
                                            , (LONG)LONGFROMMP( mp2 ));  // Specifies a color in RGB terms

            if ( SHORT1FROMMP( mp1 )) {
                ulAttrMask = IBB_COLOR;
                areabundle.lColor = lColorIndex;
            } else {
                ulAttrMask = IBB_BACK_COLOR;
                areabundle.lBackColor = lColorIndex;
            } /* endif */

            GpiSetAttrs( hpsScreen
                       , PRIM_IMAGE
                       , ulAttrMask
                       , 0L
                       , &areabundle );

            WinPostMsg( hwnd
                      , WM_USER_PAINT_PICTURE
                      , MPFROMLONG( 0L )
                      , MPFROMLONG( 0L ));

            mReturn = MRFROMLONG( 0L );

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_LOAD_DLL : {
        //----------------------------------------------------------------------------------------

            APIRET  rc = NO_ERROR;    // Return code

            ULONG   ulLoop;
            ULONG   ulNewDll1 = LONGFROMMP( mp1 );
            ULONG   ulNewDll2 = LONGFROMMP( mp2 );
            HMODULE hWork;
            PSZ     pszBmpDll;

            for ( ulLoop = 1; ulLoop <= 5; ulLoop++ ) {
                hWork = phModulePictures[ ulLoop ];
                if (( ulLoop == ulNewDll1 ) || ( ulLoop == ulNewDll2 )) {
                    if ( hWork == NULLHANDLE ) {

                        CHAR acFailureBuffer[ 128 ];

                        switch ( ulLoop ) {

                            case 1 : pszBmpDll = BMP_DLL_1; break;
                            case 2 : pszBmpDll = BMP_DLL_2; break;
                            case 3 : pszBmpDll = BMP_DLL_3; break;
                            case 4 : pszBmpDll = BMP_DLL_4; break;
                            case 5 : pszBmpDll = BMP_DLL_5; break;

                            default : {
                                Error( "Very Very Great Problems" );
                                break;
                            }
                        } /* endswitch */

                        strcpy( strrchr( pszFileName, '\\' ) + 1, pszBmpDll );

                        if (( rc = DosLoadModule( acFailureBuffer                  // Failure information buffer
                                                , sizeof( acFailureBuffer )        // Size of buffer
                                                , pszFileName                      // Module to load
                                                , &( phModulePictures[ ulLoop ] )) // Module handle returned
                                ) != NO_ERROR ) {

                            Error( "DosLoadModule(%s) failed RC(%X)", pszFileName, rc );
                        } /* endif */

                    } /* endif */
                } else {
                    if (( hWork != NULLHANDLE ) && ( ulLoop != 1 )) {

                        DosFreeModule( hWork );
                        phModulePictures[ ulLoop ] = NULLHANDLE;

                    } /* endif */
                } /* endif */
            } /* endfor */

            mReturn = MRFROMLONG( 0L );

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_CLOSE : {
        //----------------------------------------------------------------------------------------

            ULONG ulLoop;

            if ( pszFileName == NULL ) {
                free( pszFileName );
                pszFileName = NULL;
            } /* endif */

            GpiSetBitmap( hpsMemory, NULLHANDLE );

            if ( hBmp != NULLHANDLE ) {
                GpiDeleteBitmap( hBmp );
            } /* endif */

            WinReleasePS( hpsScreen );

            GpiDestroyPS( hpsMemory );
            DevCloseDC( hdcMemory );

            for ( ulLoop = 1; ulLoop <= 5; ulLoop++ ) {
                if ( phModulePictures[ ulLoop ] != NULLHANDLE ) {
                    DosFreeModule( phModulePictures[ ulLoop ] );
                } /* endif */
            } /* endfor */

            mReturn = WinDefWindowProc( hwnd, msg, mp1, mp2 );

            break;
        }

        //----------------------------------------------------------------------------------------
        default : {
        //----------------------------------------------------------------------------------------

            mReturn = WinDefWindowProc( hwnd, msg, mp1, mp2 );

            break;
        }

    } /* endswitch */

    return mReturn;
}

