#pragma strings( readonly )

#include <string.h>
#include <ctype.h>
#include "book.h"
#include "error.h"
#include "global.h"

// --- global variables --------------------------------------------------------------------------

static void SetNotebookPage( PPAGESELECTNOTIFY pPageSelectNotify );

// ===============================================================================================
MRESULT EXPENTRY wpFrame( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
// ===============================================================================================

    MRESULT mReturn;
    BOOL    fCallOldWindowProcedure = TRUE;

    switch ( msg ) {

        //----------------------------------------------------------------------------------------
        case WM_CONTROL : {
        //----------------------------------------------------------------------------------------

            if ( SHORT1FROMMP( mp1 ) == WinQueryWindowUShort( hwndNotebook, QWS_ID )) {

                switch ( SHORT2FROMMP( mp1 )) {

                    case BKN_PAGESELECTED : {

                        // --- A new page has been selected by the user. -------------------------

                        SetNotebookPage( (PPAGESELECTNOTIFY)PVOIDFROMMP( mp2 ));

                        fCallOldWindowProcedure = FALSE;
                        mReturn = 0L;

                        break;
                    }

                    default : {
                        break;
                    }
                }
            }

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_QUERYTRACKINFO : {
        //----------------------------------------------------------------------------------------

            PTRACKINFO ptrackinfo;
            RECTL      rectl;

            mReturn = pfnwpFrameOld( hwnd, msg, mp1, mp2 );
            fCallOldWindowProcedure = FALSE;

            ptrackinfo = (PTRACKINFO)PVOIDFROMMP( mp2 );
            ptrackinfo->ptlMinTrackSize.x = 100L;
            ptrackinfo->ptlMinTrackSize.y = 100L;

            rectl.xLeft   = 0L;
            rectl.xRight  = WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN ) / 5L;
            rectl.yBottom = 0L;
            rectl.yTop    = WinQuerySysValue( HWND_DESKTOP, SV_CYSCREEN ) / 5L;

            if ( ! WinSendMsg( hwndNotebook
                             , BKM_CALCPAGERECT
                             , MPFROMP( &rectl )
                             , MPFROMSHORT( FALSE ))) {

                Error( "WinSendMsg( BKM_CALCPAGERECT ) for Notebook failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock )));


            } else if ( ! WinCalcFrameRect( hwndFrame
                                          , &rectl
                                          , FALSE )) {

                Error( "WinCalcFrameRect for Notebook failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

            } else {

                ptrackinfo->ptlMinTrackSize.x = rectl.xRight - rectl.xLeft;
                ptrackinfo->ptlMinTrackSize.y = rectl.yTop - rectl.yBottom;

            } /* endif */

            break;
        }

        //----------------------------------------------------------------------------------------
        default : {
        //----------------------------------------------------------------------------------------

            break;
        }
    }

    if ( fCallOldWindowProcedure ) {
        mReturn = pfnwpFrameOld( hwnd, msg, mp1, mp2 );
    } /* endif */

    return mReturn;
}

// ===============================================================================================
void SetNotebookPage( PPAGESELECTNOTIFY pPageSelectNotify ) {
// ===============================================================================================

    // --- Get a pointer to the page object that is associated with the new selected page. -------
    //     It was stored in the Application-defined page data.

    ULONG ulPageData = LONGFROMMR( WinSendMsg( pPageSelectNotify->hwndBook
                                             , BKM_QUERYPAGEDATA
                                             , MPFROMLONG( pPageSelectNotify->ulPageIdNew )
                                             , MPFROMLONG( 0L )));
    switch ( ulPageData ) {

        case BOOKERR_INVALID_PARAMETERS : {

            // --- An invalid page ID was specified for the ulPageId parameter. ------------------

            Error( "WinSendMsg( BKM_QUERYPAGEDATA ) for Notebook returns BOOKERR_INVALID_PARAMETERS" );

            break;
        }

        case 0 : {

            break;
        }

        default : {

            // --- Application-defined page data. ------------------------------------------------

            PPAGEDATA  pPageData = (PPAGEDATA)ulPageData;
            BOOL       fChange;
            BOOL       f_MLE_ToBeVisible, f_BMP_ToBeVisible;
            IPT        iptEnd, ipt = -1;
            CHAR       pszBuffer[ MAX_RESOURCE_STRING_LENGTH * MAX_MULTISTRING ];
            CHAR*      pszNewLine;
            LONG       lLength;
            INT        iLoop;

            f_BMP_ToBeVisible = (BOOL)( pPageData->ulResIdPicture != ID_NO_RESOURCE );
            f_MLE_ToBeVisible = (BOOL)( pPageData->ulResIdText    != ID_NO_RESOURCE );

            if ( f_BMP_ToBeVisible ) {
                WinPostMsg( hwndLoader
                          , WM_USER_LOAD_BMP
                          , MPFROMLONG( pPageData->ulResIdPicture )
                          , MPFROMLONG( pPageData->ulCurrentDll ));
            } /* endif */

            fChange =  (BOOL)(   (  f_BMP_IsVisible && !f_BMP_ToBeVisible )
                              || ( !f_BMP_IsVisible &&  f_BMP_ToBeVisible )
                              || (  f_MLE_IsVisible && !f_MLE_ToBeVisible )
                              || ( !f_MLE_IsVisible &&  f_MLE_ToBeVisible ));

            if ( fChange ) {
                WinInvalidateRect( hwndPage, NULL, FALSE );
                WinPostMsg( hwndPage
                          , WM_USER_SIZE_TUNE
                          , MPFROMSHORT( f_MLE_ToBeVisible )
                          , MPFROMSHORT( f_BMP_ToBeVisible ));
            } else if ( f_BMP_IsVisible ) {
                WinPostMsg( hwndLoader
                          , WM_USER_PAINT_PICTURE
                          , MPFROMLONG( 0L )
                          , MPFROMLONG( 0L ));
            } /* endif */

            if ( f_MLE_ToBeVisible ) {
                if (( lLength = WinLoadString( hAnchorBlock                      // Anchor-block handle
                                             , hModuleLanguage                   // Resource identity containing the string
                                             , pPageData->ulResIdText            // String identifier
                                             , MAX_RESOURCE_STRING_LENGTH * MAX_MULTISTRING        // Size of buffer
                                             , pszBuffer )) == 0 ) {             // Buffer that is to receive the string

                    Error( "WinLoadString Id (%ld) for MLE failed. RC(%X)"
                         , pPageData->ulResIdText
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                    strcpy( pszBuffer, DEFAULT_TEXT );

                } else {
                    if ( isdigit( pszBuffer[ 0 ] ) == 0 ) {
                        Error( "WinLoadString Id (%ld) for MLE in wrong format. %c is not a digit"
                             , pPageData->ulResIdText
                             , pszBuffer[ 0 ] );
                    } else {
                        for ( iLoop = 1; iLoop < ( (int)pszBuffer[ 0 ] - (int)'0' ); iLoop++ ) {
                            lLength += WinLoadString( hAnchorBlock                         // Anchor-block handle
                                                    , hModuleLanguage                      // Resource identity containing the string
                                                    , pPageData->ulResIdText + iLoop       // String identifier
                                                    , MAX_RESOURCE_STRING_LENGTH * MAX_MULTISTRING - lLength // Size of buffer
                                                    , pszBuffer + lLength );               // Buffer that is to receive the string
                         } /* endfor */
                    } /* endif */
                } /* endif */

                pszBuffer[ lLength ] = '\0';


                WinSendMsg( hwndMLE
                          , MLM_DISABLEREFRESH
                          , MPFROMLONG( 0L )
                          , MPFROMLONG( 0L ));
                iptEnd = (LONG)LONGFROMMR( WinSendMsg( hwndMLE
                                                     , MLM_QUERYTEXTLENGTH
                                                     , MPFROMLONG( 0L )
                                                     , MPFROMLONG( 0L )));
                WinSendMsg( hwndMLE
                          , MLM_DELETE
                          , MPFROMLONG( 0L )
                          , MPFROMLONG( iptEnd ));
                WinSendMsg( hwndMLE
                          , MLM_SETIMPORTEXPORT
                          , MPFROMP( pszBuffer + 1 )
                          , MPFROMLONG( sizeof( pszBuffer ) - 1 ));
                WinSendMsg( hwndMLE
                          , MLM_IMPORT
                          , MPFROMP( &ipt )
                          , MPFROMLONG( lLength - 1 ));
                WinSendMsg( hwndMLE
                          , MLM_ENABLEREFRESH
                          , MPFROMLONG( 0L )
                          , MPFROMLONG( 0L ));
            } /* endif */

            WinPostMsg( hwndLoader
                      , WM_USER_LOAD_DLL
                      , MPFROMLONG( pPageData->ulPreloadDll1 )
                      , MPFROMLONG( pPageData->ulPreloadDll2 ));

            break;
        }
    } /* switch */
}
