#pragma strings( readonly )

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "book.h"
#include "error.h"
#include "global.h"

VOID DlgAbout( HWND hwnd );

INT iInitPerformed = 0;

// ===============================================================================================
MRESULT EXPENTRY wpNotebookClient( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
// ===============================================================================================

    MRESULT mReturn;
    BOOL    fCallOldWindowProcedure = TRUE;

    switch ( msg ) {

        //----------------------------------------------------------------------------------------
        case WM_MOUSEMOVE : {
        //----------------------------------------------------------------------------------------

            WinSetPointer( HWND_DESKTOP, hPointer );

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_BUTTON2DOWN : {
        //----------------------------------------------------------------------------------------

            WinPopupMenu( hwnd                  //  Parent-window handle
                        , hwndPage              //  Owner-window handle
                        , hwndPopup             //  Pop-up menu-window handle
                        , SHORT1FROMMP( mp1 )   //  x-coordinate of the pop-up menu position
                        , SHORT2FROMMP( mp1 )   //  y-coordinate of the pop-up menu position
                        , 0L                    //  Item identity
                        ,   PU_HCONSTRAIN       //  Options
                          | PU_VCONSTRAIN
                          | PU_NONE
                          | PU_MOUSEBUTTON1
                          | PU_MOUSEBUTTON2
                          | PU_MOUSEBUTTON3
                          | PU_KEYBOARD );

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_PRESPARAMCHANGED : {
        //----------------------------------------------------------------------------------------

            ULONG lColor = 0L;

            switch ( LONGFROMMP( mp1 )) {

                case PP_BACKGROUNDCOLOR : {

                    WinQueryPresParam( hwnd
                                     , PP_BACKGROUNDCOLOR
                                     , 0
                                     , NULL
                                     , sizeof( LONG )
                                     , &lColor
                                     , QPF_PURERGBCOLOR );

                    WinPostMsg( hwndPage
                              , WM_USER_CHANGE_COLOR
                              , MPFROMSHORT( FALSE )
                              , MPFROMLONG( lColor ));

                    WinSendMsg( hwndNotebook
                              , BKM_SETNOTEBOOKCOLORS
                              , MPFROMLONG( lColor )
                              , MPFROMSHORT( BKA_BACKGROUNDPAGECOLOR ));

                    WinSendMsg( hwndNotebook
                              , BKM_SETNOTEBOOKCOLORS
                              , MPFROMLONG( lColor )
                              , MPFROMSHORT( BKA_BACKGROUNDMAJORCOLOR ));

                    ulChangedPP |= BIT_PP_NOTEBOOK_BACKCOLOR;

                    break;
                }

                case PP_FOREGROUNDCOLOR : {

                    WinQueryPresParam( hwnd
                                     , PP_FOREGROUNDCOLOR
                                     , 0
                                     , NULL
                                     , sizeof( LONG )
                                     , &lColor
                                     , QPF_PURERGBCOLOR );

                    WinSendMsg( hwndNotebook
                              , BKM_SETNOTEBOOKCOLORS
                              , MPFROMLONG( lColor )
                              , MPFROMSHORT( BKA_FOREGROUNDMAJORCOLOR ));

                    WinInvalidateRect( hwnd, NULL, FALSE );

                    ulChangedPP |= BIT_PP_NOTEBOOK_FORECOLOR;

                    break;
                }

                case PP_FONTNAMESIZE : {

                    HPS      hPresSpace;
                    POINTL   ptlFont[ TXTBOX_COUNT ];
                    SIZEL    sizelTab = { 0L, 0L };
                    CHAR     pszBuffer[ MAX_RESOURCE_STRING_LENGTH ];
                    BOOKTEXT booktextMajorTab;
                    ULONG    ulPageId;

                    mReturn = pfnwpNotebookOld( hwnd, msg, mp1, mp2 );

                    booktextMajorTab.pString = pszBuffer;
                    booktextMajorTab.textLen = MAX_RESOURCE_STRING_LENGTH - 1;

                    ulPageId = LONGFROMMR( WinSendMsg( hwnd
                                                     , BKM_QUERYPAGEID
                                                     , MPFROMLONG( 0L )
                                                     , MPFROM2SHORT( BKA_FIRST, BKA_MAJOR )));

                    if (( hPresSpace = WinGetPS( hwndNotebook )) == NULLHANDLE ) {
                        Error( "WinGetPS for Notebook failed. RC(%X)"
                             , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                    } else {

                        if ( ulPageId == (ULONG)BOOKERR_INVALID_PARAMETERS ) {
                        } else if ( ulPageId == 0 ) {
                        } else {

                            do {

                                booktextMajorTab.textLen = MAX_RESOURCE_STRING_LENGTH - 1;

                                if ( (SHORT)SHORT1FROMMR( WinSendMsg( hwnd
                                                                    , BKM_QUERYTABTEXT
                                                                    , MPFROMLONG( ulPageId )
                                                                    , MPFROMP( &booktextMajorTab ))) < 1 ) {
                                } else if ( GpiQueryTextBox( hPresSpace
                                                           , (LONG)strlen( pszBuffer )
                                                           , pszBuffer
                                                           , TXTBOX_COUNT
                                                           , ptlFont )) {
                                    sizelTab.cx = max( sizelTab.cx, ptlFont[ TXTBOX_TOPRIGHT ].x - ptlFont[ TXTBOX_BOTTOMLEFT ].x );
                                    sizelTab.cy = max( sizelTab.cy, ptlFont[ TXTBOX_TOPRIGHT ].y - ptlFont[ TXTBOX_BOTTOMLEFT ].y );
                                } /* endif */

                                ulPageId = LONGFROMMR( WinSendMsg( hwnd
                                                                 , BKM_QUERYPAGEID
                                                                 , MPFROMLONG( ulPageId )
                                                                 , MPFROM2SHORT( BKA_NEXT, BKA_MAJOR )));
                            } while (( ulPageId != (ULONG)BOOKERR_INVALID_PARAMETERS ) && ( ulPageId != 0 )); /* enddo */

                            if (( sizelTab.cx > 0L ) && ( sizelTab.cy > 0L )) {

                                RECTL rectlOld;
                                SIZEL sizelScreen;
                                LONG  lDeltaX, lDeltaY;

                                WinQueryWindowRect( hwndPage
                                                  , &rectlOld );

                                WinMapWindowPoints( hwndPage
                                                  , HWND_DESKTOP
                                                  , (PVOID)&rectlOld
                                                  , 2L );

                                WinSendMsg( hwndNotebook
                                          , BKM_SETDIMENSIONS
                                          , MPFROM2SHORT( sizelTab.cx + TAB_WIDTH_MARGIN
                                                        , sizelTab.cy + 2 * TAB_HEIGHT_MARGIN )
                                          , MPFROMSHORT( BKA_MAJORTAB ));

                                if ( ! WinSendMsg( hwndNotebook
                                                 , BKM_CALCPAGERECT
                                                 , MPFROMP( &rectlOld )
                                                 , MPFROMSHORT( FALSE ))) {

                                    Error( "WinSendMsg( BKM_CALCPAGERECT ) for Notebook failed. RC(%X)"
                                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

                                } else if ( ! WinCalcFrameRect( hwndFrame
                                                              , &rectlOld
                                                              , FALSE )) {

                                    Error( "WinCalcFrameRect for Notebook failed. RC(%X)"
                                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

                                } else {

                                    sizelScreen.cx = WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN );
                                    sizelScreen.cy = WinQuerySysValue( HWND_DESKTOP, SV_CYSCREEN );

                                    // --- limit to screen boundary ------------------------------

                                    lDeltaX = min( 0, sizelScreen.cx - rectlOld.xRight );
                                    lDeltaY = min( 0, sizelScreen.cy - rectlOld.yTop );
                                    WinOffsetRect( hAnchorBlock, &rectlOld, lDeltaX, lDeltaY );

                                    lDeltaX = max( 0, -rectlOld.xLeft );
                                    lDeltaY = max( 0, -rectlOld.yBottom );
                                    WinOffsetRect( hAnchorBlock, &rectlOld, lDeltaX, lDeltaY );

                                    WinSetWindowPos( hwndFrame
                                                   , NULLHANDLE
                                                   , rectlOld.xLeft
                                                   , rectlOld.yBottom
                                                   , rectlOld.xRight - rectlOld.xLeft
                                                   , rectlOld.yTop - rectlOld.yBottom
                                                   , SWP_SIZE | SWP_MOVE );
                                } /* endif */

                                WinPostMsg( hwndPage
                                          , WM_USER_SIZE_TUNE
                                          , MPFROMSHORT( f_MLE_IsVisible )
                                          , MPFROMSHORT( f_BMP_IsVisible ));
                            } /* endif */

                        } /* endif */

                        WinReleasePS( hPresSpace );

                    } /* endif */

                    ulChangedPP |= BIT_PP_NOTEBOOK_FONT;

                    fCallOldWindowProcedure = FALSE;

                    break;
                }

                default: {
                    break;
                }

            } /* endswitch */

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_SIZE : {
        //----------------------------------------------------------------------------------------

            WinPostMsg( hwndPage
                      , WM_USER_SIZE_TUNE
                      , MPFROMSHORT( f_MLE_IsVisible )
                      , MPFROMSHORT( f_BMP_IsVisible ));
            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_INIT_PART_1 : {
        //----------------------------------------------------------------------------------------

            ULONG ulMLEStyle = MLS_READONLY
                             | MLS_WORDWRAP
                             | MLS_DISABLEUNDO;

            ULONG ulBMPStyle = 0L;
            MENUITEM menuitem;

            iInitPerformed = 1;

            // --- start a timer to limit initialisation time ------------------------------------

            WinStartTimer( hAnchorBlock          // Anchor-block handle
                         , hwnd                  // Window handle that is part of the timer identification
                         , ID_TIMER_INIT_TIMEOUT // Timer identifier
                         , MAX_TIME_TO_INIT );   // Delay time in milliseconds

            // --- find the window ---------------------------------------------------------------

            if (( hwndPage = WinWindowFromID( hwndNotebook, ID_NOTEBOOKPAGE ) ) == NULLHANDLE ) {
                Error( "No Pagewindow found. Shit. See README" );
            } else {

                SIZEL sizelPage = LoadSettingsSize();

                WinSetWindowBits( hwndPage
                                , QWL_STYLE
                                , WS_CLIPCHILDREN
                                , WS_CLIPCHILDREN );
                WinSetWindowPos( hwndPage
                               , NULLHANDLE
                               , 0L
                               , 0L
                               , sizelPage.cx
                               , sizelPage.cy
                               , SWP_SIZE );
            } /* endif */

            WinRegisterClass( hAnchorBlock       // Anchor-block handle
                            , WC_PRIVATE_BMP     // Window-class name
                            , (PFNWP)wpBMP       // Window-procedure identifier
                            , 0L                 // Default-window style
                            , 0L );              // Reserved storage

            hwndBMP = WinCreateWindow( hwndPage       //  Parent-window handle
                                     , WC_PRIVATE_BMP //  Registered-class name
                                     , ""             //  Window text
                                     , ulBMPStyle     //  Window style
                                     , 0L             //  x-coordinate of window position
                                     , 0L             //  y-coordinate of window position
                                     , 0L             //  Width of window, in window coordinates
                                     , 0L             //  Height of window, in window coordinates
                                     , hwndPage       //  Owner-window handle
                                     , HWND_TOP       //  Sibling-window handle
                                     , ID_BMP         //  Window identifier
                                     , NULL           //  Pointer to control data
                                     , NULL );        //  Presentation parameters

            if ( hwndBMP == NULLHANDLE ) {

                Error( "WinCreateWindow for Picture failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
            } else {

                hwndMLE = WinCreateWindow( hwndPage    //  Parent-window handle
                                         , WC_MLE      //  Registered-class name
                                         , "?"         //  Window text
                                         , ulMLEStyle  //  Window style
                                         , 0L          //  x-coordinate of window position
                                         , 0L          //  y-coordinate of window position
                                         , 0L          //  Width of window, in window coordinates
                                         , 0L          //  Height of window, in window coordinates
                                         , hwndPage    //  Owner-window handle
                                         , HWND_TOP    //  Sibling-window handle
                                         , ID_MLE      //  Window identifier
                                         , NULL        //  Pointer to control data
                                         , NULL );     //  Presentation parameters

                if ( hwndMLE == NULLHANDLE ) {

                    Error( "WinCreateWindow for MLE failed. RC(%X)"
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } else {

                    WinSendMsg( hwndMLE
                              , MLM_FORMAT
                              , MPFROMSHORT( MLFIE_NOTRANS )
                              , MPFROMLONG( 0L ));

                    // --- actionbar -------------------------------------------------------------

                    hwndMenu = WinWindowFromID( hwndFrame, FID_MENU );

                    if ( ! WinSetPresParam( hwndMenu
                                          , PP_FONTNAMESIZE
                                          , strlen( PSZ_MENU_FONT_NAME  ) + sizeof( CHAR )
                                          , PSZ_MENU_FONT_NAME )) {
                        Error( "WinSetPresParam( PP_FONTNAMESIZE / %s ) for Menu failed. RC(%X)"
                             , PSZ_MENU_FONT_NAME
                             , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                    } /* endif */

                    // --- general popupmenu -----------------------------------------------------

                    hwndPopup = WinLoadMenu( HWND_OBJECT
                                           , hModuleLanguage
                                           , ID_POPUP );

                    if ( hwndPopup == NULLHANDLE ) {
                        Error( "WinLoadMenu for Popupmenu failed. RC(%X)"
                             , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                    } else if ( ! WinSetPresParam( hwndPopup
                                                 , PP_FONTNAMESIZE
                                                 , strlen( PSZ_MENU_FONT_NAME  ) + sizeof( CHAR )
                                                 , PSZ_MENU_FONT_NAME )) {
                        Error( "WinSetPresParam( PP_FONTNAMESIZE / %s ) for Popupmenu failed. RC(%X)"
                             , PSZ_MENU_FONT_NAME
                             , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                    } /* endif */

                    // --- more window functions -------------------------------------------------

                    pfnwpFrameOld    = WinSubclassWindow( hwndFrame,    wpFrame );
                    pfnwpMenuOld     = WinSubclassWindow( hwndMenu,     wpMenu  );
                    pfnwpMLEOld      = WinSubclassWindow( hwndMLE,      wpMLE   );
                    pfnwpPageOld     = WinSubclassWindow( hwndPage,     wpPage  );

                }
            }

            if (( hPointer = WinLoadPointer( HWND_DESKTOP, NULLHANDLE, ID_POINTER )) == NULLHANDLE ) {
                hPointer = WinQuerySysPointer( HWND_DESKTOP, SPTR_ARROW, FALSE );
            } /* endif */

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_INIT_PART_2 : {
        //----------------------------------------------------------------------------------------

            iInitPerformed = 2;

            WinPostMsg( hwndLoader
                      , WM_USER_INIT_LOADER
                      , MPFROMLONG( 0L )
                      , MPFROMLONG( 0L ));

            WinSendMsg( hwndPage
                      , WM_USER_SIZE_TUNE
                      , MPFROMSHORT( FALSE )
                      , MPFROMSHORT( TRUE ));

            WinPostMsg( hwndLoader
                      , WM_USER_LOAD_BMP
                      , MPFROMLONG( ID_BMP_PICTURE_FIRST )
                      , MPFROMLONG( 0L ));

            WinPostMsg( hwndLoader
                      , WM_USER_PAINT_PICTURE
                      , MPFROMLONG( 0L )
                      , MPFROMLONG( 0L ));

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_USER_INIT_PART_3 : {
        //----------------------------------------------------------------------------------------

            POINTL pointlFrame;

            HelpMenuUpdate();
            LoadSettingsPresParam();
            pointlFrame = LoadSettingsPos();

            // --- display the notebook --------------------------------------------------------------

            if ( ! WinSetWindowPos( hwndFrame     // Window handle
                                  , 0             // Relative window-placement order
                                  , pointlFrame.x // Window position, x-coordinate
                                  , pointlFrame.y // Window position, y-coordinate
                                  , 0             // Window size cx
                                  , 0             // Window size cy
                                  ,    SWP_SHOW   // Window-positioning options
                                     | SWP_ACTIVATE
                                     | SWP_MOVE  )) {

                Error( "WinSetWindowPos( SWP_SHOW ) for Notebook failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
            } /* endif */

            ulChangedPP = 0x00000000;

            WinPostMsg( hwndLoader
                      , WM_USER_LOAD_DLL
                      , MPFROMLONG( 1L )
                      , MPFROMLONG( 0L ));

            iInitPerformed = 3;

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_TIMER : {
        //----------------------------------------------------------------------------------------

            if ( SHORT1FROMMP( mp1 ) == ID_TIMER_INIT_TIMEOUT ) {

                WinStopTimer( hAnchorBlock              // Anchor-block handle
                            , hwnd                      // Window handle
                            , ID_TIMER_INIT_TIMEOUT );  // Timer identifier

                if ( iInitPerformed < 3 ) {
                    Error( "Initialisation Timeout" );
                    WinPostMsg( hwnd
                              , WM_QUIT
                              , MPFROMLONG( 0L )
                              , MPFROMLONG( 0L ));
                } /* endif */

            } /* endif */

            fCallOldWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_COMMAND : {
        //----------------------------------------------------------------------------------------

            USHORT usCommand = SHORT1FROMMP( mp1 );

            switch ( usCommand ) {

                case ID_MENU_ABOUT : {

                    DlgAbout( hwnd );
                    break;
                }

                case ID_MENU_DEFAULT_COLOR : {

                    LoadDefaultColor();
                    break;
                }

                case ID_MENU_DEFAULT_FONT : {

                    LoadDefaultFont();
                    break;
                }

                case ID_MENU_EXIT :
                case ID_KEY_EXIT : {

                    WinPostMsg( hwnd, WM_CLOSE, MPFROMLONG( 0L ), MPFROMLONG( 0L ));
                    break;
                }

                case ID_MENU_HELPINDEX : {
                    WinSendMsg( hwndHelp, HM_HELP_INDEX, MPFROMLONG( 0L ), MPFROMLONG( 0L ));
                    break;
                }

                case ID_MENU_HELPGENERAL : {
                    WinSendMsg( hwndHelp, HM_EXT_HELP, MPFROMLONG( 0L ), MPFROMLONG( 0L ));
                    break;
                }

                case ID_MENU_HELPKEYS : {
                    WinSendMsg( hwndHelp, HM_KEYS_HELP, MPFROMLONG( 0L ), MPFROMLONG( 0L ));
                    break;
                }

                case ID_MENU_HELPUSING : {
                    WinSendMsg( hwndHelp, HM_DISPLAY_HELP, MPFROMLONG( 0L ), MPFROMLONG( 0L ));
                    break;
                }

                default : {
                    break;
                }
            }

            break;
        }

        //----------------------------------------------------------------------------------------
        case HM_QUERY_KEYS_HELP : {
        //----------------------------------------------------------------------------------------

            fCallOldWindowProcedure = FALSE;
            mReturn = MRFROMSHORT( PANEL_HELP_KEYS );

            break;
        }


        //----------------------------------------------------------------------------------------
        default : {
        //----------------------------------------------------------------------------------------

            break;
        }
    }

    if ( fCallOldWindowProcedure ) {
        mReturn = pfnwpNotebookOld( hwnd, msg, mp1, mp2 );
    } /* endif */

    return mReturn;
}

