#pragma strings( readonly )

#include <string.h>
#include "clerical.h"
#include "error.h"
#include "global.h"


// ===============================================================================================
MRESULT EXPENTRY wpBMP( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 ) {
// ===============================================================================================

    MRESULT mReturn;
    BOOL    fCallDefaultWindowProcedure = TRUE;

    switch ( msg ) {

        //----------------------------------------------------------------------------------------
        case WM_MOUSEMOVE : {
        //----------------------------------------------------------------------------------------

            WinSetPointer( HWND_DESKTOP, hPointer );

            fCallDefaultWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_PRESPARAMCHANGED : {
        //----------------------------------------------------------------------------------------

            ULONG ulColor = 0L, ulAttrFound = 0L;

            switch ( LONGFROMMP( mp1 )) {

                case PP_FOREGROUNDCOLOR :
                case PP_BACKGROUNDCOLOR : {

                    WinQueryPresParam( hwnd
                                     , LONGFROMMP( mp1 )
                                     , 0
                                     , &ulAttrFound
                                     , sizeof( ULONG )
                                     , &ulColor
                                     , QPF_PURERGBCOLOR );

                    if ( ulAttrFound == PP_FOREGROUNDCOLOR ) {
                        WinPostMsg( hwndLoader
                                  , WM_USER_CHANGE_COLOR
                                  , MPFROMSHORT( TRUE )
                                  , MPFROMLONG( ulColor ));

                        ulChangedPP |= BIT_PP_BITMAP_FORECOLOR;

                    } else if (  ulAttrFound == PP_BACKGROUNDCOLOR ) {
                        WinPostMsg( hwndLoader
                                  , WM_USER_CHANGE_COLOR
                                  , MPFROMSHORT( FALSE )
                                  , MPFROMLONG( ulColor ));

                        ulChangedPP |= BIT_PP_BITMAP_BACKCOLOR;

                    } /* endif */

                    break;
                }

                default: {
                    break;
                }

            } /* endswitch */

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_PAINT : {
        //----------------------------------------------------------------------------------------

            if ( f_BMP_IsVisible ) {
                WinPostMsg( hwndLoader
                          , WM_USER_PAINT_PICTURE
                          , MPFROMLONG( 0L )
                          , MPFROMLONG( 0L ));
            } /* endif */

            break;
        }

        //----------------------------------------------------------------------------------------
        case WM_BUTTON2DOWN : {
        //----------------------------------------------------------------------------------------

            WinPopupMenu( hwnd                  //  Parent-window handle
                        , hwndPage              //  Owner-window handle
                        , hwndPopup             //  Pop-up menu-window handle
                        , SHORT1FROMMP( mp1 )   //  x-coordinate of the pop-up menu position
                        , SHORT2FROMMP( mp1 )   //  y-coordinate of the pop-up menu position
                        , 0L                    //  Item identity
                        ,   PU_HCONSTRAIN       //  Options
                          | PU_VCONSTRAIN
                          | PU_NONE
                          | PU_MOUSEBUTTON1
                          | PU_MOUSEBUTTON2
                          | PU_MOUSEBUTTON3
                          | PU_KEYBOARD );

            fCallDefaultWindowProcedure = FALSE;
            mReturn = 0L;

            break;
        }

        //----------------------------------------------------------------------------------------
        default : {
        //----------------------------------------------------------------------------------------

            break;
        }
    }

    if ( fCallDefaultWindowProcedure ) {
        mReturn = WinDefWindowProc( hwnd, msg, mp1, mp2 );
    } /* endif */

    return mReturn;
}

