#pragma strings( readonly )

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "book.h"
#include "error.h"
#include "global.h"
#include "getopt.h"

VOID _System LoaderThread( ULONG ulParameter );

// ===============================================================================================
INT main( int argc, char *argv[], char *envp[] ) {
// ===============================================================================================

    INT    iReturnValue = 1;
    HMQ    hMsgQueue;
    QMSG   QueueMsg;

#if ( defined ( INCL_VALAPI ) || defined ( INCL_VAL ))

    HVAL    hValidate;

    hValidate = ValInitialize( PSZ_VALIDATOR_EXE
                             , PSZ_VALIDATOR_LOG
                             ,   VL_ERRORLOG
                               | VL_FILELINE
                               | VL_VIEWPORT );

#endif /* INCL_VALAPI || INCL_VAL */

    hAnchorBlock = WinInitialize( 0L );             // Initialization options

    if ( hAnchorBlock == NULLHANDLE ) {

        hMsgQueue = 0;
        WinAlarm( HWND_DESKTOP, WA_ERROR );
        fprintf( stderr
               , "WinInitialize failed." );

    } else {

        // --- create messge queue for the thread ------------------------------------------------

        hMsgQueue = WinCreateMsgQueue( hAnchorBlock // Anchor Block handle
                                     , 0L );        // Queue size, use default

        if ( hMsgQueue == NULLHANDLE ) {

            WinAlarm( HWND_DESKTOP, WA_ERROR );
            WinAlarm( HWND_DESKTOP, WA_ERROR );
            fprintf( stderr
                   , "WinCreateMsgQueue failed. RC(%X)"
                   , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

        } else {

            APIRET rc;                              // Return code
            TID    tidLoader    = 0;                // ID returned for newly created thread
            ULONG  ulThreadParm = (ULONG)argv[ 0 ]; // Parameter to thread routine
            PSZ    pszDllFileName  = NULL;
            PSZ    pszIniName   = INI_FILENAME;
            BOOL   fIniReadonly = FALSE;
            BOOL   fOptionError = FALSE;
            INT    iOption;

            // --- get Options -------------------------------------------------------------------

            while (( iOption = getopt( argc, argv, "i:l:I:L:RrHh" )) != EOF ) {

                switch ( iOption ) {
                    case 'I' :
                    case 'i' : {
                        pszIniName = optarg;
                        break;
                    }
                    case 'L' :
                    case 'l' : {
                        pszDllFileName = optarg;
                        break;
                    }
                    case 'R' :
                    case 'r' : {
                        fIniReadonly = TRUE;
                        break;
                    }
                    case 'H' :
                    case 'h' :
                    case '?' : {
                        fOptionError = TRUE;
                        break;
                    }
                    default : {
                        Error( "getopt internal error" );
                        break;
                    }
                } /* endswitch */
            } /* endwhile */

            if ( fOptionError ) {
                Error( "Usage: %s [-l language.dll] [-i inifile] [-r]\n"
                       "\n"
                       "  -l .. setup another language\n"
                       "  -i .. change default filename for INI\n"
                       "  -r .. INI is readonly\n"
                       "\n"
                       " Using defaults !", argv[ 0 ] );
            } /* endif */

            if ( pszDllFileName != NULL ) {

                // --- Load the Languagemodule ---------------------------------------------------
                //
                // You have to add the pszDllFileName after the last \ from the full exefilename.
                // Don't forget to check all.
                // If there happens an error, you have to use the german (default) version.
                //

                ULONG  ulMaxPathLength = 0;
                PSZ    pszFullDllFileName;

                hModuleLanguage = NULLHANDLE;  // use default

                rc = DosQuerySysInfo( QSV_MAX_PATH_LENGTH  // Ordinal of the first system variable
                                    , QSV_MAX_PATH_LENGTH  // Ordinal of the last system variable
                                    , &ulMaxPathLength     // Address of the data buffer
                                    , sizeof( ULONG ));    // Length, in bytes, of the data buffer
                                                           //   includes \0 character !

                if (( rc != NO_ERROR ) || ( ulMaxPathLength < ( 3 + 8 + 1 + 3 + 1 ))) { // c:\filename.dos

                    // --- why me ----------------------------------------------------------------

                    Error( "DosQuerySysInfo failed RC(%X)\nor\nmaximal Pathlength = %ld"
                         , rc
                         , ulMaxPathLength );

                } else if ( strchr( argv[ 0 ], '\\' ) == NULL ) {

                    // --- os2 should give you the full name, why is there no \ -----------------

                    Error( "No \\ found in full exefilename ?" );

                } else if (( pszFullDllFileName = (PSZ)malloc( ulMaxPathLength * sizeof( CHAR ))) == NULL ) {

                    // --- no virtual memory, that a real problem --------------------------------

                    Error( "No memory !!" );

                } else {

                    PSZ pszStart;

                    strcpy( pszFullDllFileName, argv[ 0 ] );
                    pszStart = strrchr( pszFullDllFileName, '\\' ) + 1;

                    *pszStart = '\0';

                    if (( strlen( pszFullDllFileName ) + strlen( pszDllFileName )) >= ulMaxPathLength ) {

                        // --- the sum is to great, maybe ..\x\..\x\..\x -------------------------

                        Error( "Full dllfilename longer than allowed\n%s + %s"
                             , pszFullDllFileName
                             , pszDllFileName );

                    } else {

                        CHAR acFailureBuffer[ 128 ];

                        strcpy( pszStart, pszDllFileName );

                        // --- good assembly, wrong name ? ---------------------------------------

                        if (( rc = DosLoadModule( acFailureBuffer           // Failure information buffer
                                                , sizeof( acFailureBuffer ) // Size of buffer
                                                , pszFullDllFileName        // Module to load
                                                , &hModuleLanguage )        // Module handle returned
                                ) != NO_ERROR ) {

                            hModuleLanguage = NULLHANDLE;  // use default
                            Error( "DosLoadModule(%s) failed RC(%X)", pszFullDllFileName, rc );

                        } /* endif */
                    } /* endif */

                    free( pszFullDllFileName );

                } /* endif */
            } /* endif */

            SettingsInit( pszIniName, fIniReadonly );

            // --- create Loader -----------------------------------------------------------------

            rc = DosCreateThread( &tidLoader            // Thread ID (returned by function)
                                , &LoaderThread         // Address of thread program
                                , ulThreadParm          // Parameter passed to ThreadProc
                                ,    CREATE_SUSPENDED   // Thread is waiting when created
                                   | STACK_SPARSE       // Do not pre-commit stack pages
                                , 16384L );             // Stack size 16kByte

            if ( rc != NO_ERROR ) {
                Error( "DosCreateThread error : RC(%X)", rc );
            } else {

                // --- main book structure -------------------------------------------------------

                ULONG    ulIndex;
                PAGEDATA pPageData[ MAX_PAGES ] = BOOKSETUP;  // look book.h

                // --- it's time to create a window ----------------------------------------------

                if ( ! BookConstructor( MAX_PAGES, pPageData, tidLoader )) {

                    DosKillThread( tidLoader );  // dirty way

                } else {

                    HelpConstructor( argv[ 0 ] );

                    // --- Standard message processing loop. WinGetMsg returns FALSE if the ------
                    //     returned message is WM_QUIT.
                    //     Returns TRUE for all other messages

                    while ( WinGetMsg( hAnchorBlock    // Anchor block handle
                                     , &QueueMsg       // Pointer to queue message structure
                                     , 0               // No window message filter
                                     , 0               // Retrieve all messages
                                     , 0 )) {          // Retrieve all messages

                        WinDispatchMsg( hAnchorBlock   // Anchor block handle
                                      , &QueueMsg );   // structure holding message
                    } /* endwhile */

                    HelpDestructor();

                    // --- the WM_QUIT message has been received.  Destroy all and ---------------
                    //     try to remove the second thread

                    if ( hwndLoader == NULLHANDLE ) {

                        DosKillThread( tidLoader );

                    } else if ( ! WinPostMsg( hwndLoader           // Window handle
                                            , WM_CLOSE             // Message identity
                                            , MPFROMLONG( 0L )     // Parameter 1
                                            , MPFROMLONG( 0L ))) { // Parameter 2

                        DosKillThread( tidLoader );

                    } else {

                        // --- why is there no timeout for DosWaitThread ! -----------------------

                        rc = DosWaitThread( &tidLoader  // Address of the thread identification
                                          , DCWW_WAIT); // An indicator that specifies whether to return if no thread has ended

                        if ( rc != NO_ERROR ) {
                            Error( "DosWaitThread error : RC(%X)", rc );
                        } /* endif */

                    } /* endif */

                    iReturnValue = 0;   // success

                } /* endif */

                if ( ! fIniReadonly ) {

                    // --- try to save some values for the next session --------------------------

                    SaveSettings();

                } /* endif */

            } /* endif */

            SettingsExit();

            // --- free all you have -------------------------------------------------------------

            BookDestructor();

            if ( hModuleLanguage != NULLHANDLE ) {
                DosFreeModule( hModuleLanguage );
            } /* endif */

            WinDestroyMsgQueue( hMsgQueue );        // Tidy up...

        } /* endif */

        WinTerminate( hAnchorBlock );     // Terminate the application

    } /* endif */

    // --- bye bye -------------------------------------------------------------------------------

    return iReturnValue;
}
