#pragma strings( readonly )

#include <string.h>
#include <stdlib.h>
#include "clerical.h"
#include "error.h"
#include "global.h"

HINI hini = NULLHANDLE;

// ===============================================================================================
BOOL SettingsInit( PSZ pszIniFilename, BOOL fReadonly ) {
// ===============================================================================================

    BOOL fSuccess = TRUE;

    if (( hini = PrfOpenProfile( hAnchorBlock
                               , pszIniFilename )) == NULLHANDLE ) {
        if ( ! fReadonly ) {
            Error( "PrfOpenProfile %s failed. RC(%X)\nData will not be saved."
                 , pszIniFilename
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
            fSuccess = FALSE;
        } /* endif */
    } /* endif */

    return fSuccess;
}

// ===============================================================================================
VOID SettingsExit( VOID ) {
// ===============================================================================================

    if ( hini != NULLHANDLE ) {
        PrfCloseProfile( hini );
        hini = NULLHANDLE;
    } /* endif */
}

// ===============================================================================================
VOID SaveSettings( VOID ) {
// ===============================================================================================

    LONG   lColor = 0L;
    RECTL  rectl;
    SIZEL  sizel;
    POINTL pointl;
    CHAR   pcFont[ FACESIZE + 1 ];
    ULONG  ulLength;

    pcFont[ FACESIZE ] = '\0';

    if ( hini != NULLHANDLE ) {

        if ( ulChangedPP & BIT_PP_INVALID ) {
            Error( "Unknown Parameter to save" );
        } /* endif */

        // --- bmp window ----------------------------------------------------------------------------

        if ( ulChangedPP & BIT_PP_BITMAP_FORECOLOR ) {
            if ( WinQueryPresParam( hwndBMP
                                  , PP_FOREGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_BMP        // Application name
                                          , INI_KEY2_FORECOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_BMP
                         , INI_KEY2_FORECOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        if ( ulChangedPP & BIT_PP_BITMAP_BACKCOLOR ) {
            if ( WinQueryPresParam( hwndBMP
                                  , PP_BACKGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_BMP        // Application name
                                          , INI_KEY2_BACKCOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_BMP
                         , INI_KEY2_BACKCOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        // --- mle window ------------------------------------------------------------------------

        if ( ulChangedPP & BIT_PP_MLE_FORECOLOR ) {
            if ( WinQueryPresParam( hwndMLE
                                  , PP_FOREGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_MLE        // Application name
                                          , INI_KEY2_FORECOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_MLE
                         , INI_KEY2_FORECOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        if ( ulChangedPP & BIT_PP_MLE_BACKCOLOR ) {
            if ( WinQueryPresParam( hwndMLE
                                  , PP_BACKGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_MLE        // Application name
                                          , INI_KEY2_BACKCOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_MLE
                         , INI_KEY2_BACKCOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        if ( ulChangedPP & BIT_PP_MLE_FONT ) {
            if (( ulLength = WinQueryPresParam( hwndMLE
                                              , PP_FONTNAMESIZE
                                              , 0
                                              , NULL
                                              , FACESIZE
                                              , pcFont
                                              , 0L )) != 0 ) {
                pcFont[ ulLength ] = '\0';
                if ( ! PrfWriteProfileString( hini            // Initialization-file handle
                                            , INI_KEY1_MLE    // Application name
                                            , INI_KEY2_FONT   // Key name
                                            , pcFont )) {     // Textstring
                    Error( "PrfWriteProfileString for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_MENU
                         , INI_KEY2_FONT
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        // --- page window ---------------------------------------------------------------------------

        if ( WinQueryWindowRect( hwndPage
                               , &rectl )) {
            sizel.cx = rectl.xRight - rectl.xLeft;
            sizel.cy = rectl.yTop - rectl.yBottom;
            if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                      , INI_KEY1_PAGE       // Application name
                                      , INI_KEY2_SIZE       // Key name
                                      , &sizel              // Value data
                                      , sizeof( SIZEL ))) { // Size of value data
                Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                     , INI_KEY1_PAGE
                     , INI_KEY2_SIZE
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
            } /* endif */
        } /* endif */

        // --- notebook window -------------------------------------------------------------------

        if ( ulChangedPP & BIT_PP_NOTEBOOK_FORECOLOR ) {
            if ( WinQueryPresParam( hwndNotebook
                                  , PP_FOREGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_BOOK       // Application name
                                          , INI_KEY2_FORECOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_BOOK
                         , INI_KEY2_FORECOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        if ( ulChangedPP & BIT_PP_NOTEBOOK_BACKCOLOR ) {
            if ( WinQueryPresParam( hwndNotebook
                                  , PP_BACKGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_BOOK       // Application name
                                          , INI_KEY2_BACKCOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_BOOK
                         , INI_KEY2_BACKCOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        if ( ulChangedPP & BIT_PP_NOTEBOOK_FONT ) {
            if (( ulLength = WinQueryPresParam( hwndNotebook
                                              , PP_FONTNAMESIZE
                                              , 0
                                              , NULL
                                              , FACESIZE
                                              , pcFont
                                              , 0L )) != 0 ) {
                pcFont[ ulLength ] = '\0';
                if ( ! PrfWriteProfileString( hini            // Initialization-file handle
                                            , INI_KEY1_BOOK   // Application name
                                            , INI_KEY2_FONT   // Key name
                                            , pcFont )) {     // Textstring
                    Error( "PrfWriteProfileString for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_BOOK
                         , INI_KEY2_FONT
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        // --- menu window -----------------------------------------------------------------------

        if ( ulChangedPP & BIT_PP_MENU_FORECOLOR ) {
            if ( WinQueryPresParam( hwndMenu
                                  , PP_MENUFOREGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_MENU       // Application name
                                          , INI_KEY2_FORECOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_MENU
                         , INI_KEY2_FORECOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        if ( ulChangedPP & BIT_PP_MENU_BACKCOLOR ) {
            if ( WinQueryPresParam( hwndMenu
                                  , PP_MENUBACKGROUNDCOLOR
                                  , 0
                                  , NULL
                                  , sizeof( LONG )
                                  , &lColor
                                  , 0L ) != 0 ) {
                if ( ! PrfWriteProfileData( hini                // Initialization-file handle
                                          , INI_KEY1_MENU       // Application name
                                          , INI_KEY2_BACKCOLOR  // Key name
                                          , &lColor             // Value data
                                          , sizeof( LONG ))) {  // Size of value data
                    Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_MENU
                         , INI_KEY2_BACKCOLOR
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        if ( ulChangedPP & BIT_PP_MENU_FONT ) {
            if (( ulLength = WinQueryPresParam( hwndMenu
                                              , PP_FONTNAMESIZE
                                              , 0
                                              , NULL
                                              , FACESIZE
                                              , pcFont
                                              , 0L )) != 0 ) {
                pcFont[ ulLength ] = '\0';
                if ( ! PrfWriteProfileString( hini            // Initialization-file handle
                                            , INI_KEY1_MENU   // Application name
                                            , INI_KEY2_FONT   // Key name
                                            , pcFont )) {     // Textstring
                    Error( "PrfWriteProfileString for %s-%s failed. RC(%X)\nData NOT saved."
                         , INI_KEY1_MENU
                         , INI_KEY2_FONT
                         , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
                } /* endif */
            } /* endif */
        } /* endif */

        // --- frame window ----------------------------------------------------------------------

        if (    WinQueryWindowRect( hwndFrame
                                  , &rectl )
             && WinMapWindowPoints( hwndFrame     // Handle of the window from whose coordinates points are to be mapped
                                  , HWND_DESKTOP  // Handle of the window to whose coordinates points are to be mapped
                                  , (PVOID)&rectl // Points to be mapped to the new coordinate system
                                  , 2L )) {       // Number of points to be mapped
            pointl.x = rectl.xLeft;
            pointl.y = rectl.yBottom;
        } else {
            pointl.x = 10L;
            pointl.y = 10L;
        } /* endif */

        if ( ! PrfWriteProfileData( hini                 // Initialization-file handle
                                  , INI_KEY1_FRAME       // Application name
                                  , INI_KEY2_POS         // Key name
                                  , &pointl              // Value data
                                  , sizeof( POINTL ))) { // Size of value data
            Error( "PrfWriteProfileData for %s-%s failed. RC(%X)\nData NOT saved."
                 , INI_KEY1_FRAME
                 , INI_KEY2_POS
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        ulChangedPP = 0x00000000;

    } /* endif */
}

// ===============================================================================================
VOID LoadSettingsPresParam( VOID ) {
// ===============================================================================================

    LONG   lColor = 0L;
    CHAR   pcFont[ FACESIZE + 1 ];
    ULONG  ulLength, ulBufferSize;

    pcFont[ FACESIZE ] = '\0';

    if ( hini == NULLHANDLE ) {
        LoadDefaultFont();
        LoadDefaultColor();
    } else {

        // --- menu window -----------------------------------------------------------------------

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_MENU       // Application name
                                  , INI_KEY2_FORECOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_OUTPUTTEXT, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndMenu
                              , PP_MENUFOREGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_BMP
                 , INI_KEY2_FORECOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_MENU       // Application name
                                  , INI_KEY2_BACKCOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndMenu
                              , PP_MENUBACKGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_BMP
                 , INI_KEY2_BACKCOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        PrfQueryProfileString( hini                // Initialization-file handle
                             , INI_KEY1_MENU       // Application name
                             , INI_KEY2_FONT       // Key name
                             , PSZ_MENU_FONT_NAME  // Default string
                             , pcFont              // Profile string
                             , FACESIZE );         // Maximum string length

        if ( ! WinSetPresParam( hwndMenu
                              , PP_FONTNAMESIZE
                              , strlen( pcFont ) + sizeof( CHAR )
                              , &pcFont ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_MENU
                 , INI_KEY2_FONT
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        // --- notebook window -------------------------------------------------------------------

        PrfQueryProfileString( hini                    // Initialization-file handle
                             , INI_KEY1_BOOK           // Application name
                             , INI_KEY2_FONT           // Key name
                             , PSZ_NOTEBOOK_FONT_NAME  // Default string
                             , pcFont                  // Profile string
                             , FACESIZE );             // Maximum string length

        if ( ! WinSetPresParam( hwndNotebook
                              , PP_FONTNAMESIZE
                              , strlen( pcFont ) + sizeof( CHAR )
                              , &pcFont ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_BOOK
                 , INI_KEY2_FONT
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_BOOK       // Application name
                                  , INI_KEY2_BACKCOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndNotebook
                              , PP_BACKGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_BOOK
                 , INI_KEY2_BACKCOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_BOOK       // Application name
                                  , INI_KEY2_FORECOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_WINDOWTEXT, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndNotebook
                              , PP_FOREGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_BOOK
                 , INI_KEY2_FORECOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        // --- mle window ------------------------------------------------------------------------

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_MLE        // Application name
                                  , INI_KEY2_FORECOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_OUTPUTTEXT, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndMLE
                              , PP_FOREGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_MLE
                 , INI_KEY2_FORECOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_MLE        // Application name
                                  , INI_KEY2_BACKCOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndMLE
                              , PP_BACKGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_MLE
                 , INI_KEY2_BACKCOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        PrfQueryProfileString( hini                // Initialization-file handle
                             , INI_KEY1_MLE        // Application name
                             , INI_KEY2_FONT       // Key name
                             , PSZ_MLE_FONT_NAME   // Default string
                             , pcFont              // Profile string
                             , FACESIZE );         // Maximum string length

        if ( ! WinSetPresParam( hwndMLE
                              , PP_FONTNAMESIZE
                              , strlen( pcFont ) + sizeof( CHAR )
                              , &pcFont ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_MLE
                 , INI_KEY2_FONT
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        // --- bmp window ----------------------------------------------------------------------------

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_BMP        // Application name
                                  , INI_KEY2_FORECOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_OUTPUTTEXT, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndBMP
                              , PP_FOREGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_BMP
                 , INI_KEY2_FORECOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */

        ulBufferSize = sizeof( LONG );
        if ( ! PrfQueryProfileData( hini                // Initialization-file handle
                                  , INI_KEY1_BMP        // Application name
                                  , INI_KEY2_BACKCOLOR  // Key name
                                  , &lColor             // Value data
                                  , &ulBufferSize )) {  // Size of value data
            lColor = WinQuerySysColor( HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0L );
        } /* endif */

        if ( ! WinSetPresParam( hwndBMP
                              , PP_BACKGROUNDCOLOR
                              , sizeof( LONG )
                              , &lColor ) != 0 ) {
            Error( "WinSetPresParam for %s-%s failed. RC(%X)"
                 , INI_KEY1_BMP
                 , INI_KEY2_BACKCOLOR
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));
        } /* endif */
    } /* endif */
}

// ===============================================================================================
POINTL LoadSettingsPos( VOID ) {
// ===============================================================================================

    POINTL pointl;
    ULONG  ulBufferSize;

    pointl.x = 10L;
    pointl.y = 10L;

    if ( hini != NULLHANDLE ) {

        // --- frame window ----------------------------------------------------------------------

        ulBufferSize = sizeof( POINTL );
        if ( ! PrfQueryProfileData( hini                 // Initialization-file handle
                                  , INI_KEY1_FRAME       // Application name
                                  , INI_KEY2_POS         // Key name
                                  , &pointl              // Value data
                                  , &ulBufferSize )) {   // Size of value data
        } /* endif */
    } /* endif */

    return pointl;
}

// ===============================================================================================
SIZEL LoadSettingsSize( VOID ) {
// ===============================================================================================

    SIZEL  sizel;
    ULONG  ulBufferSize;

    sizel.cx = WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN ) / 2;
    sizel.cy = (LONG)( sizel.cx * BMP_RATIO_FULL );

    if ( hini != NULLHANDLE ) {

        // --- page window -----------------------------------------------------------------------

        ulBufferSize = sizeof( SIZEL );
        if ( ! PrfQueryProfileData( hini                 // Initialization-file handle
                                  , INI_KEY1_PAGE        // Application name
                                  , INI_KEY2_SIZE        // Key name
                                  , &sizel               // Value data
                                  , &ulBufferSize )) {   // Size of value data
        } /* endif */
    } /* endif */

    return sizel;
}

// ===============================================================================================
VOID LoadDefaultColor( VOID ) {
// ===============================================================================================

    LONG   lColorForeground, lColorBackground;
    HWND   hwndAll[ 3 ];
    INT    iLoop;
    ULONG  ulSizeOfLong = sizeof( LONG );

    hwndAll[ 0 ] = hwndNotebook;
    hwndAll[ 1 ] = hwndBMP;
    hwndAll[ 2 ] = hwndMLE;

    lColorForeground = WinQuerySysColor( HWND_DESKTOP, SYSCLR_OUTPUTTEXT, 0L );
    lColorBackground = WinQuerySysColor( HWND_DESKTOP, SYSCLR_DIALOGBACKGROUND, 0L );

    WinSetPresParam( hwndMenu
                   , PP_MENUFOREGROUNDCOLOR
                   , ulSizeOfLong
                   , &lColorForeground );
    WinSetPresParam( hwndMenu
                   , PP_MENUBACKGROUNDCOLOR
                   , ulSizeOfLong
                   , &lColorBackground );

    for ( iLoop = 0; iLoop < 3; iLoop++ ) {

        WinSetPresParam( hwndAll[ iLoop ]
                       , PP_FOREGROUNDCOLOR
                       , ulSizeOfLong
                       , &lColorForeground );
        WinSetPresParam( hwndAll[ iLoop ]
                       , PP_BACKGROUNDCOLOR
                       , ulSizeOfLong
                       , &lColorBackground );
    } /* endfor */
}

// ===============================================================================================
VOID LoadDefaultFont( VOID ) {
// ===============================================================================================

    // --- menu window -----------------------------------------------------------------------

    WinSetPresParam( hwndMenu
                   , PP_FONTNAMESIZE
                   , strlen( PSZ_MENU_FONT_NAME ) + sizeof( CHAR )
                   , PSZ_MENU_FONT_NAME );

    // --- notebook window -------------------------------------------------------------------

    WinSetPresParam( hwndNotebook
                   , PP_FONTNAMESIZE
                   , strlen( PSZ_NOTEBOOK_FONT_NAME ) + sizeof( CHAR )
                   , PSZ_NOTEBOOK_FONT_NAME );

    // --- mle window ------------------------------------------------------------------------

    WinSetPresParam( hwndMLE
                   , PP_FONTNAMESIZE
                   , strlen( PSZ_MLE_FONT_NAME ) + sizeof( CHAR )
                   , PSZ_MLE_FONT_NAME );
}

