#pragma strings( readonly )

#include <stdlib.h>
#include <float.h>
#include "clerical.h"
#include "error.h"
#include "global.h"

#pragma handler( LoaderThread )

// ===============================================================================================
VOID _System LoaderThread( ULONG ulParameter ) {
// ===============================================================================================

    HMQ  hMsgQueue2;
    QMSG QueueMsg2;

    _fpreset(); // This call ensures that the floating-point chip is in the correct state for the thread

    hAnchorBlock2 = WinInitialize( 0 );

    if ( hAnchorBlock2 ) {

        // --- create messge queue for the thread ------------------------------------------------

        hMsgQueue2 = WinCreateMsgQueue( hAnchorBlock2 // Anchor Block handle
                                      , 30L );        // Queue size, default is 10
        if ( hMsgQueue2 ) {

            // --- disable WM_QUIT msg ( WM_QUIT will come from mainthread ) ---------------------

            WinCancelShutdown( hMsgQueue2, TRUE );

            if ( ! WinRegisterClass( hAnchorBlock2  // Anchor-block handle
                            , WC_PRIVATE_LOADER     // Window-class name
                            , (PFNWP)wpLoader       // Window-procedure identifier
                            , 0L                    // Default-window style
                            , 0L )) {               // Reserved storage

                Error( "WinRegisterClass for Loader failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock2 )));

            } else if (( hwndLoader = WinCreateWindow( HWND_OBJECT         //  Parent-window handle
                                                     , WC_PRIVATE_LOADER   //  Registered-class name
                                                     , ""                  //  Window text
                                                     , 0L                  //  Window style
                                                     , 0L                  //  x-coordinate of window position
                                                     , 0L                  //  y-coordinate of window position
                                                     , 0L                  //  Width of window, in window coordinates
                                                     , 0L                  //  Height of window, in window coordinates
                                                     , HWND_OBJECT         //  Owner-window handle
                                                     , HWND_BOTTOM         //  Sibling-window handle
                                                     , 0L                  //  Window identifier
                                                     , (PVOID)ulParameter  //  Pointer to control data
                                                     , NULL ))             //  Presentation parameters
                                     == NULLHANDLE ) {

                Error( "WinCreateWindow for Loader failed. RC(%X)"
                     , ERRORIDERROR( WinGetLastError( hAnchorBlock2 )));

            } else {

                WinPostMsg( hwndNotebook
                          , WM_USER_INIT_PART_2
                          , MPFROMLONG( 0L )
                          , MPFROMLONG( 0L ));

                // --- Standard message processing loop. WinGetMsg returns FALSE if the ----------
                //     returned message is WM_QUIT.
                //     Returns TRUE for all other messages

                while ( WinGetMsg( hAnchorBlock2   // Anchor block handle
                                 , &QueueMsg2      // Pointer to queue message structure
                                 , 0               // No window message filter
                                 , 0               // Retrieve all messages
                                 , 0 )) {          // Retrieve all messages

                    // --- look if the current msg is uptodate -----------------------------------

                    if (    ( QueueMsg2.hwnd == hwndLoader )
                         && ( QueueMsg2.msg  == WM_USER_LOAD_BMP )
                         && WinPeekMsg( hAnchorBlock2      // Anchor block handle
                                      , &QueueMsg2         // Pointer to queue message structure
                                      , hwndLoader         // Only for this window
                                      , WM_USER_LOAD_BMP   // Check only this message
                                      , WM_USER_LOAD_BMP   // Check only this message
                                      , PM_NOREMOVE )) {   // Option

                        // --- Don't dispatch this Message, there is another one in the Queue ----

                    } else if (    ( QueueMsg2.hwnd == hwndLoader )
                                && ( QueueMsg2.msg  == WM_USER_PAINT_PICTURE )
                                && WinPeekMsg( hAnchorBlock2          // Anchor block handle
                                             , &QueueMsg2             // Pointer to queue message structure
                                             , hwndLoader             // Only for this window
                                             , WM_USER_LOAD_BMP       // Check this message
                                             , WM_USER_PAINT_PICTURE  //   and this message
                                             , PM_NOREMOVE )) {       // Option

                        // --- Don't dispatch this Message, there is another one in the Queue or -
                        //     a new bitmak will be loaded

                    } else {

                        WinDispatchMsg( hAnchorBlock2  // Anchor block handle
                                      , &QueueMsg2 );  // structure holding message

                    } /* endif */
                } /* endwhile */

                // --- the WM_QUIT message has been received.  Destroy all -----------------------

                WinDestroyWindow( hwndLoader );

            } /* endif */

            WinDestroyMsgQueue( hMsgQueue2 );      // Tidy up...

        } /* endif */

        WinTerminate( hAnchorBlock2 );     // Terminate the application

    } /* endif */

    _endthread();
}

