#pragma strings( readonly )

#include <string.h>
#include <stdlib.h>

#include "clerical.h"
#include "error.h"
#include "global.h"

// ===============================================================================================
BOOL HelpConstructor( PSZ pszFullExeFileName ) {
// ===============================================================================================

    BOOL     fReturn = FALSE;
    APIRET   rc;
    HELPINIT helpinit;
    CHAR     pszHelpBuffer[ MAX_RESOURCE_STRING_LENGTH ];
    ULONG    ulMaxPathLength = 0;
    PSZ      pszFullHelpFileName;


    hwndHelp = NULLHANDLE;

    rc = DosQuerySysInfo( QSV_MAX_PATH_LENGTH  // Ordinal of the first system variable
                        , QSV_MAX_PATH_LENGTH  // Ordinal of the last system variable
                        , &ulMaxPathLength     // Address of the data buffer
                        , sizeof( ULONG ));    // Length, in bytes, of the data buffer
                                               //   includes \0 character !

    if (( rc != NO_ERROR ) || ( ulMaxPathLength < ( 3 + 8 + 1 + 3 + 1 ))) { // c:\filename.dos

        // --- why me ----------------------------------------------------------------------------

        Error( "DosQuerySysInfo failed RC(%X)\nor\nmaximal Pathlength = %ld.\nHelp disabled."
             , rc
             , ulMaxPathLength );

    } else if (( pszFullHelpFileName = (PSZ)malloc( ulMaxPathLength * sizeof( CHAR ))) == NULL ) {

        // --- no virtual memory, that a real problem --------------------------------------------

        Error( "No memory !!\nHelp disabled." );

    } else if ( WinLoadString( hAnchorBlock                // Anchor-block handle
                             , hModuleLanguage             // Resource identity containing the string
                             , ID_STRING_HELP_FILE         // String identifier
                             , MAX_RESOURCE_STRING_LENGTH  // Size of buffer
                             , pszHelpBuffer ) == 0 ) {    // Buffer that is to receive the string

        // --- no helpfilename in resourcefile --------------------------------------------------

        Error( "No helpfile specified in resourcefile!\nHelp disabled." );

    } else if ( strcmp( pszHelpBuffer, NO_HELP_FILE )) {

        // --- build the full helpfilename -------------------------------------------------------

        strcpy( pszFullHelpFileName, pszFullExeFileName );
        strcpy( strrchr( pszFullHelpFileName, '\\' ) + 1, pszHelpBuffer );

        if ( WinLoadString( hAnchorBlock                 // Anchor-block handle
                          , hModuleLanguage              // Resource identity containing the string
                          , ID_STRING_HELP_TITLE         // String identifier
                          , MAX_RESOURCE_STRING_LENGTH   // Size of buffer
                          , pszHelpBuffer ) == 0 ) {     // Buffer that is to receive the string
            strcpy( pszHelpBuffer, DEFAULT_HELP_TITLE );
        } /* endif */

        // --- initialize help init structure ----------------------------------------------------

        helpinit.cb                       = sizeof( HELPINIT );
        helpinit.ulReturnCode             = 0L;
        helpinit.pszTutorialName          = NULL;
        helpinit.phtHelpTable             = (PHELPTABLE)( ID_HELP_TABLE | 0xFFFF0000 );
        helpinit.hmodHelpTableModule      = NULLHANDLE;
        helpinit.hmodAccelActionBarModule = NULLHANDLE;
        helpinit.idAccelTable             = 0;
        helpinit.idActionBar              = 0;
        helpinit.pszHelpWindowTitle       = pszHelpBuffer;
        helpinit.fShowPanelId             = CMIC_HIDE_PANEL_ID;
        helpinit.pszHelpLibraryName       = pszFullHelpFileName;

        // --- Creating help instance ------------------------------------------------------------

        hwndHelp = WinCreateHelpInstance( hAnchorBlock  // Anchorblock handle
                                        , &helpinit );  // Helpmanager initialization structure

        if (( hwndHelp == NULLHANDLE ) || helpinit.ulReturnCode ) {

            Error( "WinCreateHelpInstance (%s) failed. RC(%X)\nHelp disabled."
                 , helpinit.pszHelpLibraryName
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

        // --- Associate help instance with main frame -------------------------------------------

        } else if ( ! WinAssociateHelpInstance( hwndHelp        // Handle of an instance of the Helpmanager
                                              , hwndFrame )) {  // Handle of an Applicationwindow

            Error( "WinAssociateHelpInstance failed. RC(%X)\nHelp disabled."
                 , ERRORIDERROR( WinGetLastError( hAnchorBlock )));

        // --- all ok ----------------------------------------------------------------------------

        } else {

            fReturn = TRUE;

        } /* endif */

    } /* endif */

    // --- free the memory -----------------------------------------------------------------------

    if ( pszFullHelpFileName != NULL ) {
        free( pszFullHelpFileName );
    } /* endif */

    return fReturn;
}

// ===============================================================================================
VOID HelpMenuUpdate( VOID ) {
// ===============================================================================================

    if (( hwndHelp != NULLHANDLE ) && ( hwndMenu != NULLHANDLE )) {

        // --- enable all four menuentries -------------------------------------------------------

        WinSendMsg( hwndMenu
                  , MM_SETITEMATTR
                  , MPFROM2SHORT( ID_MENU_HELPINDEX, TRUE )
                  , MPFROM2SHORT( MIA_DISABLED, FALSE ));
        WinSendMsg( hwndMenu
                  , MM_SETITEMATTR
                  , MPFROM2SHORT( ID_MENU_HELPGENERAL, TRUE )
                  , MPFROM2SHORT( MIA_DISABLED, FALSE ));
        WinSendMsg( hwndMenu
                  , MM_SETITEMATTR
                  , MPFROM2SHORT( ID_MENU_HELPUSING, TRUE )
                  , MPFROM2SHORT( MIA_DISABLED, FALSE ));
        WinSendMsg( hwndMenu
                  , MM_SETITEMATTR
                  , MPFROM2SHORT( ID_MENU_HELPKEYS, TRUE )
                  , MPFROM2SHORT( MIA_DISABLED, FALSE ));

    } /* endif */
}

// ===============================================================================================
VOID HelpDestructor( VOID ) {
// ===============================================================================================

    if ( hwndHelp != NULLHANDLE ) {

        // --- cleanup ---------------------------------------------------------------------------

        WinAssociateHelpInstance( NULLHANDLE, hwndFrame );
        WinDestroyHelpInstance( hwndHelp );

    } /* endif */
}
