/*********** MAIN Include file (.H) **************************************************************
 *
 *
 *  Copyright (C) 1995
 *
 ************************************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include "resource.h"

/* --- general -------------------------------------------------------------------------------- */

#define ID_NOTEBOOK       2000L
#define ID_MLE            2001L
#define ID_BMP            2002L
#define ID_NOTEBOOKPAGE   8006L     // Sorry NO CONSTANT found in TOOLKIT 3.0 !!!!!!!!!!

#define ID_NO_RESOURCE       0L

#define OPEN_DEFAULT         0L     // Ugly, but easier .. INCL_WINWORKPLACE ???

#define TAB_WIDTH_MARGIN    10L     // pels
#define TAB_HEIGHT_MARGIN    5L     // pels

#define PICTURE_TEXT_BORDER 10L     // pels

#define BMP_RATIO_FULL   0.774       // 480pel/620pel     y/x
#define BMP_RATIO_PART   0.613       // 380pel/620pel

#define MIN_TEXT_LINES                 4L
#define MAX_RESOURCE_STRING_LENGTH   256L
#define MAX_TIME_TO_INIT           15000L                // 15s

#define PSZ_CLIENT_WC_NAME     "ClergymansClient"
#define PSZ_NOTEBOOK_FONT_NAME "10.Helv"
#define PSZ_MLE_FONT_NAME      "8.Courier"
#define PSZ_MENU_FONT_NAME     "10.Helv"

#define WC_PRIVATE_LOADER      "WC_PRIVATE_LOADER"
#define WC_PRIVATE_BMP         "WC_PRIVATE_BMP"

#define ID_TIMER_EYE_UPDATE   ( TID_USERMAX - 1 )
#define ID_TIMER_INIT_TIMEOUT ( TID_USERMAX - 2 )

#define WM_USER_INIT_PART_1    ( WM_USER + 1 )
#define WM_USER_INIT_PART_2    ( WM_USER + 2 )
#define WM_USER_INIT_PART_3    ( WM_USER + 3 )
#define WM_USER_INIT_LOADER    ( WM_USER + 4 )
#define WM_USER_SIZE_TUNE      ( WM_USER + 5 )
#define WM_USER_LOAD_BMP       ( WM_USER + 6 )
#define WM_USER_PAINT_PICTURE  ( WM_USER_LOAD_BMP + 1 )  // see loader.c WinPeekMsg
#define WM_USER_CHANGE_COLOR   ( WM_USER + 8 )
#define WM_USER_LOAD_DLL       ( WM_USER + 9 )

#define INI_FILENAME       "CLERICAL.INI"
#define HLP_FILENAME       "CLERICAL.HLP"
#define BMP_DLL_1          "CLERBMP1.DLL"
#define BMP_DLL_2          "CLERBMP2.DLL"
#define BMP_DLL_3          "CLERBMP3.DLL"
#define BMP_DLL_4          "CLERBMP4.DLL"
#define BMP_DLL_5          "CLERBMP5.DLL"

#define PSZ_VALIDATOR_EXE  "CLERICAL.EXE"
#define PSZ_VALIDATOR_LOG  "CLERICAL.LOG"

#define DEFAULT_MAIN_TITLE "Sorry, no maintitle found"
#define DEFAULT_HELP_TITLE "Sorry, no helptitle found"
#define DEFAULT_TEXT       "Sorry, no text found"

#define INI_KEY1_BMP       "Bitmap"
#define INI_KEY1_MLE       "Text"
#define INI_KEY1_PAGE      "Page"
#define INI_KEY1_BOOK      "Book"
#define INI_KEY1_MENU      "Menu"
#define INI_KEY1_FRAME     "Frame"

#define INI_KEY2_FORECOLOR "Forecolor"
#define INI_KEY2_BACKCOLOR "Backcolor"
#define INI_KEY2_FONT      "Font"
#define INI_KEY2_SIZE      "Size"
#define INI_KEY2_POS       "Position"

#define BIT_PP_BITMAP_FORECOLOR   0x00000001
#define BIT_PP_BITMAP_BACKCOLOR   0x00000002
#define BIT_PP_MLE_FORECOLOR      0x00000010
#define BIT_PP_MLE_BACKCOLOR      0x00000020
#define BIT_PP_MLE_FONT           0x00000040
#define BIT_PP_NOTEBOOK_FORECOLOR 0x00000100
#define BIT_PP_NOTEBOOK_BACKCOLOR 0x00000200
#define BIT_PP_NOTEBOOK_FONT      0x00000400
#define BIT_PP_MENU_FORECOLOR     0x00001000
#define BIT_PP_MENU_BACKCOLOR     0x00002000
#define BIT_PP_MENU_FONT          0x00004000
#define BIT_PP_INVALID            0xFFFF888C

MRESULT EXPENTRY wpNotebookClient( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY wpFrame( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY wpMenu( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY wpMLE( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY wpBMP( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY wpPage( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY wpLoader( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );

BOOL   SettingsInit( PSZ pszIniFilename, BOOL fReadonly );
VOID   SettingsExit( VOID );
VOID   SaveSettings( VOID );
VOID   LoadSettingsPresParam( VOID );
POINTL LoadSettingsPos( VOID );
SIZEL  LoadSettingsSize( VOID );
VOID   LoadDefaultColor( VOID );
VOID   LoadDefaultFont( VOID );

BOOL   PreconditionsMeet( HWND hwndFrame );

BOOL   HelpConstructor( PSZ pszHelpName );
VOID   HelpMenuUpdate( VOID );
VOID   HelpDestructor( VOID );

#endif

