#ifndef  BASE_NOTEBOOK_H
#define  BASE_NOTEBOOK_H

#include "clerical.h"

typedef struct _PAGEDATA {
    ULONG ulResIdPicture;         // Bitmapidentifier in resource                 clerbmp?.dll
    ULONG ulResIdText;            // Textidentifier in resource for text          exe or lang_xxx.dll
    ULONG ulResIdTabText;         // Textidentifier in resource to go on tab      exe or lang_xxx.dll
    ULONG ulCurrentDll;           // In which DLL you find the Bitmapidentifier   ? from clerbmp?.dll
    ULONG ulPreloadDll1;          // Which DLL to preload or free ( 2 - 5 )       # = load clerbmp#.dll
    ULONG ulPreloadDll2;          //                                              0 = free all other
} PAGEDATA;

typedef PAGEDATA *PPAGEDATA;

#define MAX_PAGES 55

#define BOOKSETUP { { ID_BMP_PICTURE_01, ID_NO_RESOURCE,    ID_STRING_TAB_01, 0     , 0, 0 } \
                  , { ID_BMP_PICTURE_02, ID_STRING_TEXT_02, ID_NO_RESOURCE  ,  1    , 0, 0 } \
                  , { ID_BMP_PICTURE_03, ID_NO_RESOURCE,    ID_NO_RESOURCE  ,  1    , 0, 0 } \
                  , { ID_BMP_CHAPTER_01, ID_NO_RESOURCE,    ID_STRING_TAB_02,  1    , 2, 0 } \
                  , { ID_BMP_PICTURE_04, ID_STRING_TEXT_04, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_05, ID_STRING_TEXT_05, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_06, ID_STRING_TEXT_06, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_07, ID_STRING_TEXT_07, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_08, ID_STRING_TEXT_08, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_09, ID_STRING_TEXT_09, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_10, ID_STRING_TEXT_10, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_11, ID_STRING_TEXT_11, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_12, ID_STRING_TEXT_12, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_13, ID_STRING_TEXT_13, ID_NO_RESOURCE  ,   2   , 2, 0 } \
                  , { ID_BMP_PICTURE_14, ID_STRING_TEXT_14, ID_NO_RESOURCE  ,   2   , 2, 3 } \
                  , { ID_BMP_PICTURE_15, ID_STRING_TEXT_15, ID_NO_RESOURCE  ,    3  , 2, 3 } \
                  , { ID_BMP_PICTURE_16, ID_STRING_TEXT_16, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_17, ID_STRING_TEXT_17, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_18, ID_STRING_TEXT_18, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_19, ID_STRING_TEXT_19, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_20, ID_STRING_TEXT_20, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_21, ID_STRING_TEXT_21, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_22, ID_STRING_TEXT_22, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_23, ID_STRING_TEXT_23, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_CHAPTER_02, ID_NO_RESOURCE,    ID_STRING_TAB_03,  1    , 0, 3 } \
                  , { ID_BMP_PICTURE_24, ID_STRING_TEXT_24, ID_NO_RESOURCE  ,    3  , 0, 3 } \
                  , { ID_BMP_PICTURE_25, ID_STRING_TEXT_25, ID_NO_RESOURCE  ,    3  , 4, 3 } \
                  , { ID_BMP_PICTURE_26, ID_STRING_TEXT_26, ID_NO_RESOURCE  ,     4 , 4, 3 } \
                  , { ID_BMP_PICTURE_27, ID_STRING_TEXT_27, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_28, ID_STRING_TEXT_28, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_29, ID_STRING_TEXT_29, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_CHAPTER_03, ID_NO_RESOURCE,    ID_STRING_TAB_04,  1    , 4, 0 } \
                  , { ID_BMP_PICTURE_30, ID_STRING_TEXT_30, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_31, ID_STRING_TEXT_31, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_32, ID_STRING_TEXT_32, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_33, ID_STRING_TEXT_33, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_34, ID_STRING_TEXT_34, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_35, ID_STRING_TEXT_35, ID_NO_RESOURCE  ,     4 , 4, 0 } \
                  , { ID_BMP_PICTURE_36, ID_STRING_TEXT_36, ID_NO_RESOURCE  ,     4 , 4, 5 } \
                  , { ID_BMP_PICTURE_37, ID_STRING_TEXT_37, ID_NO_RESOURCE  ,      5, 4, 5 } \
                  , { ID_BMP_PICTURE_38, ID_STRING_TEXT_38, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_39, ID_STRING_TEXT_39, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_40, ID_STRING_TEXT_40, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_41, ID_STRING_TEXT_41, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_42, ID_STRING_TEXT_42, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_43, ID_STRING_TEXT_43, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_44, ID_STRING_TEXT_44, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_CHAPTER_04, ID_NO_RESOURCE,    ID_STRING_TAB_05,  1    , 0, 5 } \
                  , { ID_BMP_PICTURE_45, ID_STRING_TEXT_45, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_46, ID_STRING_TEXT_46, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_47, ID_STRING_TEXT_47, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_CHAPTER_05, ID_NO_RESOURCE,    ID_STRING_TAB_06,  1    , 0, 5 } \
                  , { ID_NO_RESOURCE,    ID_STRING_TEXT_48, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_NO_RESOURCE,    ID_STRING_TEXT_49, ID_NO_RESOURCE  ,      5, 0, 5 } \
                  , { ID_BMP_PICTURE_99, ID_NO_RESOURCE,    ID_STRING_TAB_07,  1    , 0, 5 } \
                  }

// --- prototypes --------------------------------------------------------------------------------

BOOL BookConstructor( const ULONG ulMaxPages, const PPAGEDATA pPageData, const TID tidLoader );
BOOL BookAddPages( const ULONG ulMaxPages, const PPAGEDATA pPageData );
BOOL BookShow( VOID );
VOID BookDestructor( VOID );

#endif /* BASE_NOTEBOOK_H */
