#define INCL_WIN

#include <os2emx.h>

#include "pmkbd.h"

struct RAWSTRUCT {
   char keydn, scancode, ch1, ch2;
};

void handleKeyRaw(PCHRMSG msg) {
   struct RAWSTRUCT o;
   int k;

   o.keydn    = (msg->fs & KC_KEYUP) == 0;
   o.scancode = msg->scancode;

 if (msg->fs & KC_CHAR) {
    o.ch1 = msg->chr;
    o.ch2 = 0;
  }
  else if (msg->fs & KC_VIRTUALKEY) {
    static USHORT keytable[][5] = {
      /* VK-Keyword  normal- shifted- ctrl-  alt- Code */
      { VK_ESC,      0x001b, 0x001b, 0x001b, 0x001b },
      { VK_BACKTAB,  0x0f00, 0x0f00, 0x0f00, 0x0f00 },
      { VK_PAGEUP,   0x4900, 0x0039, 0x8400, 0x9900 },
      { VK_PAGEDOWN, 0x5100, 0x0033, 0x7600, 0xa100 },
      { VK_END,      0x4f00, 0x0031, 0x7500, 0x9f00 },
      { VK_HOME,     0x4700, 0x0037, 0x7700, 0x9700 },
      { VK_LEFT,     0x4b00, 0x0034, 0x7300, 0x9b00 },
      { VK_UP,       0x4800, 0x0038, 0x8D00, 0x9800 },
      { VK_RIGHT,    0x4d00, 0x0036, 0x7400, 0x9d00 },
      { VK_DOWN,     0x5000, 0x0032, 0x9100, 0xa000 },
      { VK_INSERT,   0x5200, 0x0030, 0x9200, 0xa200 },
      { VK_DELETE,   0x5300, 0x002e, 0x9300, 0xa300 },
      { VK_F1,       0x3b00, 0x5400, 0x5e00, 0x6800 },
      { VK_F2,       0x3c00, 0x5500, 0x5f00, 0x6900 },
      { VK_F3,       0x3d00, 0x5600, 0x6000, 0x6a00 },
      { VK_F4,       0x3e00, 0x5700, 0x6100, 0x6b00 },
      { VK_F5,       0x3f00, 0x5800, 0x6200, 0x6c00 },
      { VK_F6,       0x4000, 0x5900, 0x6300, 0x6d00 },
      { VK_F7,       0x4100, 0x5a00, 0x6400, 0x6e00 },
      { VK_F8,       0x4200, 0x5b00, 0x6500, 0x6f00 },
      { VK_F9,       0x4300, 0x5c00, 0x6600, 0x7000 },
      { VK_F10,      0x4400, 0x5d00, 0x6700, 0x7100 },
      { VK_F11,      0x8500, 0x8700, 0x8900, 0x8b00 },
      { VK_F12,      0x8600, 0x8800, 0x8a00, 0x8c00 },
      { 0,           0,      0,      0,      0      } };
    int i = 0;

    o.ch1 = 0;
    o.ch2 = 0;
    while (keytable[i][0] != 0) {
      if (keytable[i][0] == msg->vkey) {
        if (msg->fs & KC_ALT)
          k = keytable[i][4];
        else if (msg->fs & KC_CTRL)
          k = keytable[i][3];
        else if (msg->fs & KC_SHIFT)
          k = keytable[i][2];
        else
          k = keytable[i][1];
        o.ch1 = k & 0x00FF;
        o.ch2 = k >> 8;
        break;
      }
      i++;
    }
  }
  else if ((msg->fs & KC_CTRL) && (msg->chr != 0)) {
    o.ch1 = msg->chr & 0x1f;
    o.ch2 = 0;
  }
  else if ((msg->fs & KC_SCANCODE) &&
      (msg->fs & KC_ALT)) {
    o.ch1 = 0;
    o.ch2 = msg->scancode << 8;
  } else {
   o.ch1 = 0;
   o.ch2 = 0;
  }
  WriteRaw(o.keydn, o.scancode);
  WriteRaw(o.ch1, o.ch2);
}




MRESULT handleKey(BOOL raw, PCHRMSG msg) {
  if (raw) {
    handleKeyRaw(msg);
    return(0);  
  }

  if (msg->fs & KC_KEYUP)
    return(0);
  if (msg->fs & KC_CHAR) {
    WriteChar(msg->chr);
    return(0);
  }
  if (msg->fs & KC_VIRTUALKEY) {
    static USHORT keytable[][5] = {
      /* VK-Keyword  normal- shifted- ctrl-  alt- Code */
      { VK_ESC,      0x001b, 0x001b, 0x001b, 0x001b },
      { VK_BACKTAB,  0x0f00, 0x0f00, 0x0f00, 0x0f00 },
      { VK_PAGEUP,   0x4900, 0x0039, 0x8400, 0x9900 },
      { VK_PAGEDOWN, 0x5100, 0x0033, 0x7600, 0xa100 },
      { VK_END,      0x4f00, 0x0031, 0x7500, 0x9f00 },
      { VK_HOME,     0x4700, 0x0037, 0x7700, 0x9700 },
      { VK_LEFT,     0x4b00, 0x0034, 0x7300, 0x9b00 },
      { VK_UP,       0x4800, 0x0038, 0x8D00, 0x9800 },
      { VK_RIGHT,    0x4d00, 0x0036, 0x7400, 0x9d00 },
      { VK_DOWN,     0x5000, 0x0032, 0x9100, 0xa000 },
      { VK_INSERT,   0x5200, 0x0030, 0x9200, 0xa200 },
      { VK_DELETE,   0x5300, 0x002e, 0x9300, 0xa300 },
      { VK_F1,       0x3b00, 0x5400, 0x5e00, 0x6800 },
      { VK_F2,       0x3c00, 0x5500, 0x5f00, 0x6900 },
      { VK_F3,       0x3d00, 0x5600, 0x6000, 0x6a00 },
      { VK_F4,       0x3e00, 0x5700, 0x6100, 0x6b00 },
      { VK_F5,       0x3f00, 0x5800, 0x6200, 0x6c00 },
      { VK_F6,       0x4000, 0x5900, 0x6300, 0x6d00 },
      { VK_F7,       0x4100, 0x5a00, 0x6400, 0x6e00 },
      { VK_F8,       0x4200, 0x5b00, 0x6500, 0x6f00 },
      { VK_F9,       0x4300, 0x5c00, 0x6600, 0x7000 },
      { VK_F10,      0x4400, 0x5d00, 0x6700, 0x7100 },
      { VK_F11,      0x8500, 0x8700, 0x8900, 0x8b00 },
      { VK_F12,      0x8600, 0x8800, 0x8a00, 0x8c00 },
      { 0,           0,      0,      0,      0      } };
    int i = 0;

    while (keytable[i][0] != 0) {
      if (keytable[i][0] == msg->vkey) {
        if (msg->fs & KC_ALT)
          WriteChar(keytable[i][4]);
        else if (msg->fs & KC_CTRL)
          WriteChar(keytable[i][3]);
        else if (msg->fs & KC_SHIFT)
          WriteChar(keytable[i][2]);
        else
          WriteChar(keytable[i][1]);
        return(0);
      }
      i++;
    }
    return(0);
  }
  if ((msg->fs & KC_CTRL) && (msg->chr != 0)) {
    WriteChar(msg->chr & 0x1f);
    return(0);
  }
  if ((msg->fs & KC_SCANCODE) &&
      (msg->fs & KC_ALT)) {
    WriteRaw(0, msg->scancode << 8);
    return(0);
  }
  return(0);
}
