/* INSTALL.cmd - (c) Copyright 1996, Rhintek, Incorporated */

   '@echo off'

   /* get the system functions involved so that we can use them */
   call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
   call SysLoadFuncs

   /* open the readme file in e */
   'start "BEM Readme" /F e readme.1st'
   say 'Installing...'

   /* get the current directory */
   thepath = SysSearchPath( PATH, "BEMbook.ico" )
   lastslash = lastpos( '\', thepath)
   thepath = substr( thepath, 1, lastslash )

   /* make the folder for the BEM directory on the desktop */
   icons = 'ICONFILE=' || thepath || 'BEMFLDR.ICO;ICONNFILE=1,' || thepath || 'BEMFLDRo.ICO'
   background = 'BACKGROUND=' || thepath || 'tile2blu.bmp,T,1,I;'
   setupstring = 'OBJECTID=<BEMFLDR>;' || background || icons
   rc = SysCreateObject( WPFolder, "BEM Alpha", "<WP_DESKTOP>", setupstring )
   if rc = 0
      then say "error in creating folder on the desktop"

   /* add the shadow of the general readme (so its first in the folder) */
   setupstring = 'SHADOWID=' || thepath || 'readme.1st;'
   rc = SysCreateObject( WPShadow, " ", "<BEMFLDR>", setupstring )
   if rc = 0
      then say "error in creating shadow of General Readme"

   /* add the shadow of the beta application */
   setupstring = 'SHADOWID=' || thepath || 'betaapp.txt;'
   rc = SysCreateObject( WPShadow, " ", "<BEMFLDR>", setupstring )
   if rc = 0
      then say "error in creating shadow of Beta application"

   /* make the program object for the config.exe */
   execstring = 'EXENAME=' || thepath || 'config.exe;'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'bconfig.ICO;'
   setupstring = 'OBJECTID=<BEMCFG>;' || icons || execstring || startstring
   rc = SysCreateObject( WPProgram, "BEM Config", "<BEMFLDR>", setupstring )
   if rc = 0
      then say "error in creating Config object"

   /* make the program object for single-player BEM */
   execstring = 'EXENAME=' || thepath || 'single.cmd;'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'single.ICO;'
   setupstring = 'OBJECTID=<BEMSNGL>;MINIMIZED=YES;' || icons || execstring || startstring
   rc = SysCreateObject( WPProgram, "Single-Player", "<BEMFLDR>", setupstring )
   if rc = 0
      then say "error in creating Single-Player"

   /* make a program object that points to the inf */
   execstring = 'EXENAME=view.exe;'
   paramstring = 'PARAMETERS=bemhelp.inf;'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'bembook.ICO;'
   setupstring = 'OBJECTID=<BEMHELP>;' || icons || execstring || paramstring || startstring
   rc = SysCreateObject( WPProgram, "BEM Help", "<BEMFLDR>", setupstring )
   if rc = 0
      then say "error in creating BEM Book"        

   /* make the folder for the Client in the BEM Alpha folder */
   icons = 'ICONFILE=' || thepath || 'BEMFLDR.ICO;ICONNFILE=1,' || thepath || 'BEMFLDRo.ICO'
   background = 'BACKGROUND=' || thepath || 'tile2grn.bmp,T,1,I;'
   setupstring = 'OBJECTID=<BEMCLNT>;' || background || icons
   rc = SysCreateObject( WPFolder, "Client", "<BEMFLDR>", setupstring )
   if rc = 0
      then say "error in creating client folder in BEM Alpha"

   /* add the readme first so that is is the object to the left */
   setupstring = 'SHADOWID=' || thepath || 'readme.clt;'
   rc = SysCreateObject( WPShadow, " ", "<BEMCLNT>", setupstring )
   if rc = 0
      then say "error in creating shadow of Client Readme"

   /* add the Direct-Connect client */
   execstring = 'EXENAME=' || thepath || 'rhino.exe;'
   paramstring = 'PARAMETERS=clntdir.rcf "/T=Direct-Connect Client";'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'single.ICO;'
   setupstring = 'OBJECTID=<BEMCDIR>;' || icons || execstring || paramstring || startstring
   rc = SysCreateObject( WPProgram, "Direct-Connect", "<BEMCLNT>", setupstring )
   if rc = 0
      then say "error in creating Client Direct-Connect"

   /* add the COM client */
   execstring = 'EXENAME=' || thepath || 'rhino.exe;'
   paramstring = 'PARAMETERS=clntcom.rcf "/T=COM Client";'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'single.ICO;'
   setupstring = 'OBJECTID=<BEMCCOM>;' || icons || execstring || paramstring || startstring
   rc = SysCreateObject( WPProgram, "COM", "<BEMCLNT>", setupstring )
   if rc = 0
      then say "error in creating Client COM"

   /* add the Client Internet/TCPIP connection object */
   execstring = 'EXENAME=' || thepath || 'rhino.exe;'
   paramstring = 'PARAMETERS=client.rcf "/T=Internet/TCPIP";'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'single.ICO;'
   setupstring = 'OBJECTID=<BEMCTCPIP>;' || icons || execstring || paramstring || startstring
   rc = SysCreateObject( WPProgram, "Internet/TCPIP", "<BEMCLNT>", setupstring )
   if rc = 0
      then say "error in creating Internet/TCPIP Client"

   /* make the folder for Server in the BEM Alpha folder */
   icons = 'ICONFILE=' || thepath || 'BEMFLDR.ICO;ICONNFILE=1,' || thepath || 'BEMFLDRo.ICO'
   background = 'BACKGROUND=' || thepath || 'tile2red.bmp,T,1,I;' 
   setupstring = 'OBJECTID=<BEMSRVR>;' || background || icons
   rc = SysCreateObject( WPFolder, "Server", "<BEMFLDR>", setupstring )
   if rc = 0
      then say "error in creating server folder in BEM Alpha"

   /* add the readme first so that it is the leftmost item */
   setupstring = 'SHADOWID=' || thepath || 'readme.svr;'
   rc = SysCreateObject( WPShadow, " ", "<BEMSRVR>", setupstring )
   if rc = 0
      then say "error in creating shadow of Server Readme"

   /* add the overseer to the Server Folder (since it has to run first, put it here) */
   execstring = 'EXENAME=' || thepath || 'oseer.exe;'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'overseer.ICO;'
   setupstring = 'OBJECTID=<BEMOSEER>;' || icons || execstring || startstring
   rc = SysCreateObject( WPProgram, "Overseer", "<BEMSRVR>", setupstring )
   if rc = 0
      then say "error in creating overseer"

   /* make the program object for local player BEM */
   execstring = 'EXENAME=' || thepath || 'pld.exe;'
   paramstring = 'PARAMETERS=/c=oseer;'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'single.ICO;'
   setupstring = 'OBJECTID=<BEMLCPL>;' || icons || execstring || startstring
   rc = SysCreateObject( WPProgram, "Local-Player", "<BEMSRVR>", setupstring )
   if rc = 0
      then say "error in creating Local-Player"

   /* add the Direct-Connect server */
   execstring = 'EXENAME=' || thepath || 'rhino.exe;'
   paramstring = 'PARAMETERS=srvrdir.rcf "/T=Direct-Connect Server";'
   startstring = 'STARTUPDIR=' || thepath
   icons = 'ICONFILE=' || thepath || 'bserver.ICO;'
   setupstring = 'OBJECTID=<BEMSDIR>;' || icons || execstring || paramstring || startstring
   rc = SysCreateObject( WPProgram, "Direct-Connect", "<BEMSRVR>", setupstring )
   if rc = 0
      then say "error in creating Server Direct-Connect"

   /* put the COM server in -- we expect this to be the most common connection */
   execstring = 'EXENAME=' || thepath || 'rhino.exe;'
   paramstring = 'PARAMETERS=srvrcom.rcf "/T=COM Server";'
   icons = 'ICONFILE=' || thepath || 'bserver.ICO;'
   setupstring = 'OBJECTID=<BEMSCOM>;' || icons || execstring || paramstring || startstring
   rc = SysCreateObject( WPProgram, "COM", "<BEMSRVR>", setupstring )
   if rc = 0
      then say "error in creating Server COM"

   /* add the port BEMs to their folders */
   do i=5000 to 5005 by 1
      execstring = 'EXENAME=' || thepath || 'rhino.exe;'
      startstring = 'STARTUPDIR=' || thepath
      paramstring = 'PARAMETERS=srvr' || i || '.rcf "/T=Port' i || '";'
      icons = 'ICONFILE=' || thepath || 'bserver.ICO;'
      setupstring = 'OBJECTID=<BEMS' || i || '>;' || icons || execstring || paramstring || startstring
      playnum = i - 4999
      titlestring = 'Player #' || playnum '(' || i || ')'
      rc = SysCreateObject( WPProgram, titlestring , "<BEMSRVR>", setupstring )
      if rc = 0
         then say "error in creating Server" i
   end
   say 'Install Complete, read the readme.1st file and have fun, Soldier!'

endit:
   

/* pause
 'kill e' */
