/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         aboutMenuItem_Click
*/
aboutMenuItem_Click:
    call window2 VRWindow()
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0
/*:VRX         game_button
*/
game_button:

    row = arg( 1 )
    col = arg( 2 )

    if( row < current_row ) then do
        tmp_color = VRGet( 'r' || row || 'c' || col, 'backcolor' )
        call VRSet 'r' || current_row || 'c' || col, 'backcolor', tmp_color
      end
    else do
        call VRSet 'r' || row || 'c' || col, 'backcolor', color.current
      end

    /* Turn on the current column */
    button.col = 1
    guess_on = 1
    do i = 1 to 4 by 1
        if( button.i = 0 ) then guess_on = 0
    end
    if( guess_on = 1 ) then call VRSet 'pb_guess', 'enabled', 'true'

return
/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    color.1 = 'BLUE'
    color.2 = 'RED'
    color.3 = 'GREEN'
    color.4 = 'PINK'
    color.5 = 'CYAN'
    color.6 = 'YELLOW'
    color.current = color.1

    current_row = 1

    call VRSet "pb_current_color", "BackColor", color.current
    call newMenuItem_Click

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         newMenuItem_Click
*/
newMenuItem_Click:
    /*
     * Reset the game board.
     */
    call VRSet 'pb_peek', 'enabled', 'false'
    call VRSet 'pb_guess', 'enabled', 'false'
    call VRSet 'pb_new', 'enabled', 'false'

    do x = current_row to 2 by -1
        call VRSet 'dt' || x, 'caption', ''
        do y = 4 to 1 by -1
            call VRSet 'r' || x || 'c' || y, 'visible', 'false'
            call VRSet 'r' || x || 'c' || y, 'backcolor', '<default>'
        end
    end


    do y = 1 to 4 by 1
        call VRSet 'r1c' || y, 'backcolor', '<default>'
        call VRSet 'r0c' || y, 'backcolor', '<default>'
        button.y = 0
    end

    /* Set current row */
    current_row = 1

    /* Set the game solution */
    do i = 1 to 4 by 1
        j = RANDOM( 1, 6 )
        sol.i = color.j
    end

    /* Make the pointer */
    arrow = "<==="
    call VRSet 'dt1', 'caption', arrow

/*    call VRSet 'pb_guess', 'enabled', 'true' */
    call VRSet 'pb_peek', 'enabled', 'true'
    call VRSet 'pb_new', 'enabled', 'true'

return

/*:VRX         pb_color1_Click
*/
pb_color1_Click:
    color.current = color.1
    call VRSet 'pb_current_color', 'backcolor', color.current
return
/*:VRX         pb_color2_Click
*/
pb_color2_Click:
    color.current = color.2
    call VRSet 'pb_current_color', 'backcolor', color.current
return
/*:VRX         pb_color3_Click
*/
pb_color3_Click:
    color.current = color.3
    call VRSet 'pb_current_color', 'backcolor', color.current
return
/*:VRX         pb_color4_Click
*/
pb_color4_Click:
    color.current = color.4
    call VRSet 'pb_current_color', 'backcolor', color.current
return
/*:VRX         pb_color5_Click
*/
pb_color5_Click:
    color.current = color.5
    call VRSet 'pb_current_color', 'backcolor', color.current
return
/*:VRX         pb_color6_Click
*/
pb_color6_Click:
    color.current = color.6
    call VRSet 'pb_current_color', 'backcolor', color.current
return
/*:VRX         pb_guess_Click
*/
pb_guess_Click:

    correct = 0
    almost_correct = 0

    call VRSet 'pb_guess', 'enabled', 'false'

    /* Reintialize the sol_count and guess_count arrays */
    do i = 1 to 6 by 1
        sol_count.i = 0
        guess_count.i = 0
    end

    /* Find the number of correct matches */
    do i = 1 to 4 by 1
        button.i = 0
        guess = VRGet( 'r' || current_row || 'c' || i, 'backcolor' )
        guess = Translate( guess )
        if( guess = sol.i )then correct = correct + 1
        do j = 1 to 6 by 1
            if( guess = color.j ) then guess_count.j = guess_count.j + 1
            if( sol.i = color.j ) then sol_count.j = sol_count.j + 1
        end
    end

    /* Find number of almost correct guesses */
    do i = 1 to 6 by 1
        if( guess_count.i < sol_count.i ) then
            almost_correct = almost_correct + guess_count.i
        else
            almost_correct = almost_correct + sol_count.i
    end
    almost_correct = almost_correct - correct

    /* Make answer guess string */
    guess_string = ""
    if( correct > 0 ) then
        do i = 1 to correct by 1
            guess_string = guess_string || "X"
        end
    if( almost_correct > 0 ) then
        do i = 1 to almost_correct by 1
            guess_string = guess_string || "O"
        end
    call VRSet 'dt' || current_row, 'caption', guess_string

    /* Update current row */
    current_row = current_row + 1

    /* Check for a winner */
    if( guess_string = "XXXX" ) then do
        call Show_solution
        call VRMessage VRWindow(), 'Congratulations! You guessed the right combination in' current_row - 1 'turns.', 'YOU WIN!', 'information'
      end

    /* Check for end of game */
    else if( current_row > 10 ) then do
        call Show_solution
        call VRMessage VRWindow(), 'Sorry, but you have run out of turns.', 'You Lose.', 'information'
      end

    /* Continue game with a new guess */
    else do
        do i = 1 to 4
            call VRSet 'r' || current_row || 'c' || i, 'visible', 'true'
        end
        call VRSet 'dt' || current_row, 'caption', arrow
      end

return
/*:VRX         peekMenuItem_Click
*/
peekMenuItem_Click:
    call Show_solution
    call VRMessage VRWindow(), 'Sorry, the game cannot continue since you peeked at the solution.',,
                    'You Peeked!', 'Information'
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return
/*:VRX         r10c1_Click
*/
r10c1_Click:
    call game_button 10, 1
return
/*:VRX         r10c2_Click
*/
r10c2_Click:
    call game_button 10, 2
return
/*:VRX         r10c3_Click
*/
r10c3_Click:
    call game_button 10, 3
return
/*:VRX         r10c4_Click
*/
r10c4_Click:
    call game_button 10, 4
return
/*:VRX         r1c1_Click
*/
r1c1_Click:
    call game_button 1, 1
return
/*:VRX         r1c2_Click
*/
r1c2_Click:
    call game_button 1, 2
return
/*:VRX         r1c3_Click
*/
r1c3_Click:
    call game_button 1, 3
return
/*:VRX         r1c4_Click
*/
r1c4_Click:
    call game_button 1, 4
return
/*:VRX         r2c1_Click
*/
r2c1_Click:
    call game_button 2, 1
return
/*:VRX         r2c2_Click
*/
r2c2_Click:
    call game_button 2, 2
return
/*:VRX         r2c3_Click
*/
r2c3_Click:
    call game_button 2, 3
return
/*:VRX         r2c4_Click
*/
r2c4_Click:
    call game_button 2, 4
return
/*:VRX         r3c1_Click
*/
r3c1_Click:
    call game_button 3, 1
return
/*:VRX         r3c2_Click
*/
r3c2_Click:
    call game_button 3, 2
return
/*:VRX         r3c3_Click
*/
r3c3_Click:
    call game_button 3, 3
return
/*:VRX         r3c4_Click
*/
r3c4_Click:
    call game_button 3, 4
return
/*:VRX         r4c1_Click
*/
r4c1_Click:
    call game_button 4, 1
return
/*:VRX         r4c2_Click
*/
r4c2_Click:
    call game_button 4, 2
return
/*:VRX         r4c3_Click
*/
r4c3_Click:
    call game_button 4, 3
return
/*:VRX         r4c4_Click
*/
r4c4_Click:
    call game_button 4, 4
return
/*:VRX         r5c1_Click
*/
r5c1_Click:
    call game_button 5, 1
return
/*:VRX         r5c2_Click
*/
r5c2_Click:
    call game_button 5, 2
return
/*:VRX         r5c3_Click
*/
r5c3_Click:
    call game_button 5, 3
return
/*:VRX         r5c4_Click
*/
r5c4_Click:
    call game_button 5, 4
return
/*:VRX         r6c1_Click
*/
r6c1_Click:
    call game_button 6, 1
return
/*:VRX         r6c2_Click
*/
r6c2_Click:
    call game_button 6, 2
return
/*:VRX         r6c3_Click
*/
r6c3_Click:
    call game_button 6, 3
return
/*:VRX         r6c4_Click
*/
r6c4_Click:
    call game_button 6, 4
return
/*:VRX         r7c1_Click
*/
r7c1_Click:
    call game_button 7, 1
return
/*:VRX         r7c2_Click
*/
r7c2_Click:
    call game_button 7, 2
return
/*:VRX         r7c3_Click
*/
r7c3_Click:
    call game_button 7, 3
return
/*:VRX         r7c4_Click
*/
r7c4_Click:
    call game_button 7, 4
return
/*:VRX         r8c1_Click
*/
r8c1_Click:
    call game_button 8, 1
return
/*:VRX         r8c2_Click
*/
r8c2_Click:
    call game_button 8, 2
return
/*:VRX         r8c3_Click
*/
r8c3_Click:
    call game_button 8, 3
return
/*:VRX         r8c4_Click
*/
r8c4_Click:
    call game_button 8, 4
return
/*:VRX         r9c1_Click
*/
r9c1_Click:
    call game_button 9, 1
return
/*:VRX         r9c2_Click
*/
r9c2_Click:
    call game_button 9, 2
return
/*:VRX         r9c3_Click
*/
r9c3_Click:
    call game_button 9, 3
return
/*:VRX         r9c4_Click
*/
r9c4_Click:
    call game_button 9, 4
return
/*:VRX         Show_solution
*/
Show_solution:
    call VRSet 'pb_guess', 'Enabled', '0'
    call VRSet 'pb_peek', 'Enabled', '0'
    do i = 1 to 4 by 1
        call VRSet 'r0c' || i, 'Backcolor', sol.i
    end
return
/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return
