@echo off
rem ===========================================================================
rem  Apply CA-REALIZER OS2 2.0B USA Update Patch to the prior 2.0 or 2.0A version
rem ===========================================================================
rem
rem      1.  ***  IMPORTANT  ***
rem
rem                 Manually backup your existing CA-Realizer 2.0 or 2.0A directory and the two CA-Realizer files 
rem                 normally installed in your OS2 directory. ( \DLL\CABLE.DLL, \DLL\CA_PRINT.DLL 
rem                        and \RLZRUN20\RLZRUN20.RTS)
rem
rem                 This batch file requires CABLE.DLL and \RLZRUN20\RLZRUN20.RTS be in the     
rem                 OS2 directory where they were originally installed.    
rem
rem			   The existing read.me file will be updated, if you want to preserve its contents you 
rem			    should back it up first.
rem
rem      2  To execute this batch file, on an OS2 DOS command line do the following:
rem            -First change the drive/directory to that of the CA-REALIZER update files. 
rem                             ( ex.  a:  or  CD\RLZUpdate)
rem            -Type RLZPATCH.BAT Realizer Directory  Patch Directory  OS2 Directory
rem                  ex. RLZPATCH.BAT  d:\REALIZER  a:  c:\OS2 
rem             notes-      
rem                Realizer Directory
rem                      Specify both drive letter and directory name of the
rem                      CA-Realizer 2.0 or 2.0A directory to be updated.
rem                Patch Directory
rem                      Specify both drive letter and directory of the patch files.(ie. d:\directory-name)
rem                OS2 Directory
rem                      Specify both drive letter and directory name of your OS2 operating system.
rem      3. Copies two CA-Realizer files which are automatically installed in your OS2 directory to 
rem                  your CA-Realizer directory.
rem             - Copies the following 2 files  Cable.dll       Rlzrun20.rts
rem             - If you have changed the location of these files then this batch file will fail.
rem      4. Applys the update patch file to your main CA-Realizer 2.0 or 2.0A directory or a copy of it.
rem      5. Copies the following patched files back to your OS2 directory to complete the update.
rem                     Cable.dll       Rlzrun20.rts
rem      6. If CA-Caret was installed, updates the CA-Caret files.
rem        7. Lists the totals from the patch process.  
rem      8. If you chose to work with a copy of your CA-Realizer directory, then manually update your 
rem             group item to point to the new directory, or execute CA-Realizer from an OS2 command line
rem             by entering realizer.exe. 
rem        9. If necessary, move the CABLE.DLL and RLZRUN20.RTS files back to where you originally had them.
rem

if  exist %1\realizer.exe goto Exit1
	echo Missing or wrong path entered for CA-Realizer directory
	echo syntax RLZPATCH.BAT CA-Realizer-Directory Patch-Directory OS2-Directory
	echo %1
	goto end
:Exit1
SET RLZUpdateDirectory=%1
if  exist %2\patch.exe goto Exit2
	echo Missing or wrong path entered for the update patch file
	echo syntax RLZPATCH.BAT CA-Realizer-Directory Patch-Directory OS2-Directory
	echo %2
	goto end
:Exit2
SET RLZPatchDirectory=%2

if  exist %3\dll\pmgpi.dll  goto Exit3
	echo Missing or wrong path entered for the OS2 directory
	echo syntax RLZPATCH.BAT CA-Realizer-Directory Patch-Directory OS2-Directory
	echo %3
	goto end
:Exit3
SET RLZOS2Directory=%3

if  exist %3\dll\cable.dll goto Exit4
	echo Cable.dll must reside in the \OS2\DLL\ directory
	goto end
:Exit4        
if  exist %3\rlzrun20\rlzrun20.rts goto Exit5
	echo \Rlzrun20\Rlzrun20.rts must reside in the \OS2 directory
	goto end
:Exit5
if  not exist %2\patchapm.txt goto Exit6
	erase %2\patchapm.txt
:Exit6
copy %RLZOS2Directory%\RLZRUN20\RLZRUN20.RTS   %RLZUpdateDirectory%
echo copied %RLZOS2Directory%\RLZRUN20\RLZRUN20.RTS   %RLZUpdateDirectory%

copy %RLZOS2Directory%\dll\CABLE.DLL  %RLZUpdateDirectory%
echo Copied %RLZOS2Directory%\CABLE.DLL  %RLZUpdateDirectory%

ECHO %RLZPatchDirectory%\patch.exe /NOPATHSEARCH  /s %RLZUpdateDirectory%  %RLZPatchDirectory%\Patchm.rtp
%RLZPatchDirectory%\patch.exe /NOPATHSEARCH  /s %RLZUpdateDirectory%  %RLZPatchDirectory%\PatchM.rtp  >%RLZPatchDirectory%\patchapM.txt

copy %RLZUpdateDirectory%\RLZRUN20.RTS   %RLZOS2Directory%\RLZRUN20
echo Copied  %RLZUpdateDirectory%\RLZRUN20.RTS   TO  %RLZOS2Directory%\RLZRUN20
copy %RLZUpdateDirectory%\CABLE.DLL  %RLZOS2Directory%\dll
echo Copied %RLZUpdateDirectory%\CABLE.DLL  TO  %RLZOS2Directory%\dll

echo -
if  not exist %RLZUpdateDirectory%\readme.txt goto DoCAReadme
        rename %RLZUpdateDirectory%\readme.txt readme.20x
:DoCAReadme
	copy %RLZPatchDirectory%\readme.txt %RLZUpdateDirectory%
	echo copied %RLZPatchDirectory%\readme.txt %RLZUpdateDirectory%
echo -
echo After pressing Enter the update output logs will be displayed.
echo Please check the totals listed with those in the read.me file.
echo These totals can also be found in the patch directory in patchapm.txt.

pause
call %RLZPatchDirectory%\List1.bat
echo -----------------------------------------------------------------
echo CA-Realizer Update to 2.0B is done.
echo -----------------------------------------------------------------
:End
rem  Remove variables
SET RLZUpdateDirectory=
SET RLZPatchDirectory=
SET RLZOS2Directory=
