/*---------------------------------------------------------------------*/
/*  BA2DESK.CMD - Written by Box Turtle Software                       */
/*  Copyright (C) 1995 by Computer Data Strategies, Inc.               */
/*  Copyright (C) 1994, 1995 by Box Turtle Software                    */
/*  All Rights Reserved                                                */
/*                                                                     */
/*  Recreates the BA/2 desktop objects.                                */
/*                                                                     */
/*  Date        Programmer  Change                                     */
/*  ---------   ----------  ------                                     */
/*  05-08-94    BCB         Initial version                            */
/*  09-10-94    BCB         Confirm path with user before proceeding   */
/*  11-20-94    BCB         Set object ID for backup set shadows       */
/*  03-05-95    BCB         Update for Pro v3.0                        */
/*                                                                     */
/*---------------------------------------------------------------------*/

/* Load all REXX system extensions */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Say hello to the user */
echo off
say ' '
say 'BA2DESK.CMD - Rebuilds Back Again/2 Professional Edition desktop objects'
say ' '

/* Look up installation drive/path */
res = SysIni('USER', 'BackAgain_V3', 'InstPath')
if(res = 'ERROR:') then
  do
    BA2Path = ''
    AskForPath = 'Y'
  end
else
  do
    /* If the last char is a '\', get rid of it */
    if(substr(res, LENGTH(res), 1) = '\') then
      BA2Path = substr(res, 1, LENGTH(res)-1)
    else
      BA2Path = res
    AskForPath = 'N'
  end

/* Show this to the user if found */
if(LENGTH(BA2Path) > 0) then
  do
    say 'Current Back Again/2 Professional Edition path is '||BA2Path
    say 'Do you want to change it (Y/N)?'
    AskForPath = translate(SysGetKey("NOECHO"))
  end

/* If path not found, prompt for it */
if(AskForPath = 'Y') then
  do
    say 'Please enter the location of Back Again/2 Professional (default = C:\BA2PRO)'
    pull BA2Path
    if(LENGTH(BA2Path) = 0) then
      BA2Path = 'C:\BA2PRO'
  end

/* Strip trailing spaces, etc */
BA2Path = Strip(BA2Path)

/* Update the .INI value */
SysIni('USER', 'BackAgain_V3', 'InstPath', BA2Path)

/* Create the main folder */
say "Creating main folder..."
res = SysCreateObject("WPFolder", "Back Again/2^Professional Edition", "<WP_DESKTOP>", "OBJECTID=<BA2Folder_V3>", "REPLACE")
if(res = 0) then
   say "Couldn't create main folder"

/* Create the backup sets folder */
say "Creating backup sets folder..."
res = SysCreateObject("WPFolder", "Backup Sets", "<BA2Folder_V3>", "OBJECTID=<BA2Sets_V3>", "REPLACE")
if(res = 0) then
  say "Couldn't create backup sets folder"

/* Create the backup program object */
say "Creating program object..."
ObjectSetupStr = "EXENAME="||BA2Path||"\BACKUP.EXE;"
ObjectSetupStr = ObjectSetupStr||"OBJECTID=<BA2Exec_V3>;"
ObjectSetupStr = ObjectSetupStr||"STARTUPDIR="||BA2Path||";"
ObjectSetupStr = ObjectSetupStr||"ASSOCFILTER=*.SET;PROGTYPE=PM"
res = SysCreateObject("WPProgram", "Back Again/2^Professional Edition", "<BA2Folder_V3>", ObjectSetupStr, "REPLACE")
if(res = 0) then
  say "Couldn't create program reference object"

/* Create the MAKESR program object */
say "Creating program object..."
ObjectSetupStr = "EXENAME="BA2Path"\MAKESR.EXE;"
ObjectSetupStr = ObjectSetupStr||"STARTUPDIR="||BA2Path||";"
ObjectSetupStr = ObjectSetupStr||"PROGTYPE=PM"
res = SysCreateObject("WPProgram", "Update OS/2 Warp^Utility Diskettes", "<BA2Folder_V3>", ObjectSetupStr, "REPLACE")
if(res = 0) then
  say "Couldn't create program reference object"

/* Create the user's guide object */
say "Creating user's guide object..."
ObjectSetupStr = "EXENAME=VIEW.EXE;STARTUPDIR="||BA2Path||";PARAMETERS=BA2.INF;PROGTYPE=PM"
res = SysCreateObject("WPProgram", "Back Again/2^User's Guide", "<BA2Folder_V3>", ObjectSetupStr, "REPLACE")
if(res = 0) then
  say "Couldn't create user's guide object"

/* Create the readme file object */
say "Creating READ.ME object..."
ObjectSetupStr = "EXENAME=E.EXE;STARTUPDIR="||BA2Path||";PARAMETERS=READ.ME;PROGTYPE=PM"
res = SysCreateObject("WPProgram", "Back Again/2^READ.ME", "<BA2Folder_V3>", ObjectSetupStr, "REPLACE")
if(res = 0) then
  say "Couldn't create read.me file object"

/* Register the BA2Device WPS class & create a template */
res = SysRegisterObjectClass("BA2Device", "BA2DEV")
if (res = 0) then
  say "Couldn't register BA2Device WPS class"
res = SysCreateObject("BA2Device", "Back Again/2^Backup Device", "<BA2Folder_V3>", "TEMPLATE=YES", "REPLACE")
if(res = 0) then
  say "Couldn't create BA2Device template"

/* Create a shadow for each set in the backup sets folder */
FileMask = BA2Path||'\*.SET'
res = SysFileTree(FileMask, FileList, 'FO')
if(res = 0) then
  if(FileList.0 > 0) then
    do
      /* Say what we're doing */
      say "Creating backup set shadows in backup set folder..."

      /* Do it  */
      do idx = 1 to FileList.0
        say " - "||FileList.idx
        ObjectSetupStr = "OBJECTID=<ShadowOf_"||FileList.idx||">;SHADOWID="||FileList.idx
        res = SysCreateObject("WPShadow", FileList.idx, "<BA2Sets>", ObjectSetupStr, "REPLACE")
        if(res = 0) then
          say "   - Couldn't create shadow!"
      end
    end

/* We're done! */
say 'Done.'
