@ECHO OFF
CLS
ECHO.
ECHO *********************************************************************
ECHO * NEWOS2P.BAT - Updates to latest versions of OS/2 Peer Files       *
ECHO *                                                                   *
ECHO * This batch file creates a new version of LANTASTI.iFS that        *
ECHO * fix the problems listed in OS2P10.TXT.                            *
ECHO *                                                                  *
ECHO * This batch file should be in the directory where you installed    *
ECHO * the network (normally C:\LANTASTI\OS2).                           *
ECHO * Your present copy of LANTASTI.IFS will be backed up to a file     *
ECHO * named LANTASTI.BAK                                                *
ECHO *                                                                   *
ECHO * Press CTRL-C now to abort running this patch.                     *
ECHO *********************************************************************
ECHO.
PAUSE

IF NOT EXIST LANTASTI.IFS GOTO ERR1IFS

IF EXIST LANTASTI.BAK GOTO ERR2IFS

:INSTALLIFS
ECHO.
ECHO Copying old LANTASTI.IFS to LANTASTI.BAK ..
COPY LANTASTI.IFS LANTASTI.BAK
ECHO.

ECHO Installing new redirector ...
NEWIFS INFILE=LANTASTI.IFS OUTFILE=_IFS_.IFS
IF ERRORLEVEL 1 GOTO ERR3IFS

COPY _IFS_.IFS LANTASTI.IFS
DEL _IFS_.IFS
GOTO DONEIFS

:ERR1IFS
ECHO.
ECHO                      * ERROR *
ECHO.
ECHO LANTASTI.IFS not found in this directory - please copy this batch file
ECHO to the directory where LANTASTI.IFS resides and run NEWOS2P again.
ECHO.
GOTO EXIT

:ERR2IFS
ECHO.
ECHO                     * WARNING *
ECHO.
ECHO LANTASTI.BAK already exists! it will be overwritten.
ECHO Press CTRL-C to abort
ECHO.
PAUSE
GOTO INSTALLIFS

:ERR3IFS
ECHO 
ECHO                      * ERROR *
ECHO 
ECHO Operation unsuccessful. Repeat NEWOS2P in a directory containing only
ECHO the original LANTASTI.IFS.
GOTO EXIT

:ERR4IFS
ECHO 
ECHO                      * ERROR *
ECHO 
ECHO NEWIFS.EXE not found in this directory - please copy this file
ECHO to the directory where LANTASTI.IFS resides and run NEWOS2P again.
GOTO EXIT

:DONEIFS
ECHO       * OS/2 Redirector successfully patched *

:EXIT
