/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
//
// mblen() returns a length of 0 for '\0'.  But in many cases we
// want '\0' to have a length of 1.  In those cases, call this
// function.
//

inline int memmblen(const char* s, int len)
{
  return *s ? mblen(s, len) : 1;
}

class Attr3270 {
public:
  enum Intensity { sameIntensity = -1, normal, dark, bright };
  enum Protection { sameProtection = -1, unprot, prot, autoskip };
  enum Hilite { sameHilite = -1, noHilite, blink, reverse, underscore };
  enum Color { sameColor = -1, mono,
               blue, red, green, pink, turq, yellow, white };
  enum Outline { sameOutline = -1, noOutline,
                 under = 1, right = 2, over = 4, left = 8 };
  enum CharWidth { sameWidth = -1, singleWidth, doubleWidth, mixedWidth };
  enum Modification { sameModification = -1, unmodified, modified };
  //
  // Implementation Note:
  //
  // If you change the order of the colors, you MUST update the
  // look-up arrays in the .C file for this class!
  //
};

class Field3270 {
 private:
  int startPos_;
  int endPos_;
  Attr3270::Intensity intensity_;
  Attr3270::Protection protection_;
  Attr3270::Hilite hilite_;
  Attr3270::Color color_;
  int outline_;
  Attr3270::CharWidth charWidth_;
  Attr3270::Modification modification_;
 public:
  Field3270();
  void setDefaultAttributes();
  void startPos(int startPos) { startPos_ = startPos; }
  int startPos() { return startPos_; }
  void endPos(int endPos) { endPos_ = endPos; }
  int endPos() { return endPos_; }

  void intensity(Attr3270::Intensity i) { intensity_ = i; }
  Attr3270::Intensity intensity() { return intensity_; }
  void protection(Attr3270::Protection p) { protection_ = p; }
  Attr3270::Protection protection() { return protection_; }
  void hilite(Attr3270::Hilite h) { hilite_ = h; }
  Attr3270::Hilite hilite() { return hilite_; }
  void color(Attr3270::Color c) { color_ = c; }
  Attr3270::Color color() { return color_; }
  void outline(int o) { outline_ = o; }
  int outline() { return outline_; }
  void charWidth(Attr3270::CharWidth w) { charWidth_ = w; }
  Attr3270::CharWidth charWidth() { return charWidth_; }
  void modification(Attr3270::Modification m) { modification_ = m; }
  Attr3270::Modification modification() { return modification_; }
};

class Console;

class Virtual3270 {

private:

  int cursorAddr_;
  int bufferAddr_;

  int  lines_;
  int  columns_;
  int  cells_;
  Bool canDoColor_;
  Bool canDoUnderscore_;
  int  alarm_;
  int  dbcsAdjust_;
  int  fourColorMode_;

  static Console* pConsole;

  char* scr;
  Sequence<Field3270*> fields;
  Cursor<Field3270*> fieldIter;

  void lines(int lines) { lines_ = lines; }
  void columns(int columns) { columns_ = columns; }
  void cells(int cells) { cells_ = cells; }
  void canDoColor(Bool boolean) { canDoColor_ = boolean; }
  void canDoUnderscore(Bool boolean) { canDoUnderscore_ = boolean; }
  int alarm() { return alarm_; }
  void clearAlarm() { alarm_ = 0; }
  Field3270* findField(int pos);
  Field3270* searchForward(int pos, Cursor<Field3270*>& fieldIter);
  Field3270* searchBackward(int pos, Cursor<Field3270*>& fieldIter);
  Field3270* cursorUp(Cursor<Field3270*>& fieldIter);
  Field3270* cursorDown(Cursor<Field3270*>& fieldIter);
  Field3270* cursorLeft(Cursor<Field3270*>& fieldIter);
  Field3270* cursorRight(Cursor<Field3270*>& fieldIter);
  Field3270* cursorMove( Cursor<Field3270*>& fieldIter, int n );
  Field3270* tabForward(Cursor<Field3270*>& fieldIter);
  Field3270* tabBackward(Cursor<Field3270*>& fieldIter);
  Field3270* addChar(Cursor<Field3270*>& fieldIter, char* c, int cLen);
  Field3270* insertChar(Cursor<Field3270*>& fieldIter, char* c, int cLen);
  Field3270* deleteChar(Cursor<Field3270*>& fieldIter);
  Field3270* deleteEOF(Cursor<Field3270*>& fieldIter);
  void setTerminalAttributes(Field3270* field, int outlineEdges);
  void moveTerminalCursor(int pos);
  void cursorPosUp();
  void cursorPosDown();
  void cursorPosLeft();
  void cursorPosRight();
  int withinField(int addr, Field3270* field);
  void nukeFields(int endAddr);
  int wrap(int addr);
  int between(int a, int b, int c);
  void scrCopy(int startAddr, const char* s, int cnt);
  void scrSet(int startAddr, int c, int cnt);
  void drawOutline(Field3270* field, char* p, int cLen);
  void addRange(Field3270* field, char* pStart, char* pEnd);
  void terminalWrite(Field3270* field, int startAddr, int endAddr);
  void cursorAddrUp();
  void cursorAddrDown();
  void cursorAddrLeft();
  void cursorAddrRight(int n = 1);
  Field3270* advanceCursor(Cursor<Field3270*>& fieldIter, int n);
  int adjustCursor(Field3270* field);
  int length(Field3270*);
  char* findNull(char* pCursor, char* pEndSearch);
  void insertShift(char* pCursor, char* pNull, int n);
  int dbcsAdjust() { return dbcsAdjust_; }
  void dbcsAdjust(int adj) { dbcsAdjust_ = adj; }
  int fourColorMode() { return fourColorMode_; }
  void fourColorMode(int mode) { fourColorMode_ = mode; }
  void oiaWait(int on);
  void oiaInsert(int on);

 public:

  enum {
    F1    = 0x31, F2, F3, F4, F5, F6, F7, F8, F9, F10,
    F11   = 0x23,
    F12   = 0x40, F13, F14, F15, F16, F17, F18, F19, F20, F21,
    F22   = 0x5b,
    F23   = 0x2e,
    F24   = 0x3c,
    PA1   = 0x25,
    PA2   = 0x3e,
    PA3   = 0x2c,
    ENTER = 0x27
  };

  static void initialize();
  static void terminate();

  Virtual3270();
  ~Virtual3270();

  int bufferAddr() { return bufferAddr_; }
  void bufferAddr(int addr);
  int cursorAddr() { return cursorAddr_; }
  void cursorAddr(int addr) { cursorAddr_ = addr; }
  void insertCursor() { cursorAddr(bufferAddr()); }
  void soundAlarm() { alarm_ = 1; }

  //
  // Note that addr, line, and column are 0-based.  Address 0 is at line 0,
  // column 0.
  //

  int addrToLine(int addr) { return addr / columns(); }
  int addrToColumn(int addr) { return addr % columns(); }
  int addrFromLineColumn(int line, int col)
    { return line * columns() + col; }

  int lines() { return lines_; }
  int columns() { return columns_; }
  int cells() { return cells_; }
  Bool canDoColor() { return canDoColor_; }
  Bool canDoUnderscore() { return canDoUnderscore_; }

  void startField(Attr3270::Protection   p,
                  Attr3270::Modification m = Attr3270::unmodified,
                  Attr3270::Color        c = Attr3270::mono,
                  Attr3270::Hilite       h = Attr3270::noHilite,
                  Attr3270::Intensity    i = Attr3270::normal,
                  int                    o = Attr3270::noOutline,
                  Attr3270::CharWidth    w = Attr3270::singleWidth);
  void modifyField(Attr3270::Protection   p = Attr3270::sameProtection,
                   Attr3270::Modification m = Attr3270::sameModification,
                   Attr3270::Color        c = Attr3270::sameColor,
                   Attr3270::Hilite       h = Attr3270::sameHilite,
                   Attr3270::Intensity    i = Attr3270::sameIntensity,
                   int                    o = Attr3270::sameOutline,
                   Attr3270::CharWidth    w = Attr3270::sameWidth);
  int fieldLength();
  void fieldIntensity(Attr3270::Intensity);
  Attr3270::Intensity fieldIntensity();
  void fieldProtection(Attr3270::Protection);
  Attr3270::Protection fieldProtection();
  void fieldHilite(Attr3270::Hilite);
  Attr3270::Hilite fieldHilite();
  void fieldColor(Attr3270::Color);
  Attr3270::Color fieldColor();
  void fieldOutline(int);
  int fieldOutline();
  void fieldCharWidth(Attr3270::CharWidth);
  Attr3270::CharWidth fieldCharWidth();
  void fieldModification(Attr3270::Modification);
  Attr3270::Modification fieldModification();

  void erase();
  void write(const char* buf, int len);
  void repeatToAddr(int addr, char c);
  void eraseUnprotectedToAddr(int addr);
  void read(char* buf, int len);

  void show();
  int converse();

  friend class Virtual3270FieldIter;
  friend class Virtual3270ModifiedDataIter;
};

class Virtual3270FieldIter {
private:
  Virtual3270& v;
  int addr;
public:
  Virtual3270FieldIter(Virtual3270& v3270): v(v3270), addr(-1) {}
  int first();
  int next();
};

class Virtual3270ModifiedDataIter {
private:
  Virtual3270& v;
  int addr;
public:
  Virtual3270ModifiedDataIter(Virtual3270& v3270): v(v3270), addr(-1) {}
  int first();
  int next();
};
