/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWTRACE_H
#  define FCWTRACE_H

#if defined FCW_NT
#include <wtypes.h>

#elif defined FCW_AIX
#include <fcntl.h>
#endif

/*-------------------------------------------------------------------------*/
/* TraceFile class                                                         */
/*-------------------------------------------------------------------------*/
class TraceFile
{
  public:

    TraceFile();
    ~TraceFile();

    TraceFile& operator << (const char);
    TraceFile& operator << (const char*);
    TraceFile& operator << (const long);
    TraceFile& operator << (const float);
    TraceFile& operator << (TraceFile& (*f)(TraceFile&));
    TraceFile& operator << (TraceFile& (*f)(TraceFile&, long));

    void       FormatDump  (const long len=0);

    friend TraceFile& hexT (TraceFile& tf);

  private:

#if defined FCW_OS2
    FILELOCK    filelock;
    int         hFile;

#elif defined FCW_NT
    HANDLE       hFile;

#elif defined FCW_AIX
    struct flock filelock;
    int         hFile;
#endif

    Bool         bOpen;
    Bool         bFileLock;

    Bool         bHexFormat;
    Bool         bDumpFormat;
    Bool         bWithinDump;
    int          DumpLen;

    void         Hold();
    void         Release();

    void        *pImpData;                         // implementation data
};

TraceFile& EXPORT endT (TraceFile& tf);

TraceFile& EXPORT hexT (TraceFile& tf);

/*-------------------------------------------------------------------------*/
/* File locking flags                                                      */
/*-------------------------------------------------------------------------*/
#define FILELOCK_ATOMIC 0x0000000000000002
#define FILELOCK_SHARE  0x0000000000000001

//extern int TRACEOPTIONS;
//extern TraceFile* PTRACEFILE;

//#define Trace *PTRACEFILE

/*-------------------------------------------------------------------------*/
/*  Define tracing options flags here...                                   */
/*-------------------------------------------------------------------------*/
//#define VGTRACE_XXX 0x00000000
//#define VGTRACE_YYY 0x00000001

//inline
//int isVgTraceOn()
//{
//  return TRACEOPTIONS;
//}

//inline
//int isVgTraceXXX()
//{
//  return TRACEOPTIONS & VGTRACE_XXX;
//}


#endif
