/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWTBL_H
#  define FCWTBL_H

#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <stdarg.h>
#include <stdio.h>

class Table : public Parent
{
  private:
    void*         pData;

  protected:

    FCWString     name;
    int           rowCount;
    int           rowLength;
    char          genOptions;
    char          type;
    virtual void  ShowLoadError();

  public:

                  Table(char*, int, int);
    virtual       ~Table();
    int           NumRows();
    virtual void  Load();
    void          Release();
    Bool          IsKeepAfterUse();
    Bool          IsResident();
    Bool          IsShared();
    Bool          IsLoaded();
    FCWString&    Name();

    virtual Bool  ValidateItem( FCWString const& data ) { return False; }
};

/*-------------------------------------------------------------------------*/
/*  Table header information...                                            */
/*-------------------------------------------------------------------------*/
typedef struct _tblhdr
{
 short    magicNumber;
 short    pad;                         /* pad area                         */
 int      dataOffset;
 char     version;
 char     byteOrder;
 char     genOptions;
 char     type;
 short    numRows;
 short    numColumns;
} TblHdr;

/*-------------------------------------------------------------------------*/
/*  Table header magic number...                                           */
/*-------------------------------------------------------------------------*/
const short TBL_MAGIC_NUMBER = 0xBCB0;

/*-------------------------------------------------------------------------*/
/*  Table version...                                                       */
/*-------------------------------------------------------------------------*/
#define  TBL_CURRENT_VERSION           0

/*-------------------------------------------------------------------------*/
/*  Table version...                                                       */
/*-------------------------------------------------------------------------*/
#define  TBL_FORMAT_ENDIAN_MASK        0x00000001
#define  TBL_FORMAT_ASCII_MASK         0x00000010

#define  TBL_FORMAT_ENDIAN_LITTLE_ASCII  0x00000000
#define  TBL_FORMAT_ENDIAN_BIG_ASCII     0x00000001

/*-------------------------------------------------------------------------*/
/*  Table generation options...                                            */
/*-------------------------------------------------------------------------*/
#define  TBL_OPT_FOLD                  0x01
#define  TBL_OPT_RESIDENT              0x02
#define  TBL_OPT_SHARED                0x04
#define  TBL_OPT_KEEPAFTERUSE          0x08
#define  TBL_OPT_NOKEEPAFTERUSE        0x00

/*-------------------------------------------------------------------------*/
/*  Table type...                                                          */
/*-------------------------------------------------------------------------*/
#define  TBL_TYPE_UNSPECIFIED          0
#define  TBL_TYPE_MATCHVALID           1
#define  TBL_TYPE_MATCHINVALID         2
#define  TBL_TYPE_RANGE                3
#define  TBL_TYPE_MESSAGE              4


class MatchValidTable : public Table
{
  private:
    void*    pData;

  protected:
    virtual Item&  FirstColumn()=0;

  public:

                 MatchValidTable(char* tblName, int rowLen, int fKeepAfterUse);
    virtual      ~MatchValidTable();
    virtual Bool ValidateItem( FCWString const& data );
};


class MatchInvalidTable : public Table
{
  private:
    void*    pData;

  protected:
    virtual Item&  FirstColumn()=0;

  public:

                 MatchInvalidTable(char* tblName, int rowLen, int fKeepAfterUse );
    virtual      ~MatchInvalidTable();
    virtual Bool ValidateItem( FCWString const& data );
};

class RangeValidTable : public Table
{
  private:
    void*    pData;

  protected:
    virtual Item&   FirstColumn()=0;
    virtual Item&   SecondColumn()=0;
    Bool            CheckCol2( int, FCWString const& );

  public:

                 RangeValidTable(char* tblName, int rowLen, int fKeepAfterUse );
    virtual      ~RangeValidTable();
    virtual Bool ValidateItem( FCWString const& data );
};

class TBLNUM;

class MessageTable : public Table
{
  private:
    void*    pData;

  protected:
    Bool             nlsIdSet;
    virtual TBLNUM&  MsgNumColumn()=0;
    virtual Item&    MsgTxtColumn()=0;
    void             SetLanguage();

  public:

                 MessageTable(char* tblName, int rowLen, int fKeepAfterUse );
    virtual      ~MessageTable();
    void         RetrieveMsg( int, char*, int );
    virtual void Load();
};


struct TblEntry;
class ShareTblList
{
  private:
     LIST( TblEntry* )  LTables;

  public:
     ShareTblList();
     ~ShareTblList();
     char*              Contains( char* );
     char*              GetSharedTbl( char*, long, Bool, Bool& );
     void               FreeSharedTbl( char* );
     void               UpdateCount( char* );
     void               SetTableLoaded( char* );
};

/*-------------------------------------------------------------------------*/
/*  TBLBIN2                                                                */
/*-------------------------------------------------------------------------*/

class TBLBIN2 : public BIN2
{
  private:
    void*    pData;

  public:
    TBLBIN2 (Parent&, Level, int, int, int, int, int=0);
    TBLBIN2 (const TBLBIN2& tb, int index);
    virtual ~TBLBIN2();

    void operator = (const BIN2&);
    void operator = (const TBLBIN2&);
    virtual void operator = (const quadnum& v);
    TBLBIN2 operator [] (quadnum) const;
    int Contains( const quadnum&, int=1);
    int Contains( const quadnum&, NumItem& );

};

/*-------------------------------------------------------------------------*/
/*  TBLBIN4                                                                */
/*-------------------------------------------------------------------------*/

class TBLBIN4 : public BIN4
{
  private:
    void*    pData;

  public:
    TBLBIN4 (Parent&, Level, int, int, int, int, int=0);
    TBLBIN4 (const TBLBIN4& tb, int index);
    virtual ~TBLBIN4();

    void operator = (const BIN4&);
    void operator = (const TBLBIN4&);
    virtual void operator = (const quadnum& v);
    TBLBIN4 operator [] (quadnum) const;
    int Contains( const quadnum&, int=1);
    int Contains( const quadnum&, NumItem& );

};

/*-------------------------------------------------------------------------*/
/*  TBLBIN8                                                                */
/*-------------------------------------------------------------------------*/

class TBLBIN8 : public BIN8
{
  private:
    void*    pData;

  public:
    TBLBIN8 (Parent&, Level, int, int, int, int, int=0);
    TBLBIN8 (const TBLBIN8& tb, int index);
    virtual ~TBLBIN8();

    void operator = (const BIN8&);
    void operator = (const TBLBIN8&);
    virtual void operator = (const quadnum& v);
    TBLBIN8 operator [] (quadnum) const;
    int Contains( const quadnum&, int=1);
    int Contains( const quadnum&, NumItem& );

};

/*-------------------------------------------------------------------------*/
/*  TBLNUM                                                                 */
/*-------------------------------------------------------------------------*/

class TBLNUM : public NUM
{
  private:
    void*    pData;

  public:
    TBLNUM (Parent&, Level, int, int, int, int, int=0);
    TBLNUM (const TBLNUM& tb, int index);
    virtual ~TBLNUM();

    void operator = (const NUM&);
    void operator = (const TBLNUM&);
    virtual void operator = (const quadnum& v);
    void operator = (const CHA& v);
    TBLNUM operator [] (quadnum) const;
    int Contains( const quadnum&, int=1);
    int Contains( const quadnum&, NumItem& );
    int Contains( const CHA&, int=1);
    int Contains( const CHA&, NumItem& );

};

/*-------------------------------------------------------------------------*/
/*  TBLNUMC                                                                */
/*-------------------------------------------------------------------------*/

class TBLNUMC : public NUMC
{
  private:
    void*    pData;

  public:
    TBLNUMC (Parent&, Level, int, int, int, int, int=0);
    TBLNUMC (const TBLNUMC& tb, int index);
    virtual ~TBLNUMC();

    void operator = (const NUMC&);
    void operator = (const TBLNUMC&);
    virtual void operator = (const quadnum& v);
    TBLNUMC operator [] (quadnum) const;
    int Contains( const quadnum&, int=1);
    int Contains( const quadnum&, NumItem& );

};

/*-------------------------------------------------------------------------*/
/*  TBLPACK                                                                */
/*-------------------------------------------------------------------------*/

class TBLPACK : public PACK
{
  private:
    void*    pData;

  public:
    TBLPACK (Parent&, Level, int, int, int, int, int=0);
    TBLPACK (const TBLPACK& tb, int index);
    virtual ~TBLPACK();

    void operator = (const PACK&);
    void operator = (const TBLPACK&);
    virtual void operator = (const quadnum& v);
    TBLPACK operator [] (quadnum) const;
    int Contains( const quadnum&, int=1);
    int Contains( const quadnum&, NumItem& );

};

/*-------------------------------------------------------------------------*/
/*  TBLPACF                                                                */
/*-------------------------------------------------------------------------*/

class TBLPACF : public PACF
{
  private:
    void*    pData;

  public:
    TBLPACF (Parent&, Level, int, int, int, int, int=0);
    TBLPACF (const TBLPACF& tb, int index);
    virtual ~TBLPACF();

    void operator = (const PACF&);
    void operator = (const TBLPACF&);
    virtual void operator = (const quadnum& v);
    TBLPACF operator [] (quadnum) const;
    int Contains( const quadnum&, int=1);
    int Contains( const quadnum&, NumItem& );

};


/*-------------------------------------------------------------------------*/
/*  TBLCHA                                                                 */
/*-------------------------------------------------------------------------*/

class TBLCHA : public CHA
{
  private:
    void*    pData;

  public:

    TBLCHA (Parent&, Level, int, int, int, int);
    TBLCHA (const TBLCHA& tb, int index);
    virtual ~TBLCHA();

    void operator = (const CHA& v);
    void operator = (const TBLCHA&);
    TBLCHA  operator [] (quadnum) const;

    friend class HEX;
    void operator = (const HEX& v);

    friend class MIX;
    void operator = (const MIX& v);

    friend class NUM;
    void operator = (const NUM& v);

    void operator = (const char *v);
    void operator = (const int v );
    void operator = (const quadnum& v );
    int Contains( const FCWString v, const quadnum i);
    int Contains( const NUM&      v, const quadnum i);

};

/*-------------------------------------------------------------------------*/
/*  TBLDBCS                                                                */
/*-------------------------------------------------------------------------*/

class TBLDBCS : public DBCS
{
  private:
    void*    pData;

  public:

    TBLDBCS (Parent&, Level, int, int, int, int);
    TBLDBCS (const TBLDBCS& tb, int index);
    virtual ~TBLDBCS();

    // Interactions with other DBCS objects
    void operator =  (const DBCS& v);
    void operator = (const TBLDBCS&);

    // Interactions with character literals
    void operator =  (const char *v);

    TBLDBCS operator [] (quadnum) const;
    int Contains( const FCWString v, const quadnum i);

};

/*-------------------------------------------------------------------------*/
/*  TBLMIX                                                                 */
/*-------------------------------------------------------------------------*/

class TBLMIX : public MIX
{
  private:
    void*    pData;

  public:

    TBLMIX (Parent&, Level, int, int, int, int);
    TBLMIX (const TBLMIX& tb, int index);
    virtual ~TBLMIX();

    // Interactions with other MIX objects
    void operator =  (const MIX& v);
    void operator = (const TBLMIX&);
    void operator =  (const CHA& v);

    // Interactions with character literals
    void operator =  (const char *v);

    TBLMIX operator [] (quadnum) const;
    int Contains( const FCWString v, const quadnum i);

};

/*-------------------------------------------------------------------------*/
/*  TBLHEX                                                                 */
/*-------------------------------------------------------------------------*/

class TBLHEX : public HEX
{
  private:
    void*    pData;

  public:

    TBLHEX (Parent&, Level, int, int, int, int);
    TBLHEX (const TBLHEX& tb, int index);
    virtual ~TBLHEX();

    // Interactions with other HEX objects
    void operator =  (const HEX& v);
    void operator = (const TBLHEX&);
    void operator =  (const CHA& v);

    // Interactions with character literals
    void operator =  (const char *v);

    TBLHEX operator [] (quadnum) const;
    int Contains( const FCWString v, const quadnum i);

};

/*-------------------------------------------------------------------------*/
/*  FCW Message table class...                                             */
/*-------------------------------------------------------------------------*/
class FCWMsgTable : public MessageTable
{
  protected:
     TBLNUM   MsgNumber;
     TBLCHA   MsgText;
     TBLNUM&  MsgNumColumn() { return MsgNumber; };
     Item&    MsgTxtColumn() { return (Item&) MsgText; };

  public:
     FCWMsgTable();
     void ShowLoadError();
};

#endif
