/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*  PQ01683 - cpb - support LUWCONTROL=CLIENT                                */
/*****************************************************************************/
#ifndef FCWSYS_H
#  define FCWSYS_H

/*---------------------------------------------------------------------------*/
/*  System values for EZESYS                                                 */
/*---------------------------------------------------------------------------*/
#define    SYS_WINDOWS            "WINNT"
#define    SYS_OS2                "OS2"
#define    SYS_AIX                "AIX"
#define    SYS_OS2CICS            "OS2CICS"
#define    SYS_NTCICS             "NTCICS"
#define    SYS_AIXCICS            "AIXCICS"
#define    SYS_HP                 "HP"

#define    FCWPPID                "FCWPPID"

/*---------------------------------------------------------------------------*/
/*  System defines                                                           */
/*---------------------------------------------------------------------------*/
const STDOUT=1;
const STDERR=2;

/*---------------------------------------------------------------------------*/
/*  Runtime return codes                                                     */
/*---------------------------------------------------------------------------*/
#if defined FCW_OS2
const USER_ABEND_ERROR      = ERROR_USER_DEFINED_BASE;
const INITIALIZATION_ERROR  = ERROR_USER_DEFINED_BASE+1;
const INVALID_NLS_PARAMETER = ERROR_USER_DEFINED_BASE+3;  //to be consistent with Developer return codes

#elif defined FCW_NT
const USER_ABEND_ERROR      = APPLICATION_ERROR_MASK;
const INITIALIZATION_ERROR  = APPLICATION_ERROR_MASK+1;
const INVALID_NLS_PARAMETER = APPLICATION_ERROR_MASK+3;/* to be consistent with Developer return codes*/

#elif defined FCW_AIX || defined FCW_HP
const USER_ABEND_ERROR      = 0xff00;  /* ??? Use OS/2's value for now.    */
const INITIALIZATION_ERROR  = 0XFF01;
const INVALID_NLS_PARAMETER = 0xff03;
#endif

/*---------------------------------------------------------------------------*/
/* System mutually exclusive semaphore object                                */
/*---------------------------------------------------------------------------*/
class SysEventSem
{
  private:
#if defined FCW_OS2
     HEV    hev;
#elif defined FCW_AIX || FCW_HP
     int    hev;
#elif defined FCW_NT
     HANDLE hev;
#endif
     char*  name;
  public:
     SysEventSem( char* );
     ~SysEventSem();
     void Post();
     void Wait();
};

/*---------------------------------------------------------------------------*/
/* DLL handle types                                                          */
/*---------------------------------------------------------------------------*/
#if defined FCW_OS2
#define   APP_MODULE_TYPE     HMODULE
#define   FILE_MAP_HANDLE     PVOID

#elif defined FCW_NT
#define   APP_MODULE_TYPE     HMODULE
#define   FILE_MAP_HANDLE     HANDLE

#elif defined FCW_AIX || defined FCW_HP
typedef void* APP_MODULE_TYPE;
typedef void* FILE_MAP_HANDLE;
#endif

const int MSG_NUM_MAX = 4;
const int MSG_TXT_MAX = 250;
const int MSG_TBL_ROW = MSG_NUM_MAX + MSG_TXT_MAX;

extern int (*MFCobolCall)(char*, int, void**);
class CHA;                             /* Forward declaration              */

#if defined( FCW_NT ) && defined( FCW_VA_CPP )
   typedef int (* __cdecl PFV) ();
#else
   typedef void (*PFV)();
#endif

/*---------------------------------------------------------------------------*/
/* Timer class                                                               */
/*---------------------------------------------------------------------------*/
class Timer {
   public:
      virtual void reset() = 0;
      virtual void start() = 0;
      virtual void stop() = 0;
      virtual void split(char*) = 0;
};

enum IPCDirection { IPCSend, IPCReceive };
class Environment;                     /* Forward reference                */
class FCWApp;                          /* Forward reference                */

/*---------------------------------------------------------------------------*/
/* Define prefixes for shared memory and semaphore names.                    */
/*---------------------------------------------------------------------------*/
#if defined(FCW_OS2)
#define   PREFIX_SHARED_MEMORY_NAME        "\\SHAREMEM\\FCW"
#define   PREFIX_SEMAPHORE_NAME            "\\SEM32\\FCW"

#elif defined FCW_NT
#define   PREFIX_SHARED_MEMORY_NAME        "SHAREMEMFCW"
#define   PREFIX_SEMAPHORE_NAME            "SEM32FCW"

#elif defined FCW_AIX || FCW_HP
#define   PREFIX_SHARED_MEMORY_NAME        "/tmp/fcwipc"
#define   PREFIX_SEMAPHORE_NAME            "/tmp/fcwipc"
#endif

#define LENGTH_SHARED_MEMORY_NAME   32
#define LENGTH_SEMAPHORE_NAME       32

struct tm;
/*---------------------------------------------------------------------------*/
/* SystemCalls class - an object of this type cannot be created.  A derived  */
/*                     class must be defined.                                */
/*---------------------------------------------------------------------------*/
class SystemCalls
{
   protected:
      SystemCalls();

   public:
      virtual ~SystemCalls();
      /*---------------------------------------------------------------------*/
      /* General functions                                                   */
      /*---------------------------------------------------------------------*/
      char*        GetEnvVar(char*);
      void         PutEnvVar(char*, char*);
      char*        SysStrupr(char*);
      char*        SysStrlwr(char*);
      void         SysSetLocale();
      PFN          SysLoadApp(char*, char*, int);
      virtual PFV  SysLoadModule(FCWString, FCWString);
      void         SysFreeModule( PFV )               ;
      FILE*        SysLoadTable( char* );
      void         SysSwapBytes( void*, int  );
      void         SysGetDefaultDateFormat( int, char* );
      void         SysGetNumericSymbols( FCWString&, char&, char&);
      void         SysSetMemRO( char*, long );
      wchar_t      SysDBCSBlank();
      Bool         SysIsDBCSChar(char);
      wchar_t      SysDBCSAsterisk();
      void         SysFoldString(FCWString& str);
      void         SysAddMsgInserts( char* [], long, char*, long, char*, long,
                                     unsigned long * );
      static char* SysProductDirectory();
      static PFV   SysLoadSysMod(FCWString, FCWString);
      static void  SysUnloadSysMod( );
      int          SysSearchPath(const char*, const char*, FCWString&);
      struct tm*   SysGetLocalTime();

      /*---------------------------------------------------------------------*/
      /* Interprocess communication block routines                           */
      /*---------------------------------------------------------------------*/
      void         SysSetupIPC (IPCDirection);
      char*        SysGetIPCBlock (FILE_MAP_HANDLE&);
      char*        SysAllocIPCBlock (long, FILE_MAP_HANDLE&);
      void         SysFreeIPCBlock (char*, FILE_MAP_HANDLE );
      void         SysSetSignal(void);
      void         SysStartIPC(void);
      void         SysReleaseIPC (void);
      void         SysWaitIPC(char*);

      /*---------------------------------------------------------------------*/
      /* Timer functions                                                     */
      /*---------------------------------------------------------------------*/
      static Timer* SysNewTimer();

      /*---------------------------------------------------------------------*/
      /* The following virtual functions are implemented here or as part of  */
      /* this class but can be overridden in a derived class as needed.      */
      /*                                                                     */
      /* If MVSCICS style shared tables are implemented, SysAllocSharedTable */
      /* and SysFreeSharedTable will need to be overridden in the CICS       */
      /* system class to do the implementation.                              */
      /*---------------------------------------------------------------------*/
      virtual char*        SysAllocSharedTable( char*, long, FILE_MAP_HANDLE& ) ;
      virtual void         SysFreeSharedTable( char*, FILE_MAP_HANDLE );
      virtual void         SysPrintMap(char*, char*)          {};
      virtual FILE*        SysLoadRSC( char* )                { return NULL; };
      virtual void         SysPurgeCICSQueue( char* )         {};
      virtual void         SysinitCICS( FCWApp* )             {};
      virtual void         SysCICStransfer(void* ,char* )     {};
      virtual Bool         SysCICSRetrieveData(char* , long)  { return False; };
      virtual void         SysCICSLink(char* , FCWCICSLinkage* , void*, int) {};
      virtual long         SysCICSWriteqFCWD( char* )         { return 0L; };
      virtual long         SysCICSAbendHdlr()                 { return 0L; };
      virtual long         SysCICSXfer2ERRA()                 { return 0L; };
      virtual int          SysGetEIBLen( void* pEIB )         { return 0; };
      virtual void         SysCreatxExecCICS(void* ,FCWCICSLinkage* , int , char*) {};
      virtual FCWString    SysGetTransID()                    { return "    "; };
      virtual int          SysEnq( char* )                    { return 1; }
      virtual int          SysDeq( char* )                    { return 1; }

      virtual int          SysCommit()                        { return 0; }
      virtual int          SysRollBack()                      { return 0; }
      virtual long         SysCICSSet12BRCinCOMMA( Bool )     { return 0; }  /* PQ01683 */
      virtual void         SysCICSWriteTSQ( FCWString&,void*,short,short,Bool,Bool ) {};
      virtual int          SysDeleteTSQ( char* )              { return 0; };
      virtual void         SysCICSReadTSQ( FCWString&, void*, short*, short ) {};
      virtual void         SysCICSReturn( const FCWString&, char*, long ) {};
      virtual void         SysCICSXCTL( char*, void*, long )  {};
      virtual void         SysCICSStart( char*, void*, long ) {};

      /*---------------------------------------------------------------------*/
      /* The following functions are pure virtual and must be overridden in  */
      /* any derived class.                                                  */
      /*---------------------------------------------------------------------*/
      virtual unsigned int SysExecPgm(char* name, char* parm)           = 0;
      virtual void         SysAssignDefaultEZEDESTP(FCWString&, char *) = 0;
      virtual void         SysExit(int)                                 = 0;
      virtual FCWString    SysValue()                                   = 0;
      virtual FCWString    SysLterm()                                   = 0;
      virtual FCWString    SysUsr()                                     = 0;
      virtual FCWString    SysUsrid()                                   = 0;
      virtual void         SysSleep(int)                                = 0;
      virtual Bool         SysIsCICS()                                  = 0;

      /*---------------------------------------------------------------------*/
      /* This function is probably not needed.                               */
      /*---------------------------------------------------------------------*/
      void  SysConvertData( char*, int, ItemType, char, FILE* );
      FILE* SysOpenConversionTable( char* table );
      void  SysCloseConversionTable( FILE* fpTable );

   private:
      Bool  ValidateMask(const char*, int, int);
      char  SharedMemName[LENGTH_SHARED_MEMORY_NAME];
      char  SemaphoreName[LENGTH_SEMAPHORE_NAME];
      Environment* env;
};


void   SysCallRCLConstructors(void* addr);
void   SysCallRCLDestructors();

#if defined( FCW_APPLICATION ) && defined ( FCW_NT )
   __declspec( dllimport ) SystemCalls* pSystem;
#else
   extern SystemCalls* pSystem;
#endif

#endif
