/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWPRT_H
#define FCWPRT_H

#include <fstream.h>

class eMap;

struct PrintInfo
{
   public:
      PrintInfo(char*, char*);
      virtual ~PrintInfo() {};

      FCWString&   Name()      { return name;  }
      void         Name(FCWString& n) { name = n;  }
      FCWString&   Destp()     { return destp; }
      int          Fixedline() { return fixedline; }
      void         SetFixedline(int n) { fixedline = n; }
      int          Floatline() { return floatline; }
      void         SetFloatline(int n) { floatline = n; }
      void         eject();

               PrintInfo& operator<< (PrintInfo& (*f)(PrintInfo&))
                                                   { return (*f)(*this) ; }
      virtual  PrintInfo& operator <<(FCWString& str) = 0;
      virtual  PrintInfo& operator <<(char       ch ) = 0;
      virtual  void       write(char*, long)          = 0;
   private:
      int          fixedline;
      int          floatline;
      FCWString    name;               /* OS/2: name of file or device     */
                                      // AIX:  name of file
      FCWString    destp;              /* OS/2: name of file or device     */
                                      // AIX:  name of file
                                      // TDD for AIXCICS
};


PrintInfo&        endl(PrintInfo& i);

//----------------------------------------------------------------------------
// PrintIODriver                                                             -
//----------------------------------------------------------------------------
// The PrintIODriver structure contains pointers the the appropriate         -
// environment specific function which does the desired service. This        -
// structure is initialized by the driver when it is loaded and called for   -
// initialization.                                                           -
//----------------------------------------------------------------------------
struct PrintIODriver
{
  PrintInfo*  (*pGetPrintInfo) ( char*, char*, char*, char, Bool );
  void        (*pGetPrintDest) ( CHA&, FCWString&, FCWString&, char&, Bool& );
  void        (*pCloseDest)    ( CHA& );
};

class iMap;

class PrintDriver
{
   public:
      PrintDriver();
      ~PrintDriver();

      void                Display (iMap*, eMap*);
      void                Close();

      LIST(PrintInfo*)&   pPrintInfoList() { return list_pPrintInfo; }

   private:
      void                formatOutput(iMap*, eMap*);
      void                bufferChaining(iMap*, eMap*);
      void                ejectPage();
      void                positionfloat(eMap*);
      void                positionfixed(eMap*);
      PrintInfo*          find(CHA&);

      PrintInfo*          pPrintInfo;
      LIST(PrintInfo*)    list_pPrintInfo;
      PrintIODriver       drv_PD;
};

#endif
