/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWPARM_H
#define FCWPARM_H

// *********************************************************************
// Base for all objects that can be passed as call parms
// *********************************************************************

// For RPC
#define RPCNORMAL   0
#define RPCSQL      1
#define RPCMAP      2
#define RPCEZEDLPSB 3

struct RPCParm
{
  long     length;
  ItemType type;
  int      specialType;
  int      occurs;
  int      level;
  int      group;
  int      offset;
  long     numberOfFields;          /* Used to build data format descriptor*/
  short    RLIflag;
  short    NOIflag;
};
class LitParm;

class Parameter
{
   public:
      Parameter();
      virtual ~Parameter();

      virtual long ParmSize() = 0;
      virtual char* ParmData() = 0;
      virtual Bool  isFileRecord() { return False; };

      // For RPC
      virtual LIST(RPCParm*)& RPCList() = 0;
      virtual int& fNumberOfRPCEntries() = 0;
      virtual void SetupRpc() = 0;

   private:
      void* pData;
};

// For RPC
struct FCWCallRPCBlock
{
  struct
  {
    Parameter *parmPtr;
  } parm[30];
};

#endif
