/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*    5622-585 VisualAge Generator Workgroup Services for OS/2 V2.2          */
/*    5622-587 VisualAge Generator Workgroup Services for AIX V2.2           */
/*    5639-A26 VisualAge Generator Workgroup Services for Windows NT V2.2    */
/*                     (C) COPYRIGHT IBM CORP. 1994,1996                     */
/*                                                                           */
/*****************************************************************************/
#ifndef  FCWMSQI_H
#define  FCWMSQI_H

// --------------------------------------------------------------------
//  Declare forword reference
// --------------------------------------------------------------------

class MAPDBCS;
class TBLDBCS;

// ---------------------------------------------------------------------
// SQLBIN2
// ---------------------------------------------------------------------

class SQLBIN2 : public BIN2
{
    enum { SQL_NULL_DATA = -1 };

  public:

    SQLBIN2 (Parent&, Level, int, int, int, int, int=0);

    void SetNull( short ) const;
    void SetNull() const;
    short GetNull() const;
    Bool IsNull() const;
    Bool IsTrunc() const;
    void SetEmpty() const;

    void operator = (const SQLBIN2&);
    void operator = (const quadnum& v);

};

// --------------------------------------------------------------------
// SQLBIN4
// --------------------------------------------------------------------

class SQLBIN4 : public BIN4
{
    enum { SQL_NULL_DATA = -1 };

  public:

    SQLBIN4 (Parent&, Level, int, int, int, int, int=0);

    void SetNull( short ) const;
    void SetNull() const;
    short GetNull() const;
    Bool IsNull() const;
    Bool IsTrunc() const;
    void SetEmpty () const;

    void operator = (const SQLBIN4&);
    void operator = (const quadnum& v);

};

// --------------------------------------------------------------------
// SQLPACK
// --------------------------------------------------------------------

class SQLPACK : public PACK
{
    enum { SQL_NULL_DATA = -1 };

  public:

    SQLPACK (Parent&, Level, int, int, int, int, int=0);

    void SetNull( short ) const;
    void SetNull() const;
    short GetNull() const;
    Bool IsNull() const;
    Bool IsTrunc() const;
    void SetEmpty () const;

    void operator = (const SQLPACK&);
    void operator = (const quadnum& v);

};


// --------------------------------------------------------------------
// SQLCHA
// --------------------------------------------------------------------

class SQLCHA : public CHA
{
    enum { SQL_NULL_DATA = -1 };

  public:

    SQLCHA (Parent&, Level, int, int, int, int);

    void SetNull( short ) const;
    void SetNull() const;
    short GetNull() const;
    Bool IsNull() const ;
    Bool IsTrunc() const;
    void SetEmpty () const;

    void operator = (const SQLCHA& v);
    void operator = (const CHA& v);

    friend class HEX;
    void operator = (const HEX& v);

    friend class MIX;
    void operator = (const MIX& v);

    friend class NUM;
    void operator = (const NUM& v);

    void operator = (const char *v);

    void operator = (const int v);

    void operator =  (const quadnum& v );

};

// -----------------------------------------------------------------
// SQLDBCS
// -----------------------------------------------------------------

class SQLDBCS : public DBCS
{
    enum { SQL_NULL_DATA = -1 };

  public:

    SQLDBCS (Parent&, Level, int, int, int, int);

    void SetNull( short ) const;
    void SetNull() const;
    short GetNull() const;
    Bool IsNull() const;
    Bool IsTrunc() const;
    void SetEmpty () const;

    // Interactions with other DBCS objects
    void operator =  (const DBCS& v);
    void operator =  (const SQLDBCS& v);
    void operator =  (const MAPDBCS& v);
    void operator =  (const TBLDBCS& v);

    // Interactions with character literals
    void operator =  (const char *v);

};

// --------------------------------------------------------------------
// SQLHEX
// --------------------------------------------------------------------

class SQLHEX : public HEX
{
    enum { SQL_NULL_DATA = -1 };

  public:

    SQLHEX (Parent&, Level, int, int, int, int);


    void SetNull( short ) const;
    void SetNull() const;
    short GetNull() const;
    Bool IsNull() const;
    Bool IsTrunc() const;
    void SetEmpty () const;

    // Interactions with other HEX objects
    void operator =  (const SQLHEX& v);
    void operator =  (const HEX& v);

    // Interactions with character literals
    void operator =  (const char *v);

};


#endif
